/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public final class AccessController {
    private AccessController() {
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessController.getContext().checkPermission(permission);
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        return privilegedAction.run();
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return privilegedAction.run();
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static AccessControlContext getContext() {
        return new AccessControlContext(new ProtectionDomain[0]);
    }
}

