/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import gnu.java.security.provider.SHA1PRNG;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter;
    Provider provider;
    byte[] randomBytes;
    int randomBytesUsed;
    SecureRandomSpi secureRandomSpi;
    byte[] state;

    private /* synthetic */ void finit$() {
        this.counter = 0L;
        this.provider = null;
        this.randomBytes = null;
        this.randomBytesUsed = 0;
        this.secureRandomSpi = null;
        this.state = null;
    }

    public SecureRandom() {
        this.finit$();
        Provider[] providerArray = Security.getProviders();
        String string = null;
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("SECURERANDOM.") || (string = providerArray[i].getProperty(string2)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(string).newInstance();
                    this.provider = providerArray[i];
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                }
            }
        }
        this.secureRandomSpi = new SHA1PRNG();
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.finit$();
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SecureRandom.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SecureRandom.getInstance(string, provider);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new SecureRandom((SecureRandomSpi)Engine.getInstance(SECURE_RANDOM, string, provider), provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    public void setSeed(long l) {
        if (this.secureRandomSpi != null) {
            byte[] byArray = new byte[]{(byte)(l >> 56) & 0xFFFFFFFF, (byte)(l >> 48) & 0xFFFFFFFF, (byte)(l >> 40) & 0xFFFFFFFF, (byte)(l >> 32) & 0xFFFFFFFF, (byte)(l >> 24) & 0xFFFFFFFF, (byte)(l >> 16) & 0xFFFFFFFF, (byte)(l >> 8) & 0xFFFFFFFF, (byte)l & 0xFFFFFFFF};
            this.secureRandomSpi.engineSetSeed(byArray);
        }
    }

    public void nextBytes(byte[] byArray) {
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        if (n == 0) {
            return 0;
        }
        byte[] byArray = new byte[n / 8 + 1 * (n % 8)];
        this.secureRandomSpi.engineNextBytes(byArray);
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 |= (byArray[i] & 0xFF) << (8 * i & 0x1F);
        }
        long l = (1L << (n & 0x3F)) - 1L;
        return (int)l & n2;
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        new Random().nextBytes(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    static {
        SECURE_RANDOM = SECURE_RANDOM;
    }
}

