/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.InvalidObjectException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class DateFormat
extends Format
implements Cloneable {
    private static final long serialVersionUID = 7218322306649953788L;
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    public static final int ISO_YEAR_FIELD = 18;
    public static final int LOCALIZED_DAY_OF_WEEK_FIELD = 19;
    public static final int EXTENDED_YEAR_FIELD = 20;
    public static final int MODIFIED_JULIAN_DAY_FIELD = 21;
    public static final int MILLISECOND_IN_DAY_FIELD = 22;
    public static final int RFC822_TIMEZONE_FIELD = 23;

    protected DateFormat() {
    }

    public boolean equals(Object object) {
        TimeZone timeZone;
        if (!(object instanceof DateFormat)) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)object;
        TimeZone timeZone2 = this.getTimeZone();
        if (timeZone2.hasSameRules(timeZone = dateFormat.getTimeZone()) && this.isLenient() == dateFormat.isLenient()) {
            Calendar calendar = this.getCalendar();
            Calendar calendar2 = dateFormat.getCalendar();
            if (calendar == null && calendar2 == null || calendar.getFirstDayOfWeek() == calendar2.getFirstDayOfWeek() && calendar.getMinimalDaysInFirstWeek() == calendar2.getMinimalDaysInFirstWeek()) {
                return this.numberFormat == null && dateFormat.numberFormat == null || this.numberFormat.equals(dateFormat.numberFormat);
            }
        }
        return false;
    }

    public Object clone() {
        return super.clone();
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            object = new Date(((Number)object).longValue());
        } else if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return this.format((Date)object, stringBuffer, fieldPosition);
    }

    public final String format(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(date, stringBuffer, new FieldPosition(2));
        return stringBuffer.toString();
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public static Locale[] getAvailableLocales() {
        Locale[] localeArray = new Locale[]{Locale.US};
        return localeArray;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    private static DateFormat computeInstance(int n, Locale locale, boolean bl, boolean bl2) {
        return DateFormat.computeInstance(n, n, locale, bl, bl2);
    }

    private static DateFormat computeInstance(int n, int n2, Locale locale, boolean bl, boolean bl2) {
        String string;
        String string2;
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        String string3 = null;
        if (bl) {
            switch (n) {
                case 0: {
                    string2 = "fullDateFormat";
                    string = "EEEE MMMM d, yyyy G";
                    break;
                }
                case 1: {
                    string2 = "longDateFormat";
                    string = "MMMM d, yyyy";
                    break;
                }
                case 2: {
                    string2 = "mediumDateFormat";
                    string = "d-MMM-yy";
                    break;
                }
                case 3: {
                    string2 = "shortDateFormat";
                    string = "M/d/yy";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                string3 = resourceBundle == null ? string : resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = string;
            }
        }
        if (bl2) {
            String string4;
            string3 = string3 == null ? "" : string3 + " ";
            switch (n2) {
                case 0: {
                    string2 = "fullTimeFormat";
                    string = "h:mm:ss;S 'o''clock' a z";
                    break;
                }
                case 1: {
                    string2 = "longTimeFormat";
                    string = "h:mm:ss a z";
                    break;
                }
                case 2: {
                    string2 = "mediumTimeFormat";
                    string = "h:mm:ss a";
                    break;
                }
                case 3: {
                    string2 = "shortTimeFormat";
                    string = "h:mm a";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                string4 = resourceBundle == null ? string : resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string4 = string;
            }
            string3 = string3 + string4;
        }
        return new SimpleDateFormat(string3, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n) {
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n, Locale locale) {
        return DateFormat.computeInstance(n, locale, true, false);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        return DateFormat.computeInstance(n, n2, locale, true, true);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n) {
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n, Locale locale) {
        return DateFormat.computeInstance(n, locale, false, true);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        if (this.numberFormat != null) {
            return this.numberFormat.hashCode();
        }
        return 0;
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            int n = parsePosition.getErrorIndex();
            if (n < 0) {
                n = parsePosition.getIndex();
            }
            throw new ParseException("invalid Date syntax in \"" + string + '\"', n);
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setLenient(boolean bl) {
        this.calendar.setLenient(bl);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7441350119349544720L;
        private int calendarField;
        public static final Field ERA = new Field("era", 0);
        public static final Field YEAR = new Field("year", 1);
        public static final Field MONTH = new Field("month", 2);
        public static final Field DAY_OF_MONTH = new Field("day of month", 5);
        public static final Field HOUR_OF_DAY1 = new Field("hour of day 1", 11);
        public static final Field HOUR_OF_DAY0 = new Field("hour of day 0", 11);
        public static final Field MINUTE = new Field("minute", 12);
        public static final Field SECOND = new Field("second", 13);
        public static final Field MILLISECOND = new Field("millisecond", 14);
        public static final Field DAY_OF_WEEK = new Field("day of week", 7);
        public static final Field DAY_OF_YEAR = new Field("day of year", 6);
        public static final Field DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
        public static final Field WEEK_OF_YEAR = new Field("week of year", 3);
        public static final Field WEEK_OF_MONTH = new Field("week of month", 4);
        public static final Field AM_PM = new Field("am/pm", 9);
        public static final Field HOUR1 = new Field("hour1", 10);
        public static final Field HOUR0 = new Field("hour0", 10);
        public static final Field TIME_ZONE = new Field("timezone", 15);
        public static final Field ISO_YEAR = new Field("iso year", 1);
        public static final Field LOCALIZED_DAY_OF_WEEK = new Field("localized day of week", 7);
        public static final Field EXTENDED_YEAR = new Field("extended year", 1);
        public static final Field MODIFIED_JULIAN_DAY = new Field("julian day", -1);
        public static final Field MILLISECOND_IN_DAY = new Field("millisecond in day", -1);
        public static final Field RFC822_TIME_ZONE = new Field("rfc822 timezone", 15);
        static final Field[] allFields = new Field[]{ERA, YEAR, MONTH, DAY_OF_MONTH, HOUR_OF_DAY1, HOUR_OF_DAY0, MINUTE, SECOND, MILLISECOND, DAY_OF_WEEK, DAY_OF_YEAR, DAY_OF_WEEK_IN_MONTH, WEEK_OF_YEAR, WEEK_OF_MONTH, AM_PM, HOUR1, HOUR0, TIME_ZONE, ISO_YEAR, LOCALIZED_DAY_OF_WEEK, EXTENDED_YEAR, MODIFIED_JULIAN_DAY, MILLISECOND_IN_DAY, RFC822_TIME_ZONE};

        Field() {
            super("");
        }

        protected Field(String string, int n) {
            super(string);
            this.calendarField = n;
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public static Field ofCalendarField(int n) {
            if (n >= allFields.length || n < 0) {
                throw new IllegalArgumentException("no such calendar field (" + n + ")");
            }
            return allFields[n];
        }

        protected Object readResolve() throws InvalidObjectException {
            String string = this.getName();
            for (int i = 0; i < allFields.length; ++i) {
                if (!string.equals(allFields[i].getName())) continue;
                return allFields[i];
            }
            throw new InvalidObjectException("no such DateFormat field called " + string);
        }
    }
}

