/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class RuleBasedCollator
extends Collator {
    private String rules;
    private Object[] ce_table;
    HashMap prefix_tree;
    private int last_primary_value;
    private int last_tertiary_value;
    private boolean inverseAccentComparison;
    static final CollationElement SPECIAL_UNKNOWN_SEQ = new CollationElement("", Short.MAX_VALUE, 0, 0, 0, null, false);

    public RuleBasedCollator(String string) throws ParseException {
        if (string.equals("")) {
            throw new ParseException("empty rule set", 0);
        }
        this.rules = string;
        this.buildCollationVector(this.parseString(string));
        this.buildPrefixAccess();
    }

    static int findPrefixLength(String string, String string2) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && n < string2.length(); ++n) {
            if (string.charAt(n) == string2.charAt(n)) continue;
            return n;
        }
        return n;
    }

    private void mergeRules(int n, String string, ArrayList arrayList, ArrayList arrayList2) throws ParseException {
        int n2;
        int n3 = -1;
        int n4 = 0;
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            int n5 = 0;
            while (n5 < arrayList.size()) {
                CollationSorter collationSorter = (CollationSorter)arrayList2.get(n2);
                CollationSorter collationSorter2 = (CollationSorter)arrayList.get(n5);
                if (collationSorter.textElement.equals(collationSorter2.textElement)) {
                    arrayList.remove(n5);
                    continue;
                }
                ++n5;
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            CollationSorter collationSorter = (CollationSorter)arrayList.get(n2);
            int n6 = RuleBasedCollator.findPrefixLength(string, collationSorter.textElement);
            if (n6 <= n4) continue;
            n4 = n6;
            n3 = n2 + 1;
        }
        if (n3 < 0) {
            throw new ParseException("no insertion point found for " + string, n);
        }
        if (n4 < string.length()) {
            CollationSorter collationSorter = (CollationSorter)arrayList2.get(0);
            CollationSorter collationSorter3 = (CollationSorter)arrayList.get(n3 - 1);
            collationSorter.expansionOrdering = string.substring(n4);
            arrayList.add(n3, collationSorter);
            arrayList2.remove(0);
            ++n3;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add(i + n3, arrayList2.get(i));
        }
    }

    private int subParseString(boolean bl, ArrayList arrayList, int n, String string) throws ParseException {
        int n2;
        int n3;
        boolean bl2 = n == 0;
        int n4 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        block10: for (n3 = 0; n3 < string.length(); ++n3) {
            Object object;
            char c = string.charAt(n3);
            n2 = -1;
            if (!bl4 && (c >= '\t' && c <= '\r' || c == ' ')) continue;
            bl6 = bl5;
            bl5 = false;
            if (bl4 && c != '\'') {
                bl3 = false;
                stringBuffer.append(c);
                continue;
            }
            if (bl3 && bl4) {
                stringBuffer.append(c);
                bl3 = false;
                continue;
            }
            switch (c) {
                case '!': {
                    throw new ParseException("Modifier '!' is not yet supported by Classpath", n3 + n);
                }
                case '<': {
                    n2 = 0;
                    break;
                }
                case ';': {
                    n2 = 1;
                    break;
                }
                case ',': {
                    n2 = 2;
                    break;
                }
                case '=': {
                    n2 = 3;
                    break;
                }
                case '\'': {
                    bl4 ^= true;
                    bl3 = true;
                    break;
                }
                case '@': {
                    if (bl2) {
                        throw new ParseException("comparison list has not yet been started. You may only use(<,;=&)", n3 + n);
                    }
                    bl5 = true;
                    n2 = 5;
                    break;
                }
                case '&': {
                    n2 = 4;
                    if (!bl) break;
                    break block10;
                }
                default: {
                    if (n4 < 0) {
                        throw new ParseException("operator missing at " + (n3 + n), n3 + n);
                    }
                    if (!bl4 && (c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~')) {
                        throw new ParseException("unquoted punctuation character '" + c + "'", n3 + n);
                    }
                    stringBuffer.append(c);
                }
            }
            if (n2 < 0) continue;
            if (n4 < 0) {
                n4 = n2;
                continue;
            }
            if (stringBuffer.length() == 0 && !bl6) {
                throw new ParseException("text element empty at " + (n3 + n), n3 + n);
            }
            if (n4 == 4) {
                object = string.substring(n3);
                ArrayList arrayList2 = new ArrayList();
                int n5 = this.subParseString(true, arrayList2, n + n3, (String)object);
                this.mergeRules(n + n3, stringBuffer.toString(), arrayList, arrayList2);
                stringBuffer.setLength(0);
                n4 = -1;
                n2 = -1;
                if (n5 < 0) break;
                n3 += n5 - 1;
                continue;
            }
            object = new CollationSorter();
            if (n4 == 0) {
                bl2 = false;
            }
            ((CollationSorter)object).comparisonType = n4;
            ((CollationSorter)object).textElement = stringBuffer.toString();
            ((CollationSorter)object).hashText = ((CollationSorter)object).textElement.hashCode();
            ((CollationSorter)object).offset = n + string.length();
            ((CollationSorter)object).ignore = bl2;
            stringBuffer.setLength(0);
            arrayList.add(object);
            n4 = n2;
        }
        if (n4 >= 0) {
            CollationSorter collationSorter = new CollationSorter();
            n2 = string.length() + n;
            if (stringBuffer.length() != 0 && bl5 || stringBuffer.length() == 0 && !bl5 && !bl4) {
                throw new ParseException("text element empty at " + n2, n2);
            }
            if (n4 == 0) {
                bl2 = false;
            }
            collationSorter.comparisonType = n4;
            collationSorter.textElement = stringBuffer.toString();
            collationSorter.hashText = collationSorter.textElement.hashCode();
            collationSorter.offset = n + n2;
            collationSorter.ignore = bl2;
            arrayList.add(collationSorter);
        }
        if (n3 == string.length()) {
            return -1;
        }
        return n3;
    }

    public Object clone() {
        return super.clone();
    }

    private ArrayList parseString(String string) throws ParseException {
        ArrayList arrayList = new ArrayList();
        this.subParseString(false, arrayList, 0, string);
        return arrayList;
    }

    private void buildCollationVector(ArrayList arrayList) throws ParseException {
        boolean bl;
        int n = 0;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = true;
        ArrayList arrayList2 = new ArrayList();
        block8: for (int i = 0; i < arrayList.size(); ++i) {
            CollationSorter collationSorter = (CollationSorter)arrayList.get(i);
            boolean bl5 = false;
            switch (collationSorter.comparisonType) {
                case 0: {
                    ++n;
                    if (bl2) {
                        s2 = Short.MAX_VALUE;
                        bl4 = bl3;
                    } else {
                        s2 = 0;
                        bl4 = bl;
                    }
                    s3 = 0;
                    s4 = 0;
                    bl2 = false;
                    break;
                }
                case 1: {
                    s2 = bl4 == bl3 ? --s2 : ++s2;
                    s3 = 0;
                    s4 = 0;
                    break;
                }
                case 5: {
                    bl2 = true;
                    continue block8;
                }
                case 2: {
                    ++s3;
                    if (n == 0) {
                        s = s3;
                    }
                    s4 = 0;
                    break;
                }
                case 3: {
                    ++s4;
                    break;
                }
                case 4: {
                    throw new ParseException("Invalid reached state 'RESET'. Internal error", collationSorter.offset);
                }
                default: {
                    throw new ParseException("Invalid unknown state '" + collationSorter.comparisonType + "'", collationSorter.offset);
                }
            }
            arrayList2.add(new CollationElement(collationSorter.textElement, n, s2, s3, s4, collationSorter.expansionOrdering, collationSorter.ignore));
        }
        this.inverseAccentComparison = bl2;
        this.ce_table = arrayList2.toArray();
        this.last_primary_value = n + 1;
        this.last_tertiary_value = s + 1;
    }

    private void buildPrefixAccess() {
        this.prefix_tree = new HashMap();
        for (int i = 0; i < this.ce_table.length; ++i) {
            CollationElement collationElement = (CollationElement)this.ce_table[i];
            this.prefix_tree.put(collationElement.key, collationElement);
        }
    }

    public int compare(String string, String string2) {
        CollationElement collationElement = null;
        CollationElement collationElement2 = null;
        boolean bl = true;
        boolean bl2 = true;
        CollationElementIterator collationElementIterator = this.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.getCollationElementIterator(string2);
        while (true) {
            short s;
            short s2;
            if (bl && (collationElement = collationElementIterator.nextBlock()) != null && collationElement.ignore) continue;
            if (bl2) {
                collationElement2 = collationElementIterator2.nextBlock();
                if (collationElement2 != null && collationElement2.ignore) {
                    bl = false;
                    continue;
                }
            } else {
                bl2 = true;
            }
            if (!bl) {
                bl = true;
            }
            if (collationElement == null) {
                if (collationElement2 == null) {
                    return 0;
                }
                return -1;
            }
            int n = collationElement.getValue();
            if (collationElement2 == null) {
                return 1;
            }
            int n2 = collationElement2.getValue();
            if (n == n2) {
                if (this.getStrength() != 3 || collationElement.key.equals(collationElement2.key)) continue;
                return collationElement.key.compareTo(collationElement2.key);
            }
            int n3 = CollationElementIterator.primaryOrder(n);
            int n4 = CollationElementIterator.primaryOrder(n2);
            if (n3 == 0 && this.getStrength() < 2) {
                bl2 = false;
                continue;
            }
            if (n4 == 0 && this.getStrength() < 2) {
                bl = false;
                continue;
            }
            if (n3 < n4) {
                return -1;
            }
            if (n3 > n4) {
                return 1;
            }
            if (this.getStrength() == 0) continue;
            short s3 = CollationElementIterator.secondaryOrder(n);
            if (s3 < (s2 = CollationElementIterator.secondaryOrder(n2))) {
                return -1;
            }
            if (s3 > s2) {
                return 1;
            }
            if (this.getStrength() == 1) continue;
            short s4 = CollationElementIterator.tertiaryOrder(n);
            if (s4 < (s = CollationElementIterator.tertiaryOrder(n2))) {
                return -1;
            }
            if (s4 > s) {
                return 1;
            }
            if (this.getStrength() != 2) break;
        }
        return collationElement.key.compareTo(collationElement2.key);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    CollationElement getDefaultElement(char n) {
        int n2 = this.inverseAccentComparison && n >= 697 && n <= 865 ? 865 - (n - 697) : n;
        return new CollationElement("" + (char)n, this.last_primary_value + n2, 0, 0, 0, null, false);
    }

    CollationElement getDefaultAccentedElement(char n) {
        int n2 = this.inverseAccentComparison && n >= 697 && n <= 865 ? 865 - (n - 697) : n;
        return new CollationElement("" + (char)n, 0, 0, (short)this.last_tertiary_value + (short)n2, 0, null, false);
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        return new CollationElementIterator(this, string);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer("");
        char c = characterIterator.first();
        while (c != '\uffff') {
            this.decomposeCharacter(c, stringBuffer);
            c = characterIterator.next();
        }
        return this.getCollationElementIterator(stringBuffer.toString());
    }

    public CollationKey getCollationKey(String string) {
        CollationElementIterator collationElementIterator = this.getCollationElementIterator(string);
        ArrayList arrayList = new ArrayList();
        int n = collationElementIterator.next();
        collationElementIterator.reset();
        while (n != -1) {
            if (CollationElementIterator.primaryOrder(n) == 0) {
                n = collationElementIterator.next();
                continue;
            }
            switch (this.getStrength()) {
                case 0: {
                    n = CollationElementIterator.primaryOrder(n);
                    break;
                }
                case 1: {
                    n = CollationElementIterator.primaryOrder(n) << 8;
                    n |= CollationElementIterator.secondaryOrder(n);
                }
            }
            arrayList.add(new Integer(n));
            n = collationElementIterator.next();
        }
        Object[] objectArray = arrayList.toArray();
        byte[] byArray = new byte[objectArray.length * 4];
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = (Integer)objectArray[i];
            byArray[i * 4] = (byte)((n2 & 0xFF000000) >> 24);
            byArray[i * 4 + 1] = (byte)((n2 & 0xFF0000) >> 16);
            byArray[i * 4 + 2] = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 4 + 3] = (byte)n2 & 0xFFFFFFFF;
        }
        return new CollationKey(this, string, byArray);
    }

    public String getRules() {
        return this.rules;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    static final class CollationSorter {
        static final int GREATERP = 0;
        static final int GREATERS = 1;
        static final int GREATERT = 2;
        static final int EQUAL = 3;
        static final int RESET = 4;
        static final int INVERSE_SECONDARY = 5;
        int comparisonType;
        String textElement;
        int hashText;
        int offset;
        boolean ignore;
        String expansionOrdering;

        CollationSorter() {
        }
    }

    static final class CollationElement {
        String key;
        int primary;
        short secondary;
        short tertiary;
        short equality;
        boolean ignore;
        String expansion;

        CollationElement(String string, int n, short s, short s2, short s3, String string2, boolean bl) {
            this.key = string;
            this.primary = n;
            this.secondary = s;
            this.tertiary = s2;
            this.equality = s3;
            this.ignore = bl;
            this.expansion = string2;
        }

        int getValue() {
            return (this.primary << 16) + (this.secondary << 8) + this.tertiary;
        }
    }
}

