/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    protected AbstractList() {
    }

    public abstract Object get(int var1);

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        int n2;
        Iterator iterator = collection.iterator();
        for (int i = n2 = collection.size(); i > 0; --i) {
            this.add(n++, iterator.next());
        }
        return n2 > 0;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.size();
        if (n != ((List)object).size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (--n >= 0) {
            if (AbstractCollection.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        int n2 = this.size();
        while (--n2 >= 0) {
            n = 31 * n + AbstractCollection.hashCode(iterator.next());
        }
        return n;
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!AbstractCollection.equals(object, listIterator.next())) continue;
            return i;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private /* synthetic */ AbstractList this$0;
            private int pos;
            private int size;
            private int last;
            private int knownMod;
            {
                this.this$0 = abstractList;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.pos = 0;
                this.size = this.this$0.size();
                this.last = -1;
                this.knownMod = this.this$0.modCount;
            }

            private void checkMod() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                return this.pos < this.size;
            }

            public Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return this.this$0.get(this.pos++);
            }

            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = this.this$0.modCount;
            }
        };
    }

    public int lastIndexOf(Object object) {
        int n = this.size();
        ListIterator listIterator = this.listIterator(n);
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, listIterator.previous())) continue;
            return n;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size());
        }
        return new ListIterator(this, n){
            private /* synthetic */ AbstractList this$0;
            private /* synthetic */ int val$index;
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.this$0 = abstractList;
                this.finit$(n);
            }

            private /* synthetic */ void finit$(int n) {
                this.val$index = n;
                this.knownMod = this.this$0.modCount;
                this.position = this.val$index;
                this.lastReturned = -1;
                this.size = this.this$0.size();
            }

            private void checkMod() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                return this.position < this.size;
            }

            public boolean hasPrevious() {
                return this.position > 0;
            }

            public Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return this.this$0.get(this.position++);
            }

            public Object previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return this.this$0.get(this.lastReturned);
            }

            public int nextIndex() {
                return this.position;
            }

            public int previousIndex() {
                return this.position - 1;
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = this.this$0.modCount;
            }

            public void set(Object object) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.set(this.lastReturned, object);
            }

            public void add(Object object) {
                this.checkMod();
                this.this$0.add(this.position++, object);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = this.this$0.modCount;
            }
        };
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        for (int i = n; i < n2; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List subList(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, n, n2);
        }
        return new SubList(this, n, n2);
    }

    private static final class RandomAccessSubList
    extends SubList
    implements RandomAccess {
        RandomAccessSubList(AbstractList abstractList, int n, int n2) {
            super(abstractList, n, n2);
        }
    }

    private static class SubList
    extends AbstractList {
        final AbstractList backingList;
        final int offset;
        int size;

        SubList(AbstractList abstractList, int n, int n2) {
            this.backingList = abstractList;
            this.modCount = abstractList.modCount;
            this.offset = n;
            this.size = n2 - n;
        }

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int n) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        public int size() {
            this.checkMod();
            return this.size;
        }

        public Object set(int n, Object object) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.set(n + this.offset, object);
        }

        public Object get(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.get(n + this.offset);
        }

        public void add(int n, Object object) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            this.backingList.add(n + this.offset, object);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        public Object remove(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            Object object = this.backingList.remove(n + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return object;
        }

        protected void removeRange(int n, int n2) {
            this.checkMod();
            this.backingList.removeRange(this.offset + n, this.offset + n2);
            this.size -= n2 - n;
            this.modCount = this.backingList.modCount;
        }

        public boolean addAll(int n, Collection collection) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            int n2 = collection.size();
            boolean bl = this.backingList.addAll(this.offset + n, collection);
            this.size += n2;
            this.modCount = this.backingList.modCount;
            return bl;
        }

        public boolean addAll(Collection collection) {
            return this.addAll(this.size, collection);
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(int n) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            return new ListIterator(this, n){
                private /* synthetic */ SubList this$1;
                private /* synthetic */ int val$index;
                private final ListIterator i;
                private int position;
                {
                    this.this$1 = subList;
                    this.finit$(n);
                }

                private /* synthetic */ void finit$(int n) {
                    this.val$index = n;
                    this.i = this.this$1.backingList.listIterator(this.val$index + this.this$1.offset);
                    this.position = this.val$index;
                }

                public boolean hasNext() {
                    return this.position < this.this$1.size;
                }

                public boolean hasPrevious() {
                    return this.position > 0;
                }

                public Object next() {
                    if (this.position == this.this$1.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                public Object previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - this.this$1.offset;
                }

                public int previousIndex() {
                    return this.i.previousIndex() - this.this$1.offset;
                }

                public void remove() {
                    this.i.remove();
                    --this.this$1.size;
                    this.position = this.nextIndex();
                    this.this$1.modCount = this.this$1.backingList.modCount;
                }

                public void set(Object object) {
                    this.i.set(object);
                }

                public void add(Object object) {
                    this.i.add(object);
                    ++this.this$1.size;
                    ++this.position;
                    this.this$1.modCount = this.this$1.backingList.modCount;
                }
            };
        }
    }
}

