/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Arrays;

public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int LONG_MASK = 63;
    private long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        int n2 = n >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        this.bits = new long[n2];
    }

    public void and(BitSet bitSet) {
        int n;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n];
        }
        while (n < this.bits.length) {
            this.bits[n++] = 0L;
        }
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        while (--n >= 0) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[n] ^ (long)-1);
        }
    }

    public int cardinality() {
        int n = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long l = this.bits[i];
            if (l == 0L) continue;
            if (l == (long)-1) {
                n += 64;
                continue;
            }
            l = (l >> 1 & 0x5555555555555555L) + (l & 0x5555555555555555L);
            l = (l >> 2 & 0x3333333333333333L) + (l & 0x3333333333333333L);
            int n2 = (int)(l >>> 32) + (int)l;
            n2 = (n2 >> 4 & 0xF0F0F0F) + (n2 & 0xF0F0F0F);
            n2 = (n2 >> 8 & 0xFF00FF) + (n2 & 0xFF00FF);
            n += (n2 >> 16 & 0xFFFF) + (n2 & 0xFFFF);
        }
        return n;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    public void clear(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (1L << (n & 0x3F) ^ (long)-1);
    }

    public void clear(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] & ((1L << (n & 0x3F)) - 1L | (long)-1 << (n2 & 0x3F));
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & (1L << (n & 0x3F)) - 1L;
        int n7 = n4;
        this.bits[n7] = this.bits[n7] & (long)-1 << (n2 & 0x3F);
        for (int i = n3 + 1; i < n4; ++i) {
            this.bits[i] = 0L;
        }
    }

    public Object clone() {
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.bits = (long[])this.bits.clone();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof BitSet)) {
            return false;
        }
        BitSet bitSet = (BitSet)object;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = 0; i < n2; ++i) {
            if (this.bits[i] == bitSet.bits[i]) continue;
            return false;
        }
        for (n = i; n < this.bits.length; ++n) {
            if (this.bits[n] == 0L) continue;
            return false;
        }
        for (n = i; n < bitSet.bits.length; ++n) {
            if (bitSet.bits[n] == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] ^ 1L << (n & 0x3F);
    }

    public void flip(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] ^ (long)-1 << (n & 0x3F) & (1L << (n2 & 0x3F)) - 1L;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] ^ (long)-1 << (n & 0x3F);
        int n7 = n4;
        this.bits[n7] = this.bits[n7] ^ (1L << (n2 & 0x3F)) - 1L;
        int n8 = n3 + 1;
        while (n8 < n4) {
            int n9 = n8++;
            this.bits[n9] = this.bits[n9] ^ (long)-1;
        }
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        return ((int)(this.bits[n2] >> (n & 0x3F)) & 1) != 0;
    }

    public BitSet get(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        BitSet bitSet = new BitSet(n2 - n);
        int n3 = n >>> 6;
        if (n3 >= this.bits.length) {
            return bitSet;
        }
        int n4 = n & 0x3F;
        int n5 = n2 >>> 6;
        if (n4 == 0) {
            int n6 = Math.min(n5 - n3 + 1, this.bits.length - n3);
            System.arraycopy(this.bits, n3, bitSet.bits, 0, n6);
            if (n5 < this.bits.length) {
                int n7 = n5 - n3;
                bitSet.bits[n7] = bitSet.bits[n7] & (1L << (n2 & 0x3F)) - 1L;
            }
            return bitSet;
        }
        int n8 = Math.min(n5, this.bits.length - 1);
        int n9 = 64 - n4;
        int n10 = 0;
        while (n3 < n8) {
            bitSet.bits[n10] = this.bits[n3] >>> (n4 & 0x3F) | this.bits[n3 + 1] << (n9 & 0x3F);
            ++n3;
            ++n10;
        }
        if ((n2 & 0x3F) > n4) {
            bitSet.bits[n10++] = this.bits[n3] >>> (n4 & 0x3F);
        }
        if (n5 < this.bits.length) {
            int n11 = n10 - 1;
            bitSet.bits[n11] = bitSet.bits[n11] & (1L << (n2 - n & 0x3F)) - 1L;
        }
        return bitSet;
    }

    public int hashCode() {
        long l = 1234;
        int n = this.bits.length;
        while (n > 0) {
            l ^= (long)n * this.bits[--n];
        }
        return (int)(l >> 32) ^ (int)l;
    }

    public boolean intersects(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        while (--n >= 0) {
            if ((this.bits[n] & bitSet.bits[n]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int length() {
        int n;
        for (n = this.bits.length - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        if (n < 0) {
            return 0;
        }
        int n2 = (n + 1) * 64;
        for (long i = this.bits[n]; i >= 0L; i <<= 1) {
            --n2;
        }
        return n2;
    }

    public int nextClearBit(int n) {
        long l = 1L << (n & 0x3F);
        for (int i = n >> 6; i < this.bits.length; ++i) {
            long l2 = this.bits[i];
            do {
                if ((l2 & l) == 0L) {
                    return n;
                }
                ++n;
            } while ((l <<= 1) != 0L);
            l = 1L;
        }
        return n;
    }

    public int nextSetBit(int n) {
        long l = 1L << (n & 0x3F);
        for (int i = n >> 6; i < this.bits.length; ++i) {
            long l2 = this.bits[i];
            do {
                if ((l2 & l) != 0L) {
                    return n;
                }
                ++n;
            } while ((l <<= 1) != 0L);
            l = 1L;
        }
        return -1;
    }

    public void or(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        for (int i = bitSet.bits.length - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] | bitSet.bits[i];
        }
    }

    public void set(int n) {
        int n2 = n >> 6;
        this.ensure(n2);
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | 1L << (n & 0x3F);
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return;
        }
        int n3 = n >>> 6;
        int n4 = n2 >>> 6;
        this.ensure(n4);
        if (n3 == n4) {
            int n5 = n4;
            this.bits[n5] = this.bits[n5] | (long)-1 << (n & 0x3F) & (1L << (n2 & 0x3F)) - 1L;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] | (long)-1 << (n & 0x3F);
        int n7 = n4;
        this.bits[n7] = this.bits[n7] | (1L << (n2 & 0x3F)) - 1L;
        for (int i = n3 + 1; i < n4; ++i) {
            this.bits[i] = -1;
        }
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
        } else {
            this.clear(n, n2);
        }
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (int i = 0; i < this.bits.length; ++i) {
            long l = 1L;
            long l2 = this.bits[i];
            if (l2 == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((l2 & l) != 0L) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(64 * i + j);
                    bl = false;
                }
                l <<= 1;
            }
        }
        return stringBuffer.append("}").toString();
    }

    public void xor(BitSet bitSet) {
        this.ensure(bitSet.bits.length - 1);
        for (int i = bitSet.bits.length - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bitSet.bits[i];
        }
    }

    private void ensure(int n) {
        if (n >= this.bits.length) {
            long[] lArray = new long[n + 1];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }
}

