/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private static boolean isSequential(List list2) {
        return !(list2 instanceof RandomAccess) && list2.size() > 16;
    }

    private Collections() {
    }

    static final int compare(Object object, Object object2, Comparator comparator) {
        if (comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return comparator.compare(object, object2);
    }

    public static int binarySearch(List list2, Object object) {
        return Collections.binarySearch(list2, object, null);
    }

    public static int binarySearch(List list2, Object object, Comparator comparator) {
        int n = 0;
        int n2 = 0;
        int n3 = list2.size() - 1;
        if (Collections.isSequential(list2)) {
            ListIterator listIterator = list2.listIterator();
            int n4 = 0;
            Object object2 = listIterator.next();
            boolean bl = true;
            while (n2 <= n3) {
                n = n2 + n3 >> 1;
                if (n4 < n) {
                    if (!bl) {
                        listIterator.next();
                    }
                    while (n4 != n) {
                        ++n4;
                        object2 = listIterator.next();
                    }
                    bl = true;
                } else {
                    if (bl) {
                        listIterator.previous();
                    }
                    while (n4 != n) {
                        --n4;
                        object2 = listIterator.previous();
                    }
                    bl = false;
                }
                int n5 = Collections.compare(object2, object, comparator);
                if (n5 == 0) {
                    return n;
                }
                if (n5 > 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        } else {
            while (n2 <= n3) {
                n = n2 + n3 >> 1;
                int n6 = Collections.compare(list2.get(n), object, comparator);
                if (n6 == 0) {
                    return n;
                }
                if (n6 > 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        }
        return -n - 1;
    }

    public static void copy(List list2, List list3) {
        int n = list3.size();
        if (list2.size() < n) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator iterator = list3.iterator();
        ListIterator listIterator = list2.listIterator();
        while (--n >= 0) {
            listIterator.next();
            listIterator.set(iterator.next());
        }
    }

    public static Enumeration enumeration(Collection collection) {
        Iterator iterator = collection.iterator();
        return new Enumeration(null, iterator){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Iterator val$i;
            {
                this.this$0 = collections;
                this.finit$(iterator);
            }

            private /* synthetic */ void finit$(Iterator iterator) {
                this.val$i = iterator;
            }

            public final boolean hasMoreElements() {
                return this.val$i.hasNext();
            }

            public final Object nextElement() {
                return this.val$i.next();
            }
        };
    }

    public static void fill(List list2, Object object) {
        ListIterator listIterator = list2.listIterator();
        for (int i = list2.size() - 1; i >= 0; --i) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static int indexOfSubList(List list2, List list3) {
        int n = list2.size();
        int n2 = 0;
        for (int i = list3.size(); i <= n; ++i) {
            if (list2.subList(n2, i).equals(list3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List list2, List list3) {
        int n = list2.size();
        int n2 = n - list3.size();
        int n3 = n;
        while (n2 >= 0) {
            if (list2.subList(n2, n3).equals(list3)) {
                return n2;
            }
            --n2;
            --n3;
        }
        return -1;
    }

    public static ArrayList list(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static Object max(Collection collection) {
        return Collections.max(collection, null);
    }

    public static Object max(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (Collections.compare(object, object2, comparator) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object min(Collection collection) {
        return Collections.min(collection, null);
    }

    public static Object min(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (Collections.compare(object, object2, comparator) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static List nCopies(int n, Object object) {
        return new CopiesList(n, object);
    }

    public static boolean replaceAll(List list2, Object object, Object object2) {
        ListIterator listIterator = list2.listIterator();
        boolean bl = false;
        int n = list2.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, listIterator.next())) continue;
            listIterator.set(object2);
            bl = true;
        }
        return bl;
    }

    public static void reverse(List list2) {
        int n;
        ListIterator listIterator = list2.listIterator();
        int n2 = 1;
        ListIterator listIterator2 = list2.listIterator(n);
        for (n = list2.size(); n2 < n; ++n2, --n) {
            Object object = listIterator.next();
            listIterator.set(listIterator2.previous());
            listIterator2.set(object);
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List list2, int n) {
        int n2 = list2.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) == 0) {
            return;
        }
        if (n < 0) {
            n += n2;
        }
        if (Collections.isSequential(list2)) {
            Collections.reverse(list2);
            Collections.reverse(list2.subList(0, n));
            Collections.reverse(list2.subList(n, n2));
        } else {
            int n3 = n2;
            int n4 = n;
            int n5 = n3 % n4;
            while (n5 != 0) {
                n3 = n4;
                n4 = n5;
                n5 = n3 % n4;
            }
            while (--n4 >= 0) {
                Object object = list2.get(n4);
                int n6 = n4 + n;
                while (n6 != n4) {
                    object = list2.set(n6, object);
                    n6 = (n6 + n) % n2;
                }
                list2.set(n4, object);
            }
        }
    }

    public static void shuffle(List list2) {
        if (defaultRandom == null) {
            Class clazz = Collections.class$("java.util.Collections");
            synchronized (clazz) {
                block4: {
                    try {
                        if (defaultRandom != null) break block4;
                        defaultRandom = new Random();
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        throw throwable;
                    }
                }
                Object var2_2 = null;
            }
        }
        Collections.shuffle(list2, defaultRandom);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void shuffle(List list2, Random random) {
        int n = list2.size();
        ListIterator listIterator = list2.listIterator(n);
        boolean bl = Collections.isSequential(list2);
        Object[] objectArray = null;
        if (bl) {
            objectArray = list2.toArray();
        }
        for (int i = n - 1; i > 0; --i) {
            Object object;
            int n2 = random.nextInt(i + 1);
            if (bl) {
                object = objectArray[n2];
                objectArray[n2] = listIterator.previous();
            } else {
                object = list2.set(n2, listIterator.previous());
            }
            listIterator.set(object);
        }
    }

    public static Set singleton(Object object) {
        return new SingletonSet(object);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    public static Map singletonMap(Object object, Object object2) {
        return new SingletonMap(object, object2);
    }

    public static void sort(List list2) {
        Collections.sort(list2, null);
    }

    public static void sort(List list2, Comparator comparator) {
        Object[] objectArray = list2.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator listIterator = list2.listIterator();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static void swap(List list2, int n, int n2) {
        list2.set(n, list2.set(n2, list2.get(n)));
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SynchronizedCollection(collection);
    }

    public static List synchronizedList(List list2) {
        if (list2 instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(list2);
        }
        return new SynchronizedList(list2);
    }

    public static Map synchronizedMap(Map map) {
        return new SynchronizedMap(map);
    }

    public static Set synchronizedSet(Set set) {
        return new SynchronizedSet(set);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SynchronizedSortedMap(sortedMap);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SynchronizedSortedSet(sortedSet);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UnmodifiableCollection(collection);
    }

    public static List unmodifiableList(List list2) {
        if (list2 instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(list2);
        }
        return new UnmodifiableList(list2);
    }

    public static Map unmodifiableMap(Map map) {
        return new UnmodifiableMap(map);
    }

    public static Set unmodifiableSet(Set set) {
        return new UnmodifiableSet(set);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UnmodifiableSortedMap(sortedMap);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UnmodifiableSortedSet(sortedSet);
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet ss;

        UnmodifiableSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public SortedSet headSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.headSet(object));
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UnmodifiableSortedSet(this.ss.subSet(object, object2));
        }

        public SortedSet tailSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.tailSet(object));
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public SortedMap headMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.headMap(object));
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UnmodifiableSortedMap(this.sm.subMap(object, object2));
        }

        public SortedMap tailMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.tailMap(object));
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        UnmodifiableMap(Map map) {
            this.m = map;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entries;
        }

        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet(this.m.keySet());
            }
            return this.keys;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        private static final class UnmodifiableEntrySet
        extends UnmodifiableSet
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set set) {
                super(set);
            }

            public Iterator iterator() {
                return new UnmodifiableIterator(this, this.c.iterator()){
                    private /* synthetic */ UnmodifiableEntrySet this$2;
                    {
                        this.this$2 = unmodifiableEntrySet;
                        super(iterator);
                    }

                    public Object next() {
                        Map.Entry entry = (Map.Entry)super.next();
                        return new Map.Entry(this, entry){
                            private /* synthetic */ 7 this$3;
                            private /* synthetic */ Map.Entry val$e;
                            {
                                this.this$3 = var1_1;
                                this.finit$(entry);
                            }

                            private /* synthetic */ void finit$(Map.Entry entry) {
                                this.val$e = entry;
                            }

                            public boolean equals(Object object) {
                                return this.val$e.equals(object);
                            }

                            public Object getKey() {
                                return this.val$e.getKey();
                            }

                            public Object getValue() {
                                return this.val$e.getValue();
                            }

                            public int hashCode() {
                                return this.val$e.hashCode();
                            }

                            public Object setValue(Object object) {
                                throw new UnsupportedOperationException();
                            }

                            public String toString() {
                                return this.val$e.toString();
                            }
                        };
                    }
                };
            }
        }
    }

    private static final class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private final ListIterator li;

        UnmodifiableListIterator(ListIterator listIterator) {
            super(listIterator);
            this.li = listIterator;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public int nextIndex() {
            return this.li.nextIndex();
        }

        public Object previous() {
            return this.li.previous();
        }

        public int previousIndex() {
            return this.li.previousIndex();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List list2) {
            super(list2);
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List list2) {
            super(list2);
            this.list = list2;
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.list.listIterator());
        }

        public ListIterator listIterator(int n) {
            return new UnmodifiableListIterator(this.list.listIterator(n));
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n, int n2) {
            return Collections.unmodifiableList(this.list.subList(n, n2));
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator i;

        UnmodifiableIterator(Iterator iterator) {
            this.i = iterator;
        }

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection collection) {
            this.c = collection;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static final class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(Object object, SortedSet sortedSet) {
            super(object, sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Comparator comparator = this.ss.comparator();
                    Object var3_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.ss.first();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet headSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.headSet(object));
                    Object var4_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.ss.last();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.subSet(object, object2));
                    Object var5_5 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet tailSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.tailSet(object));
                    Object var4_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
    }

    private static final class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(Object object, SortedMap sortedMap) {
            super(object, sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Comparator comparator = this.sm.comparator();
                    Object var3_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.sm.firstKey();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap headMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.headMap(object));
                    Object var4_4 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.sm.lastKey();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap subMap(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.subMap(object, object2));
                    Object var5_5 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap tailMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.tailMap(object));
                    Object var4_4 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Object object, Set set) {
            super(object, set);
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.c.equals(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.c.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        SynchronizedMap(Map map) {
            this.m = map;
            this.mutex = this;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object object, Map map) {
            this.m = map;
            this.mutex = object;
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.m.clear();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }

        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.m.containsKey(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.m.containsValue(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set entrySet() {
            if (this.entries != null) return this.entries;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.entries = new SynchronizedSet(this, this.mutex, this.m.entrySet()){
                        private /* synthetic */ SynchronizedMap this$1;
                        {
                            this.this$1 = synchronizedMap;
                            super(object, set);
                        }

                        static SynchronizedMap access$0(5 var0) {
                            return var0.this$1;
                        }

                        public Iterator iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                try {
                                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this, this.mutex, this.c.iterator()){
                                        private /* synthetic */ 5 this$2;
                                        {
                                            this.this$2 = var1_1;
                                            super(object, iterator);
                                        }

                                        public Object next() {
                                            Object object = this.mutex;
                                            synchronized (object) {
                                                try {
                                                    4.SynchronizedMapEntry synchronizedMapEntry = new 4.SynchronizedMapEntry(5.access$0(this.this$2), super.next());
                                                    Object var3_3 = null;
                                                    return synchronizedMapEntry;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var3_4 = null;
                                                    throw throwable;
                                                }
                                            }
                                        }
                                    };
                                    Object var3_3 = null;
                                    return synchronizedIterator;
                                }
                                catch (Throwable throwable) {
                                    Object var3_4 = null;
                                    throw throwable;
                                }
                            }
                        }
                    };
                    return this.entries;
                }
                finally {
                    Set set = null;
                }
            }
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.m.equals(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    Object object3 = this.m.get(object);
                    Object var4_4 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.m.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.m.isEmpty();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set keySet() {
            if (this.keys != null) return this.keys;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.keys = new SynchronizedSet(this.mutex, this.m.keySet());
                    return this.keys;
                }
                finally {
                    Set set = null;
                }
            }
        }

        public Object put(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                try {
                    Object object4 = this.m.put(object, object2);
                    Object var5_5 = null;
                    return object4;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.m.putAll(map);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public Object remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    Object object3 = this.m.remove(object);
                    Object var4_4 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.m.size();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    String string = this.m.toString();
                    Object var3_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Collection values() {
            if (this.values != null) return this.values;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.values = new SynchronizedCollection(this.mutex, this.m.values());
                    return this.values;
                }
                finally {
                    Collection collection = null;
                }
            }
        }
    }

    private static final class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private final ListIterator li;

        SynchronizedListIterator(Object object, ListIterator listIterator) {
            super(object, listIterator);
            this.li = listIterator;
        }

        public void add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    this.li.add(object);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.li.hasPrevious();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.li.nextIndex();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object previous() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.li.previous();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.li.previousIndex();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public void set(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    this.li.set(object);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }
    }

    private static final class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List list2) {
            super(list2);
        }

        SynchronizedRandomAccessList(Object object, List list2) {
            super(object, list2);
        }

        public List subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedRandomAccessList synchronizedRandomAccessList = new SynchronizedRandomAccessList(this.mutex, this.list.subList(n, n2));
                    Object var5_5 = null;
                    return synchronizedRandomAccessList;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List list2) {
            super(list2);
            this.list = list2;
        }

        SynchronizedList(Object object, List list2) {
            super(object, list2);
            this.list = list2;
        }

        public void add(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    this.list.add(n, object);
                }
                finally {
                    Object var4_4 = null;
                }
                return;
            }
        }

        public boolean addAll(int n, Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.list.addAll(n, collection);
                    Object var5_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.list.equals(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.list.get(n);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.list.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    int n = this.list.indexOf(object);
                    Object var4_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    int n = this.list.lastIndexOf(object);
                    Object var4_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.mutex, this.list.listIterator());
                    Object var3_3 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator(int n) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.mutex, this.list.listIterator(n));
                    Object var4_4 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.list.remove(n);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object set(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    Object object3 = this.list.set(n, object);
                    Object var5_5 = null;
                    return object3;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public List subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedList synchronizedList = new SynchronizedList(this.mutex, this.list.subList(n, n2));
                    Object var5_5 = null;
                    return synchronizedList;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        SynchronizedIterator(Object object, Iterator iterator) {
            this.i = iterator;
            this.mutex = object;
        }

        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.i.next();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.i.hasNext();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.i.remove();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection collection) {
            this.c = collection;
            this.mutex = this;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object object, Collection collection) {
            this.c = collection;
            this.mutex = object;
        }

        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.c.add(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.addAll(collection);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.c.clear();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }

        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.c.contains(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.containsAll(collection);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.isEmpty();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this.mutex, this.c.iterator());
                    Object var3_3 = null;
                    return synchronizedIterator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                try {
                    boolean bl = this.c.remove(object);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.removeAll(collection);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.retainAll(collection);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.c.size();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray();
                    Object var3_3 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray(Object[] objectArray) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object[] objectArray2 = this.c.toArray(objectArray);
                    Object var4_4 = null;
                    return objectArray2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    String string = this.c.toString();
                    Object var3_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set entries;

        SingletonMap(Object object, Object object2) {
            this.k = object;
            this.v = object2;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = Collections.singleton(new AbstractMap.BasicMapEntry(this, this.k, this.v){
                    private /* synthetic */ SingletonMap this$1;
                    {
                        this.this$1 = singletonMap;
                        super(object, object2);
                    }

                    public Object setValue(Object object) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entries;
        }

        public boolean containsKey(Object object) {
            return AbstractMap.equals(object, this.k);
        }

        public boolean containsValue(Object object) {
            return AbstractMap.equals(object, this.v);
        }

        public Object get(Object object) {
            if (AbstractMap.equals(object, this.k)) {
                return this.v;
            }
            return null;
        }

        public int hashCode() {
            return AbstractMap.hashCode(this.k) ^ AbstractMap.hashCode(this.v);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        public int size() {
            return 1;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        SingletonList(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public Object get(int n) {
            if (n == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object object) {
            return AbstractCollection.equals(object, this.element);
        }

        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (AbstractCollection.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return 31 + AbstractCollection.hashCode(this.element);
        }

        public int indexOf(Object object) {
            if (AbstractCollection.equals(object, this.element)) {
                return 0;
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            if (AbstractCollection.equals(object, this.element)) {
                return 0;
            }
            return -1;
        }

        public List subList(int n, int n2) {
            if (n == n2 && (n2 == 0 || n2 == 1)) {
                return EMPTY_LIST;
            }
            if (n == 0 && n2 == 1) {
                return this;
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        SingletonSet(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ SingletonSet this$1;
                private boolean hasNext;
                {
                    this.this$1 = singletonSet;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return this.this$1.element;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean contains(Object object) {
            return AbstractCollection.equals(object, this.element);
        }

        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (AbstractCollection.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return AbstractCollection.hashCode(this.element);
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object2).compareTo(object);
        }
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        CopiesList(int n, Object object) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = object;
        }

        public int size() {
            return this.n;
        }

        public Object get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        public boolean contains(Object object) {
            return this.n > 0 && AbstractCollection.equals(object, this.element);
        }

        public int indexOf(Object object) {
            if (this.n > 0 && AbstractCollection.equals(object, this.element)) {
                return 0;
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            if (AbstractCollection.equals(object, this.element)) {
                return this.n - 1;
            }
            return -1;
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList(n2 - n, this.element);
        }

        public Object[] toArray() {
            Object[] objectArray = new Object[this.n];
            Arrays.fill(objectArray, this.element);
            return objectArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{");
            int n = this.n - 1;
            while (--n > 0) {
                stringBuffer.append(this.element).append(", ");
            }
            stringBuffer.append(this.element).append("}");
            return stringBuffer.toString();
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        public Object get(Object object) {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Object remove(Object object) {
            return null;
        }

        public int size() {
            return 0;
        }

        public Collection values() {
            return EMPTY_SET;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        public int size() {
            return 0;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        public int hashCode() {
            return 1;
        }

        public int indexOf(Object object) {
            return -1;
        }

        public int lastIndexOf(Object object) {
            return -1;
        }

        public boolean remove(Object object) {
            return false;
        }

        public boolean removeAll(Collection collection) {
            return false;
        }

        public boolean retainAll(Collection collection) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] objectArray) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
            }
            return objectArray;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof Set && ((Set)object).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public boolean remove(Object object) {
            return false;
        }

        public boolean removeAll(Collection collection) {
            return false;
        }

        public boolean retainAll(Collection collection) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] objectArray) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
            }
            return objectArray;
        }

        public String toString() {
            return "[]";
        }
    }
}

