/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    public static final Logger global = Logger.getLogger("global");
    private final String name;
    private String resourceBundleName;
    private ResourceBundle resourceBundle;
    private Filter filter;
    private final List handlerList;
    private Handler[] handlers;
    private boolean anonymous;
    private boolean useParentHandlers;
    private Level level;
    private Logger parent;

    private /* synthetic */ void finit$() {
        this.handlerList = new ArrayList(4);
        this.handlers = new Handler[0];
    }

    protected Logger(String string, String string2) throws MissingResourceException {
        this.finit$();
        this.name = string;
        this.resourceBundleName = string2;
        this.resourceBundle = string2 == null ? null : ResourceBundle.getBundle(string2);
        this.level = null;
        this.parent = LogManager.getLogManager().rootLogger;
        this.useParentHandlers = this.parent != null;
    }

    public static Logger getLogger(String string) {
        return Logger.getLogger(string, null);
    }

    public static Logger getLogger(String string, String string2) {
        Logger logger;
        LogManager logManager = LogManager.getLogManager();
        string.getClass();
        LogManager logManager2 = logManager;
        synchronized (logManager2) {
            block6: {
                try {
                    logger = logManager.getLogger(string);
                    if (logger == null) {
                        logger = new Logger(string, string2);
                        boolean bl = logManager.addLogger(logger);
                        if (!bl) {
                            throw new IllegalStateException("cannot register new logger");
                        }
                        break block6;
                    }
                    String string3 = logger.getResourceBundleName();
                    if (string3 == null && string2 != null) {
                        logger.resourceBundle = ResourceBundle.getBundle(string2);
                        logger.resourceBundleName = string2;
                        Logger logger2 = logger;
                        Object var7_9 = null;
                        return logger2;
                    }
                    if (string3 == string2 || string3 != null && string3.equals(string2)) break block6;
                    throw new IllegalArgumentException();
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    throw throwable;
                }
            }
            Object var7_10 = null;
        }
        Logger logger3 = logger;
        return logger3;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String string) throws MissingResourceException {
        Logger logger = new Logger(null, string);
        logger.anonymous = true;
        return logger;
    }

    public synchronized String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public synchronized ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized boolean isLoggable(Level level) {
        if (this.level != null) {
            return this.level.intValue() <= level.intValue();
        }
        if (this.parent != null) {
            return this.parent.isLoggable(level);
        }
        return false;
    }

    public synchronized void setLevel(Level level) {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.level = level;
    }

    public synchronized Filter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(Filter filter) throws SecurityException {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.filter = filter;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void log(LogRecord logRecord) {
        if (!this.isLoggable(logRecord.getLevel())) {
            return;
        }
        if (this.filter != null && !this.filter.isLoggable(logRecord)) {
            return;
        }
        if (logRecord.getLoggerName() == null) {
            logRecord.setLoggerName(this.name);
        }
        LogManager logManager = LogManager.getLogManager();
        synchronized (logManager) {
            try {
                Logger logger = this;
                do {
                    for (int i = 0; i < logger.handlers.length; ++i) {
                        logger.handlers[i].publish(logRecord);
                    }
                    if (!logger.getUseParentHandlers()) break;
                    logger = logger.getParent();
                } while (this.parent != null);
                logger = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public void log(Level level, String string) {
        this.log(level, string, (Object[])null);
    }

    public synchronized void log(Level level, String string, Object object) {
        StackTraceElement stackTraceElement = this.getCallerStackFrame();
        this.logp(level, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string, object);
    }

    public synchronized void log(Level level, String string, Object[] objectArray) {
        StackTraceElement stackTraceElement = this.getCallerStackFrame();
        this.logp(level, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string, objectArray);
    }

    public synchronized void log(Level level, String string, Throwable throwable) {
        StackTraceElement stackTraceElement = this.getCallerStackFrame();
        this.logp(level, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string, throwable);
    }

    public synchronized void logp(Level level, String string, String string2, String string3) {
        this.logp(level, string, string2, string3, (Object[])null);
    }

    public synchronized void logp(Level level, String string, String string2, String string3, Object object) {
        this.logp(level, string, string2, string3, new Object[]{object});
    }

    private synchronized ResourceBundle findResourceBundle() {
        if (this.resourceBundle != null) {
            return this.resourceBundle;
        }
        if (this.parent != null) {
            return this.parent.findResourceBundle();
        }
        return null;
    }

    private synchronized void logImpl(Level level, String string, String string2, String string3, Object[] objectArray) {
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setResourceBundle(this.findResourceBundle());
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.log(logRecord);
    }

    public synchronized void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        this.logImpl(level, string, string2, string3, objectArray);
    }

    public synchronized void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setResourceBundle(this.resourceBundle);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.log(logRecord);
    }

    public synchronized void logrb(Level level, String string, String string2, String string3, String string4) {
        this.logrb(level, string, string2, string3, string4, (Object[])null);
    }

    public synchronized void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        this.logrb(level, string, string2, string3, string4, new Object[]{object});
    }

    public synchronized void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setResourceBundleName(string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.log(logRecord);
    }

    public synchronized void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setResourceBundleName(string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.log(logRecord);
    }

    public synchronized void entering(String string, String string2) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "ENTRY");
        }
    }

    public synchronized void entering(String string, String string2, Object object) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "ENTRY {0}", object);
        }
    }

    public synchronized void entering(String string, String string2, Object[] objectArray) {
        if (this.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("ENTRY");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(" {");
                stringBuffer.append(i);
                stringBuffer.append('}');
            }
            this.logp(Level.FINER, string, string2, stringBuffer.toString(), objectArray);
        }
    }

    public synchronized void exiting(String string, String string2) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "RETURN");
        }
    }

    public synchronized void exiting(String string, String string2, Object object) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "RETURN {0}", object);
        }
    }

    public synchronized void throwing(String string, String string2, Throwable throwable) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "THROW", throwable);
        }
    }

    public synchronized void severe(String string) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, string);
        }
    }

    public synchronized void warning(String string) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, string);
        }
    }

    public synchronized void info(String string) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, string);
        }
    }

    public synchronized void config(String string) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, string);
        }
    }

    public synchronized void fine(String string) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, string);
        }
    }

    public synchronized void finer(String string) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, string);
        }
    }

    public synchronized void finest(String string) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, string);
        }
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        if (!this.handlerList.contains(handler)) {
            this.handlerList.add(handler);
            this.handlers = this.getHandlers();
        }
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        handler.getClass();
        this.handlerList.remove(handler);
        this.handlers = this.getHandlers();
    }

    public synchronized Handler[] getHandlers() {
        return (Handler[])this.handlerList.toArray(new Handler[this.handlerList.size()]);
    }

    public synchronized boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    public synchronized void setUseParentHandlers(boolean bl) {
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.useParentHandlers = bl;
    }

    public synchronized Logger getParent() {
        return this.parent;
    }

    public synchronized void setParent(Logger logger) {
        logger.getClass();
        LogManager logManager = LogManager.getLogManager();
        if (this == logManager.rootLogger) {
            if (logger != null) {
                throw new IllegalArgumentException("only the root logger can have a null parent");
            }
            this.parent = null;
            return;
        }
        if (!this.anonymous) {
            LogManager.getLogManager().checkAccess();
        }
        this.parent = logger;
    }

    private native StackTraceElement getCallerStackFrame();
}

