/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock;
    protected boolean newNode;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed;
    private HashMap childCache;

    private /* synthetic */ void finit$() {
        this.lock = new Object();
        this.newNode = false;
        this.removed = false;
        this.childCache = new HashMap();
    }

    protected AbstractPreferences(AbstractPreferences abstractPreferences, String string) {
        this.finit$();
        if (string == null || string.length() > 80 || abstractPreferences == null && string.length() != 0 || abstractPreferences != null && string.length() == 0 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + string + "' (parent is " + (abstractPreferences == null ? "" : "not ") + "null)");
        }
        this.parent = abstractPreferences;
        this.name = string;
    }

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return this.parent.path() + '/' + this.name;
    }

    private String path() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.path() + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences abstractPreferences = this;
        while (abstractPreferences.parent != null) {
            abstractPreferences = abstractPreferences.parent;
        }
        return abstractPreferences == Preferences.userRoot();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        return (AbstractPreferences[])this.childCache.values().toArray();
    }

    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                TreeSet treeSet = new TreeSet();
                treeSet.addAll(this.childCache.keySet());
                String[] stringArray = this.childrenNamesSpi();
                for (int i = 0; i < stringArray.length; ++i) {
                    treeSet.add(stringArray[i]);
                }
                Object[] objectArray = new String[treeSet.size()];
                treeSet.toArray(objectArray);
                Object[] objectArray2 = objectArray;
                Object var6_7 = null;
                return objectArray2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
        }
    }

    public Preferences node(String string) {
        Preferences preferences;
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.isRemoved()) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (string.startsWith("/")) break block5;
                    if (string.indexOf("//") != -1 || string.endsWith("/")) {
                        throw new IllegalArgumentException(string);
                    }
                    Preferences preferences2 = this.getNode(string);
                    Object var4_5 = null;
                    return preferences2;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            preferences = null;
        }
        preferences = this.isUserNode() ? Preferences.userRoot() : Preferences.systemRoot();
        Preferences preferences3 = preferences.node(string.substring(1));
        return preferences3;
    }

    private Preferences getNode(String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            return this;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = (AbstractPreferences)this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.childSpi(string3);
            this.childCache.put(string3, abstractPreferences);
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            try {
                Preferences preferences = abstractPreferences.getNode(string2);
                Object var8_8 = null;
                return preferences;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        Preferences preferences;
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.isRemoved() && string.length() != 0) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (string.startsWith("/")) break block5;
                    if (string.indexOf("//") != -1 || string.endsWith("/")) {
                        throw new IllegalArgumentException(string);
                    }
                    boolean bl = this.existsNode(string);
                    Object var4_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            preferences = null;
        }
        preferences = this.isUserNode() ? Preferences.userRoot() : Preferences.systemRoot();
        boolean bl = preferences.nodeExists(string.substring(1));
        return bl;
    }

    private boolean existsNode(String string) throws BackingStoreException {
        String string2;
        String string3;
        if (string.length() == 0) {
            return this.isRemoved() ^ true;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = (AbstractPreferences)this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.getChild(string3);
            if (abstractPreferences == null) {
                return false;
            }
            this.childCache.put(string3, abstractPreferences);
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            try {
                boolean bl = abstractPreferences.existsNode(string2);
                Object var8_8 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences;
            try {
                String[] stringArray = this.childrenNamesSpi();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    AbstractPreferences abstractPreferences2 = this.childSpi(string);
                    Object var6_7 = null;
                    return abstractPreferences2;
                }
                abstractPreferences = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                throw throwable;
            }
            Object var6_8 = null;
            return abstractPreferences;
        }
    }

    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean bl = this.removed;
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                AbstractPreferences abstractPreferences = this.parent;
                Object var3_3 = null;
                return abstractPreferences;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public void exportNode(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, outputStream);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, outputStream);
        nodeWriter.writePrefsTree();
    }

    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                String[] stringArray = this.keysSpi();
                Object var3_3 = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public String get(String string, String string2) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            String string3;
            try {
                String string4;
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                try {
                    string4 = this.getSpi(string);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    string4 = null;
                }
                if (string4 != null) {
                    String string5 = string4;
                    Object var6_9 = null;
                    return string5;
                }
                string3 = string2;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                throw throwable;
            }
            Object var6_10 = null;
            return string3;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string, null);
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        String string2 = this.get(string, null);
        byte[] byArray2 = null;
        if (string2 != null) {
            byArray2 = AbstractPreferences.decode64(string2);
        }
        if (byArray2 != null) {
            return byArray2;
        }
        return byArray;
    }

    private static byte[] decode64(String string) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 4 * 3);
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n2 = -1;
        for (n = 0; n < cArray.length && n2 == -1; ++n) {
            if (cArray[n] >= 'A' && cArray[n] <= 'Z') {
                cArray[n] = (char)(cArray[n] - 65);
                continue;
            }
            if (cArray[n] >= 'a' && cArray[n] <= 'z') {
                cArray[n] = (char)(cArray[n] + 26 - 97);
                continue;
            }
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                cArray[n] = (char)(cArray[n] + 52 - 48);
                continue;
            }
            if (cArray[n] == '+') {
                cArray[n] = 62;
                continue;
            }
            if (cArray[n] == '/') {
                cArray[n] = 63;
                continue;
            }
            if (cArray[n] == '=') {
                n2 = n;
                continue;
            }
            return null;
        }
        int n3 = 0;
        for (n = n2 == -1 ? cArray.length : n2; n > 0; n -= 4) {
            int n4;
            int n5 = cArray[n3] << 2;
            if (n >= 2) {
                n5 += (byte)((cArray[n3 + 1] & 0x30) >> 4);
            }
            byteArrayOutputStream.write(n5);
            if (n >= 3) {
                n4 = (cArray[n3 + 1] & 0xF) << 4;
                byteArrayOutputStream.write(n4 += (byte)((cArray[n3 + 2] & 0x3C) >> 2));
            }
            if (n >= 4) {
                n4 = (byte)((cArray[n3 + 2] & 3) << 6);
                byteArrayOutputStream.write(n4 += (byte)cArray[n3 + 3]);
            }
            n3 += 4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public double getDouble(String string, double d) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public float getFloat(String string, float f) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public long getLong(String string, long l) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public void put(String string, String string2) {
        if (string.length() > 80 || string2.length() > 8192) {
            throw new IllegalArgumentException("key (" + string.length() + ")" + " or value (" + string2.length() + ")" + " to large");
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                this.putSpi(string, string2);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, String.valueOf(bl));
    }

    public void putByteArray(String string, byte[] byArray) {
        this.put(string, AbstractPreferences.encode64(byArray));
    }

    private static String encode64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 3 * 4);
        int n = 0;
        char[] cArray = new char[4];
        for (int i = byArray.length; i > 0; i -= 3) {
            cArray[0] = (char)((byArray[n] & 0xFC) >> 2);
            cArray[1] = (char)((byArray[n] & 3) << 4);
            if (i >= 2) {
                cArray[1] = (char)(cArray[1] + (char)((byArray[n + 1] & 0xF0) >> 4));
                cArray[2] = (char)((byArray[n + 1] & 0xF) << 2);
                if (i >= 3) {
                    cArray[2] = (char)(cArray[2] + (char)((byArray[n + 2] & 0xC0) >> 6));
                    cArray[3] = (char)byArray[n + 2] & 0x3F;
                } else {
                    cArray[3] = 64;
                }
            } else {
                cArray[2] = 64;
                cArray[3] = 64;
            }
            for (int j = 0; j < 4; ++j) {
                cArray[j] = cArray[j] < '\u001a' ? (int)(cArray[j] + 65) : (cArray[j] < '4' ? (int)(cArray[j] - 26 + 97) : (cArray[j] < '>' ? (int)(cArray[j] - 52 + 48) : (cArray[j] == '>' ? 43 : (cArray[j] == '?' ? 47 : 61))));
            }
            stringBuffer.append(cArray);
            n += 3;
        }
        return stringBuffer.toString();
    }

    public void putDouble(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public void putFloat(String string, float f) {
        this.put(string, Float.toString(f));
    }

    public void putInt(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void putLong(String string, long l) {
        this.put(string, Long.toString(l));
    }

    public void remove(String string) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                this.removeSpi(string);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                String[] stringArray = this.keys();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.removeSpi(stringArray[i]);
                }
                stringArray = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void flushNode(boolean bl) throws BackingStoreException {
        String[] stringArray = null;
        Object object = this.lock;
        // MONITORENTER : object
        try {
            if (bl) {
                this.syncSpi();
            } else {
                this.flushSpi();
            }
            stringArray = (String[])this.childCache.keySet().toArray(new String[0]);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            // MONITOREXIT : object
            throw throwable;
        }
        Object var4_4 = null;
        // MONITOREXIT : object
        if (stringArray == null) return;
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                Object var7_10;
                AbstractPreferences abstractPreferences;
                AbstractPreferences abstractPreferences2 = this;
                // MONITORENTER : abstractPreferences2
                try {
                    abstractPreferences = (AbstractPreferences)this.childCache.get(stringArray[n]);
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    // MONITOREXIT : abstractPreferences2
                    throw throwable;
                }
                var7_10 = null;
                // MONITOREXIT : abstractPreferences2
                if (abstractPreferences == null) break block9;
                abstractPreferences.flushNode(bl);
            }
            ++n;
        }
    }

    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        AbstractPreferences abstractPreferences = this.parent;
        synchronized (abstractPreferences) {
            Object var3_3;
            try {
                AbstractPreferences abstractPreferences2 = this;
                synchronized (abstractPreferences2) {
                    try {
                        if (this.isRemoved()) {
                            throw new IllegalStateException("Node Removed");
                        }
                        this.purge();
                    }
                    finally {
                        var3_3 = null;
                    }
                    this.parent.childCache.remove(this.name);
                }
            }
            finally {
                var3_3 = null;
            }
            {
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void purge() throws BackingStoreException {
        var1_1 = this.childrenNamesSpi();
        for (var2_2 = 0; var2_2 < var1_1.length; ++var2_2) {
            if (this.childCache.get(var1_1[var2_2]) != null) continue;
            this.childCache.put(var1_1[var2_2], this.childSpi(var1_1[var2_2]));
        }
        var2_3 = this.childCache.values().iterator();
        while (true) lbl-1000:
        // 2 sources

        {
            if (!var2_3.hasNext()) {
                this.childCache.clear();
                this.removeNodeSpi();
                this.removed = true;
                return;
            }
            var4_5 = var3_4 = (AbstractPreferences)var2_3.next();
            // MONITORENTER : var4_5
            var3_4.purge();
            break;
        }
        catch (Throwable var6_7) {
            var5_6 = null;
            // MONITOREXIT : var4_5
            throw var6_7;
        }
        {
            var5_6 = null;
            // MONITOREXIT : var4_5
            ** while (true)
        }
    }

    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
    }

    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;
}

