/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected Deflater def;
    private byte[] inbuf;
    private int inbufLength;

    protected void deflate() throws IOException {
        while (!this.def.needsInput()) {
            int n = this.def.deflate(this.buf, 0, this.buf.length);
            if (n <= 0) continue;
            this.out.write(this.buf, 0, n);
        }
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        super(outputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[n];
        this.def = deflater;
    }

    public void finish() throws IOException {
        this.inbufWrite();
        this.def.finish();
        while (!this.def.finished()) {
            int n = this.def.deflate(this.buf, 0, this.buf.length);
            if (n <= 0) continue;
            this.out.write(this.buf, 0, n);
        }
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void write(int n) throws IOException {
        if (this.inbuf == null) {
            this.inbuf = new byte[128];
        } else if (this.inbufLength == this.inbuf.length) {
            this.inbufWrite();
        }
        this.inbuf[this.inbufLength++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.inbufWrite();
        this.def.setInput(byArray, n, n2);
        this.deflate();
    }

    private void inbufWrite() throws IOException {
        if (this.inbufLength > 0) {
            int n = this.inbufLength;
            this.inbufLength = 0;
            this.write(this.inbuf, 0, n);
        }
    }
}

