/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    static final int Z_DEFLATED = 8;
    static final int HEAD_CRC = 2;
    static final int EXTRA_FIELD = 4;
    static final int ORIG_NAME = 8;
    static final int COMMENT = 16;
    static final int RESERVED = 224;
    protected CRC32 crc;
    protected boolean eos;

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        int n2;
        int n3 = this.eof_read() | this.eof_read() << 8;
        if (n3 != 35615) {
            throw new ZipException("gzip header corrupted");
        }
        int n4 = this.eof_read();
        int n5 = this.eof_read();
        if (n4 != 8 || (n5 & 0xE0) != 0) {
            throw new ZipException("gzip header corrupted");
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.eof_read();
        }
        if ((n5 & 4) != 0) {
            n2 = this.eof_read() | this.eof_read() << 8;
            while (n2-- != 0) {
                this.eof_read();
            }
        }
        if ((n5 & 8) != 0) {
            while ((n2 = this.eof_read()) != 0) {
            }
        }
        if ((n5 & 0x10) != 0) {
            while ((n2 = this.eof_read()) != 0) {
            }
        }
        if ((n5 & 2) != 0) {
            this.eof_read();
            this.eof_read();
        }
        this.crc = new CRC32();
    }

    public void close() throws IOException {
        super.close();
    }

    private final int eof_read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new ZipException("gzip header corrupted");
        }
        return n & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            int n4;
            this.eos = true;
            byte[] byArray2 = new byte[8];
            int n5 = this.inf.getRemaining();
            System.arraycopy(this.buf, this.len - n5, byArray2, 0, n5);
            for (n4 = n5; n4 < 8; ++n4) {
                byArray2[n4] = (byte)this.eof_read();
            }
            long l = (long)this.read4(byArray2, 0) & 0xFFFFFFFFL;
            if (this.crc.getValue() != l) {
                throw new ZipException("corrupted gzip file - crc mismatch");
            }
            n4 = this.read4(byArray2, 4);
            if (this.inf.getTotalOut() != n4) {
                throw new ZipException("corrupted gzip file - size mismatch");
            }
            return -1;
        }
        this.crc.update(byArray, n, n3);
        return n3;
    }

    private final int read4(byte[] byArray, int n) throws IOException {
        return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }
}

