/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 4096);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream, new Deflater(-1, true), n);
        this.put2(35615);
        outputStream.write(8);
        outputStream.write(0);
        this.put2(0);
        this.put2(0);
        outputStream.write(0);
        outputStream.write(255);
    }

    public synchronized void write(int n) throws IOException {
        super.write(n);
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        this.put4((int)this.crc.getValue());
        this.put4(this.def.getTotalIn());
    }

    private final void put2(int n) throws IOException {
        this.out.write(n);
        this.out.write(n >> 8);
    }

    private final void put4(int n) throws IOException {
        this.out.write(n);
        this.out.write(n >> 8);
        this.out.write(n >> 16);
        this.out.write(n >> 24);
    }
}

