/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private byte[] onebytebuffer;

    private /* synthetic */ void finit$() {
        this.onebytebuffer = new byte[1];
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.finit$();
        if (inputStream == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inflater == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.inf = inflater;
        this.buf = new byte[n];
    }

    public int available() throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (this.inf.finished()) {
            return 0;
        }
        return 1;
    }

    public synchronized void close() throws IOException {
        this.inf = null;
        super.close();
    }

    protected void fill() throws IOException {
        if (this.in == null) {
            throw new ZipException("InflaterInputStream is closed");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() throws IOException {
        int n = this.read(this.onebytebuffer, 0, 1);
        if (n > 0) {
            return this.onebytebuffer[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.inf.finished()) {
            return -1;
        }
        int n3 = 0;
        while (n3 == 0) {
            if (this.inf.needsInput()) {
                this.fill();
            }
            try {
                n3 = this.inf.inflate(byArray, n, n2);
                if (n3 != 0) continue;
                if (this.len == -1) {
                    return -1;
                }
                if (!this.inf.needsDictionary()) continue;
                throw new ZipException("Inflater needs Dictionary");
            }
            catch (DataFormatException dataFormatException) {
                throw new ZipException(dataFormatException.getMessage());
            }
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        int n;
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(l, (long)2048);
        byte[] byArray = new byte[n2];
        long l2 = 0L;
        while (l > 0L && (n = this.read(byArray, 0, n2)) > 0) {
            l2 += (long)n;
            n2 = (int)Math.min(l -= (long)n, (long)2048);
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }
}

