/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import gnu.java.util.EmptyEnumeration;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String name;
    private final RandomAccessFile raf;
    private HashMap entries;
    private boolean closed;
    private byte[] locBuf;

    private /* synthetic */ void finit$() {
        this.closed = false;
        this.locBuf = new byte[30];
    }

    public ZipFile(String string) throws ZipException, IOException {
        this.finit$();
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        this.checkZipFile();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.finit$();
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getPath();
        this.checkZipFile();
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        this.finit$();
        if (n != 1 && n != 5) {
            throw new IllegalArgumentException("invalid mode");
        }
        if ((n & 4) != 0) {
            file.deleteOnExit();
        }
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getPath();
        this.checkZipFile();
    }

    private void checkZipFile() throws IOException, ZipException {
        byte[] byArray = new byte[4];
        boolean bl = true;
        try {
            this.raf.readFully(byArray);
        }
        catch (EOFException eOFException) {
            bl = false;
        }
        if (!bl || this.readLeInt(byArray, 0) != 67324752) {
            this.raf.close();
            throw new ZipException("Not a valid zip file");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ZipFile has closed: " + this.name);
        }
    }

    private int readLeShort(DataInput dataInput, byte[] byArray) throws IOException {
        dataInput.readFully(byArray, 0, 2);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
    }

    private int readLeInt(DataInput dataInput, byte[] byArray) throws IOException {
        dataInput.readFully(byArray, 0, 4);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16;
    }

    private int readLeShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private int readLeInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8) << 16;
    }

    private void readEntries() throws ZipException, IOException {
        long l = this.raf.length() - (long)22;
        byte[] byArray = new byte[46];
        do {
            if (l < 0L) {
                throw new ZipException("central directory not found, probably not a zip file: " + this.name);
            }
            this.raf.seek(l--);
        } while (this.readLeInt(this.raf, byArray) != 101010256);
        if (this.raf.skipBytes(6) != 6) {
            throw new EOFException(this.name);
        }
        int n = this.readLeShort(this.raf, byArray);
        if (this.raf.skipBytes(4) != 4) {
            throw new EOFException(this.name);
        }
        int n2 = this.readLeInt(this.raf, byArray);
        this.entries = new HashMap(n + n / 2);
        this.raf.seek(n2);
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < n; ++i) {
            String string;
            this.raf.readFully(byArray);
            if (this.readLeInt(byArray, 0) != 33639248) {
                throw new ZipException("Wrong Central Directory signature: " + this.name);
            }
            int n3 = this.readLeShort(byArray, 10);
            int n4 = this.readLeInt(byArray, 12);
            int n5 = this.readLeInt(byArray, 16);
            int n6 = this.readLeInt(byArray, 20);
            int n7 = this.readLeInt(byArray, 24);
            int n8 = this.readLeShort(byArray, 28);
            int n9 = this.readLeShort(byArray, 30);
            int n10 = this.readLeShort(byArray, 32);
            int n11 = this.readLeInt(byArray, 42);
            int n12 = Math.max(n8, n10);
            if (byArray2.length < n12) {
                byArray2 = new byte[n12];
            }
            this.raf.readFully(byArray2, 0, n8);
            try {
                string = new String(byArray2, 0, n8, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n3);
            zipEntry.setCrc((long)n5 & 0xFFFFFFFFL);
            zipEntry.setSize((long)n7 & 0xFFFFFFFFL);
            zipEntry.setCompressedSize((long)n6 & 0xFFFFFFFFL);
            zipEntry.setDOSTime(n4);
            if (n9 > 0) {
                byte[] byArray3 = new byte[n9];
                this.raf.readFully(byArray3);
                zipEntry.setExtra(byArray3);
            }
            if (n10 > 0) {
                this.raf.readFully(byArray2, 0, n10);
                try {
                    zipEntry.setComment(new String(byArray2, 0, n10, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
            }
            zipEntry.offset = n11;
            this.entries.put(string, zipEntry);
        }
    }

    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile == null) {
            return;
        }
        RandomAccessFile randomAccessFile2 = randomAccessFile;
        synchronized (randomAccessFile2) {
            try {
                this.closed = true;
                this.entries = null;
                randomAccessFile.close();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed && this.raf != null) {
            this.close();
        }
    }

    public Enumeration entries() {
        this.checkClosed();
        try {
            return new ZipEntryEnumeration(this.getEntries().values().iterator());
        }
        catch (IOException iOException) {
            return EmptyEnumeration.getInstance();
        }
    }

    private HashMap getEntries() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                this.checkClosed();
                if (this.entries == null) {
                    this.readEntries();
                }
                HashMap hashMap = this.entries;
                Object var3_3 = null;
                return hashMap;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public ZipEntry getEntry(String string) {
        this.checkClosed();
        try {
            HashMap hashMap = this.getEntries();
            ZipEntry zipEntry = (ZipEntry)hashMap.get(string);
            if (zipEntry == null && !string.endsWith("/")) {
                zipEntry = (ZipEntry)hashMap.get(string + '/');
            }
            if (zipEntry != null) {
                return new ZipEntry(zipEntry, string);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private long checkLocalHeader(ZipEntry zipEntry) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                this.raf.seek(zipEntry.offset);
                this.raf.readFully(this.locBuf);
                if (this.readLeInt(this.locBuf, 0) != 67324752) {
                    throw new ZipException("Wrong Local header signature: " + this.name);
                }
                if (zipEntry.getMethod() != this.readLeShort(this.locBuf, 8)) {
                    throw new ZipException("Compression method mismatch: " + this.name);
                }
                int n = this.readLeShort(this.locBuf, 26);
                int n2 = n + this.readLeShort(this.locBuf, 28);
                long l = zipEntry.offset + 30 + n2;
                Object var7_6 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.checkClosed();
        HashMap hashMap = this.getEntries();
        String string = zipEntry.getName();
        ZipEntry zipEntry2 = (ZipEntry)hashMap.get(string);
        if (zipEntry2 == null) {
            return null;
        }
        long l = this.checkLocalHeader(zipEntry2);
        int n = zipEntry2.getMethod();
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, l, zipEntry2.getCompressedSize());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(partialInputStream);
        switch (n) {
            case 0: {
                return bufferedInputStream;
            }
            case 8: {
                partialInputStream.addDummyByte();
                return new InflaterInputStream(bufferedInputStream, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + n);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        this.checkClosed();
        try {
            return this.getEntries().size();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static class PartialInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        long filepos;
        long end;
        boolean addDummyByte;
        byte[] singleByte;

        public PartialInputStream(RandomAccessFile randomAccessFile, long l, long l2) {
            this.raf = randomAccessFile;
            this.filepos = l;
            this.end = l + l2;
            this.addDummyByte = false;
            this.singleByte = new byte[1];
        }

        public int available() {
            long l = this.end - this.filepos;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public int read() throws IOException {
            int n = this.read(this.singleByte, 0, 1);
            if (n != 1) {
                return n;
            }
            return this.singleByte[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.end - this.filepos == 0L && n2 > 0 && this.addDummyByte) {
                this.addDummyByte = false;
                byArray[0] = 0;
                return 1;
            }
            if ((long)n2 > this.end - this.filepos && (n2 = (int)this.end - (int)this.filepos) == 0) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                try {
                    this.raf.seek(this.filepos);
                    int n3 = this.raf.read(byArray, n, n2);
                    if (n3 > 0) {
                        this.filepos += (long)n2;
                    }
                    int n4 = n3;
                    Object var7_7 = null;
                    return n4;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    throw throwable;
                }
            }
        }

        public long skip(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l > this.end - this.filepos) {
                l = this.end - this.filepos;
            }
            this.filepos += l;
            return l;
        }

        public void addDummyByte() {
            this.addDummyByte = true;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        private final Iterator elements;

        public ZipEntryEnumeration(Iterator iterator) {
            this.elements = iterator;
        }

        public boolean hasMoreElements() {
            return this.elements.hasNext();
        }

        public Object nextElement() {
            return ((ZipEntry)this.elements.next()).clone();
        }
    }
}

