/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private CRC32 crc;
    private ZipEntry entry;
    private int csize;
    private int size;
    private int method;
    private int flags;
    private int avail;
    private boolean entryAtEOF;

    private /* synthetic */ void finit$() {
        this.crc = new CRC32();
        this.entry = null;
    }

    public ZipInputStream(InputStream inputStream) {
        super(inputStream, new Inflater(true));
        this.finit$();
    }

    private void fillBuf() throws IOException {
        this.avail = this.len = this.in.read(this.buf, 0, this.buf.length);
    }

    private int readBuf(byte[] byArray, int n, int n2) throws IOException {
        if (this.avail <= 0) {
            this.fillBuf();
            if (this.avail <= 0) {
                return -1;
            }
        }
        if (n2 > this.avail) {
            n2 = this.avail;
        }
        System.arraycopy(this.buf, this.len - this.avail, byArray, n, n2);
        this.avail -= n2;
        return n2;
    }

    private void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = this.readBuf(byArray, n2, i);
            if (n == -1) {
                throw new EOFException();
            }
            n2 += n;
        }
    }

    private int readLeByte() throws IOException {
        if (this.avail <= 0) {
            this.fillBuf();
            if (this.avail <= 0) {
                throw new ZipException("EOF in header");
            }
        }
        return this.buf[this.len - this.avail--] & 0xFF;
    }

    private int readLeShort() throws IOException {
        return this.readLeByte() | this.readLeByte() << 8;
    }

    private int readLeInt() throws IOException {
        return this.readLeShort() | this.readLeShort() << 16;
    }

    public ZipEntry getNextEntry() throws IOException {
        String string;
        int n;
        if (this.crc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        if ((n = this.readLeInt()) == 33639248) {
            this.close();
            return null;
        }
        if (n != 67324752) {
            throw new ZipException("Wrong Local header signature: " + Integer.toHexString(n));
        }
        this.readLeShort();
        this.flags = this.readLeShort();
        this.method = this.readLeShort();
        int n2 = this.readLeInt();
        int n3 = this.readLeInt();
        this.csize = this.readLeInt();
        this.size = this.readLeInt();
        int n4 = this.readLeShort();
        int n5 = this.readLeShort();
        if (this.method == 0 && this.csize != this.size) {
            throw new ZipException("Stored, but compressed != uncompressed");
        }
        byte[] byArray = new byte[n4];
        this.readFully(byArray);
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        this.entry = this.createZipEntry(string);
        this.entryAtEOF = false;
        this.entry.setMethod(this.method);
        if ((this.flags & 8) == 0) {
            this.entry.setCrc((long)n3 & 0xFFFFFFFFL);
            this.entry.setSize((long)this.size & 0xFFFFFFFFL);
            this.entry.setCompressedSize((long)this.csize & 0xFFFFFFFFL);
        }
        this.entry.setDOSTime(n2);
        if (n5 > 0) {
            byte[] byArray2 = new byte[n5];
            this.readFully(byArray2);
            this.entry.setExtra(byArray2);
        }
        if (this.method == 8 && this.avail > 0) {
            System.arraycopy(this.buf, this.len - this.avail, this.buf, 0, this.avail);
            this.len = this.avail;
            this.avail = 0;
            this.inf.setInput(this.buf, 0, this.len);
        }
        return this.entry;
    }

    private void readDataDescr() throws IOException {
        if (this.readLeInt() != 134695760) {
            throw new ZipException("Data descriptor signature not found");
        }
        this.entry.setCrc((long)this.readLeInt() & 0xFFFFFFFFL);
        this.csize = this.readLeInt();
        this.size = this.readLeInt();
        this.entry.setSize((long)this.size & 0xFFFFFFFFL);
        this.entry.setCompressedSize((long)this.csize & 0xFFFFFFFFL);
    }

    public void closeEntry() throws IOException {
        if (this.crc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.entry == null) {
            return;
        }
        if (this.method == 8) {
            if ((this.flags & 8) != 0) {
                byte[] byArray = new byte[2048];
                while (this.read(byArray) > 0) {
                }
                return;
            }
            this.csize -= this.inf.getTotalIn();
            this.avail = this.inf.getRemaining();
        }
        if (this.avail > this.csize && this.csize >= 0) {
            this.avail -= this.csize;
        } else {
            this.csize -= this.avail;
            this.avail = 0;
            while (this.csize != 0) {
                long l = this.in.skip((long)this.csize & 0xFFFFFFFFL);
                if (l <= 0L) {
                    throw new ZipException("zip archive ends early.");
                }
                this.csize -= (int)l;
            }
        }
        this.size = 0;
        this.crc.reset();
        if (this.method == 8) {
            this.inf.reset();
        }
        this.entry = null;
        this.entryAtEOF = true;
    }

    public int available() throws IOException {
        if (this.entryAtEOF) {
            return 0;
        }
        return 1;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.crc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.entry == null) {
            return -1;
        }
        boolean bl = false;
        switch (this.method) {
            case 8: {
                n2 = super.read(byArray, n, n2);
                if (n2 >= 0) break;
                if (!this.inf.finished()) {
                    throw new ZipException("Inflater not finished!?");
                }
                this.avail = this.inf.getRemaining();
                if ((this.flags & 8) != 0) {
                    this.readDataDescr();
                }
                if (this.inf.getTotalIn() != this.csize || this.inf.getTotalOut() != this.size) {
                    throw new ZipException("size mismatch: " + this.csize + ";" + this.size + " <-> " + this.inf.getTotalIn() + ";" + this.inf.getTotalOut());
                }
                this.inf.reset();
                bl = true;
                break;
            }
            case 0: {
                if (n2 > this.csize && this.csize >= 0) {
                    n2 = this.csize;
                }
                if ((n2 = this.readBuf(byArray, n, n2)) > 0) {
                    this.csize -= n2;
                    this.size -= n2;
                }
                if (this.csize == 0) {
                    bl = true;
                    break;
                }
                if (n2 >= 0) break;
                throw new ZipException("EOF in stored block");
            }
        }
        if (n2 > 0) {
            this.crc.update(byArray, n, n2);
        }
        if (bl) {
            if ((this.crc.getValue() & 0xFFFFFFFFL) != this.entry.getCrc()) {
                throw new ZipException("CRC mismatch");
            }
            this.crc.reset();
            this.entry = null;
            this.entryAtEOF = true;
        }
        return n2;
    }

    public void close() throws IOException {
        super.close();
        this.crc = null;
        this.entry = null;
        this.entryAtEOF = true;
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }
}

