/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;

public class EncryptedPrivateKeyInfo {
    private byte[] encryptedData;
    private byte[] encoded;
    private OID algOid;
    private AlgorithmParameters params;
    private byte[] encodedParams;

    public EncryptedPrivateKeyInfo(AlgorithmParameters algorithmParameters, byte[] byArray) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (byArray.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.params = algorithmParameters;
        this.algOid = new OID(algorithmParameters.getAlgorithm());
        this.encryptedData = (byte[])byArray.clone();
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        this.encoded = (byte[])byArray.clone();
        this.decode();
    }

    public EncryptedPrivateKeyInfo(String string, byte[] byArray) throws IllegalArgumentException, NoSuchAlgorithmException, NullPointerException {
        if (byArray.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.algOid = new OID(string);
        this.encryptedData = (byte[])byArray.clone();
    }

    public String getAlgName() {
        return this.algOid.toString();
    }

    public AlgorithmParameters getAlgParameters() {
        if (this.params == null && this.encodedParams != null) {
            try {
                this.params = AlgorithmParameters.getInstance(this.getAlgName());
                this.params.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.params;
    }

    public synchronized byte[] getEncoded() throws IOException {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            return new PKCS8EncodedKeySpec(cipher.doFinal(this.encryptedData));
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException(exception.toString());
        }
    }

    private void decode() throws IOException {
        DERReader dERReader = new DERReader(this.encoded);
        DERValue dERValue = dERReader.read();
        if (dERValue.getTag() != 16) {
            throw new IOException("malformed EncryptedPrivateKeyInfo");
        }
        dERValue = dERReader.read();
        if (dERValue.getTag() != 16) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        int n = dERValue.getLength();
        DERValue dERValue2 = dERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.algOid = (OID)dERValue2.getValue();
        if (n == 0) {
            dERValue = dERReader.read();
            if (dERValue.getTag() != 0) {
                this.encodedParams = dERValue.getEncoded();
                dERReader.read();
            }
        } else if (dERValue2.getEncodedLength() < dERValue.getLength()) {
            dERValue = dERReader.read();
            this.encodedParams = dERValue.getEncoded();
        }
        dERValue = dERReader.read();
        if (dERValue.getTag() != 4) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.encryptedData = (byte[])dERValue.getValue();
    }

    private void encode() throws IOException {
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new DERValue(6, this.algOid));
        this.getAlgParameters();
        if (this.params != null) {
            arrayList.add(DERReader.read(this.params.getEncoded()));
        }
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(new DERValue(48, arrayList));
        arrayList2.add(new DERValue(4, this.encryptedData));
        this.encoded = new DERValue(48, arrayList2).getEncoded();
    }
}

