/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import gnu.classpath.ServiceFactory;
import gnu.java.awt.ClasspathToolkit;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ServiceRegistry;

public final class IIORegistry
extends ServiceRegistry {
    private static final HashSet defaultCategories = new HashSet();
    private static HashMap instances = new HashMap();

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized IIORegistry getDefaultInstance() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        IIORegistry iIORegistry = (IIORegistry)instances.get(threadGroup);
        if (iIORegistry == null) {
            iIORegistry = new IIORegistry();
            instances.put(threadGroup, iIORegistry);
        }
        return iIORegistry;
    }

    private IIORegistry() {
        super(defaultCategories.iterator());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof ClasspathToolkit) {
            ((ClasspathToolkit)toolkit).registerImageIOSpis(this);
        }
        this.registerApplicationClasspathSpis();
    }

    public void registerApplicationClasspathSpis() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Iterator iterator2 = ServiceFactory.lookupProviders(clazz, classLoader);
            while (iterator2.hasNext()) {
                this.registerServiceProvider((IIOServiceProvider)iterator2.next());
            }
        }
    }

    static {
        defaultCategories.add(IIORegistry.class$("javax.imageio.spi.ImageReaderSpi"));
        defaultCategories.add(IIORegistry.class$("javax.imageio.spi.ImageWriterSpi"));
        defaultCategories.add(IIORegistry.class$("javax.imageio.spi.ImageTranscoderSpi"));
        defaultCategories.add(IIORegistry.class$("javax.imageio.spi.ImageInputStreamSpi"));
        defaultCategories.add(IIORegistry.class$("javax.imageio.spi.ImageOutputStreamSpi"));
    }
}

