/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheDir;

    public FileCacheImageOutputStream(OutputStream outputStream, File file) throws IOException {
        this.stream = outputStream;
        this.cacheDir = file;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private void checkStreamClosed() throws IOException {
        if (this.stream == null) {
            throw new IOException("stream closed");
        }
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int read() throws IOException {
        throw new Error("not implemented");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new Error("not implemented");
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkStreamClosed();
        this.stream.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.checkStreamClosed();
        this.stream.write(n);
    }
}

