/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private boolean closed;
    private Stack markStack;
    byte[] buffer;
    protected int bitOffset;
    protected ByteOrder byteOrder;
    protected long flushedPos;
    protected long streamPos;

    private /* synthetic */ void finit$() {
        this.markStack = new Stack();
        this.buffer = new byte[8];
    }

    public ImageInputStreamImpl() {
        this.finit$();
    }

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void flushBefore(long l) throws IOException {
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        if (l > this.streamPos) {
            throw new IndexOutOfBoundsException();
        }
        this.flushedPos = l;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public long length() {
        return -1;
    }

    public void mark() {
        try {
            this.markStack.push(new Long(this.getStreamPosition()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int readBit() throws IOException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        byte by = this.readByte();
        if (this.bitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            by = (byte)(by >> (8 - n & 0x1F));
        }
        this.bitOffset = n;
        return by & 1;
    }

    public long readBits(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l <<= 1;
            l |= (long)this.readBit();
        }
        return l;
    }

    public boolean readBoolean() throws IOException {
        byte by = this.readByte();
        return by != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        int n2 = this.read(iIOByteBuffer.getData(), iIOByteBuffer.getOffset(), n);
        if (n2 == -1 || n2 < n) {
            throw new EOFException();
        }
        iIOByteBuffer.setLength(n);
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return this.readLong();
    }

    public float readFloat() throws IOException {
        return this.readInt();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.readByte();
        }
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.readChar();
        }
    }

    public void readFully(double[] dArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.readDouble();
        }
    }

    public void readFully(float[] fArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.readFloat();
        }
    }

    public void readFully(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.readInt();
        }
    }

    public void readFully(long[] lArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.readLong();
        }
    }

    public void readFully(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.readShort();
        }
    }

    public int readInt() throws IOException {
        int n = this.read(this.buffer, 0, 4);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (this.buffer[0] & 0xFF) + (this.buffer[1] << 8) + (this.buffer[2] << 16) + (this.buffer[3] << 24);
        }
        return (this.buffer[4] << 24) + (this.buffer[3] << 16) + (this.buffer[2] << 8) + (this.buffer[1] & 0xFF);
    }

    public String readLine() throws IOException {
        this.checkClosed();
        int n = -1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        block4: while (!bl && (n = this.read()) != -1) {
            switch (n) {
                case 13: {
                    long l = this.getStreamPosition();
                    if (this.read() != 10) {
                        this.seek(l);
                    }
                }
                case 10: {
                    bl = true;
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public long readLong() throws IOException {
        int n = this.read(this.buffer, 0, 8);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (long)((this.buffer[0] & 0xFF) + ((this.buffer[1] & 0xFF) << 8) + ((this.buffer[2] & 0xFF) << 16)) + (((long)this.buffer[3] & (long)255) << 24) + (((long)this.buffer[4] & (long)255) << 32) + (((long)this.buffer[5] & (long)255) << 40) + (((long)this.buffer[6] & (long)255) << 48) + ((long)this.buffer[7] << 56);
        }
        return ((long)this.buffer[7] << 56) + (((long)this.buffer[6] & (long)255) << 48) + (((long)this.buffer[5] & (long)255) << 40) + (((long)this.buffer[4] & (long)255) << 32) + (((long)this.buffer[3] & (long)255) << 24) + (long)((this.buffer[2] & 0xFF) << 16) + (long)((this.buffer[1] & 0xFF) << 8) + ((long)this.buffer[0] & (long)255);
    }

    public short readShort() throws IOException {
        int n = this.read(this.buffer, 0, 2);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return ((short)this.buffer[0] & 0xFF) + (short)(this.buffer[1] << 8);
        }
        return (short)(this.buffer[0] << 8) + ((short)this.buffer[1] & 0xFF);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return this.readInt() & 0xFFFFFFFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public String readUTF() throws IOException {
        String string;
        String string2;
        this.checkClosed();
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string2 = DataInputStream.readUTF(this);
        }
        finally {
            string = null;
            this.setByteOrder(byteOrder);
        }
        string = string2;
        return string;
    }

    public void reset() throws IOException {
        this.checkClosed();
        long l = (Long)this.markStack.pop();
        this.seek(l);
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("position < flushed position");
        }
        this.streamPos = l;
        this.bitOffset = 0;
    }

    public void setBitOffset(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        this.bitOffset = n;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int skipBytes(int n) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + (long)n);
        this.bitOffset = 0;
        return n;
    }

    public long skipBytes(long l) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + l);
        this.bitOffset = 0;
        return l;
    }
}

