/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class CompositeName
implements Name,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1667768148915813118L;
    private transient Vector elts = new Vector();

    public CompositeName() {
    }

    protected CompositeName(Enumeration enumeration) {
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public CompositeName(String string) throws InvalidNameException {
        char c;
        char c2 = c = 'x';
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (bl) {
                bl = false;
            } else {
                if (c3 == '\\') {
                    bl = true;
                    continue;
                }
                if (c2 != c) {
                    if (c2 == c3) {
                        if (i + 1 < string.length() && string.charAt(i + 1) != '/') {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        c2 = c;
                        continue;
                    }
                } else {
                    if (stringBuffer.length() == 0 && (c3 == '\'' || c3 == '\"')) {
                        c2 = c3;
                        continue;
                    }
                    if (c3 == '/') {
                        this.elts.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        continue;
                    }
                }
            }
            stringBuffer.append(c3);
        }
        if (stringBuffer.length() != 0) {
            this.elts.add(stringBuffer.toString());
        }
        if (c2 != c) {
            throw new InvalidNameException("unterminated quote");
        }
        if (bl) {
            throw new InvalidNameException("trailing escape character");
        }
    }

    public Name add(int n, String string) throws InvalidNameException {
        this.elts.add(n, string);
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        this.elts.add(string);
        return this;
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        Enumeration enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(n, enumeration.nextElement());
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        Enumeration enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    public Object clone() {
        return new CompositeName(this.elts.elements());
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof CompositeName)) {
            throw new ClassCastException("CompositeName.compareTo() expected CompositeName");
        }
        CompositeName compositeName = (CompositeName)object;
        int n = Math.min(compositeName.elts.size(), this.elts.size());
        for (int i = 0; i < n; ++i) {
            String string = (String)this.elts.get(i);
            int n2 = string.compareTo((String)compositeName.elts.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        return this.elts.size() - compositeName.elts.size();
    }

    public boolean endsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)name;
        if (compositeName.elts.size() > this.elts.size()) {
            return false;
        }
        int n = this.elts.size() - compositeName.elts.size();
        for (int i = 0; i < compositeName.elts.size(); ++i) {
            if (compositeName.elts.get(i).equals(this.elts.get(n + i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)object;
        return this.elts.equals(compositeName.elts);
    }

    public String get(int n) {
        return (String)this.elts.get(n);
    }

    public Enumeration getAll() {
        return this.elts.elements();
    }

    public Name getPrefix(int n) {
        CompositeName compositeName = new CompositeName();
        for (int i = 0; i < n; ++i) {
            compositeName.elts.add((String)this.elts.get(i));
        }
        return compositeName;
    }

    public Name getSuffix(int n) {
        if (n > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        CompositeName compositeName = new CompositeName();
        for (int i = n; i < this.elts.size(); ++i) {
            compositeName.elts.add((String)this.elts.get(i));
        }
        return compositeName;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.elts.size(); ++i) {
            n += this.elts.get(i).hashCode();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    public Object remove(int n) throws InvalidNameException {
        return this.elts.remove(n);
    }

    public int size() {
        return this.elts.size();
    }

    public boolean startsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        CompositeName compositeName = (CompositeName)name;
        if (compositeName.elts.size() > this.elts.size()) {
            return false;
        }
        for (int i = 0; i < compositeName.elts.size(); ++i) {
            if (compositeName.elts.get(i).equals(this.elts.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.elts.size(); ++i) {
            String string = (String)this.elts.get(i);
            if (i > 0 || i == this.elts.size() - 1 && string.equals("")) {
                stringBuffer.append('/');
            }
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (j == 0 && (c == '\"' || c == '\'') || c == '\\' && (j == string.length() - 1 || "\\'\"/".indexOf(string.charAt(j + 1)) != -1) || c == '/') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }
}

