/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class ResolutionSyntax
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2706743076526672017L;
    public static final int DPCM = 254;
    public static final int DPI = 100;
    private int crossFeedResolution;
    private int feedResolution;

    public ResolutionSyntax(int n, int n2, int n3) {
        if (n < 1 || n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("no argument may be less than 1");
        }
        this.crossFeedResolution = n * n3;
        this.feedResolution = n2 * n3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResolutionSyntax)) {
            return false;
        }
        ResolutionSyntax resolutionSyntax = (ResolutionSyntax)object;
        return this.crossFeedResolution == resolutionSyntax.getCrossFeedResolutionDphi() && this.feedResolution == resolutionSyntax.getFeedResolutionDphi();
    }

    public int getCrossFeedResolution(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (this.crossFeedResolution + n) / n;
    }

    protected int getCrossFeedResolutionDphi() {
        return this.crossFeedResolution;
    }

    public int getFeedResolution(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (this.crossFeedResolution + n) / n;
    }

    protected int getFeedResolutionDphi() {
        return this.feedResolution;
    }

    public int[] getResolution(int n) {
        int[] nArray = new int[]{this.getCrossFeedResolution(n), this.getFeedResolution(n)};
        return nArray;
    }

    public int hashCode() {
        return this.crossFeedResolution + this.feedResolution;
    }

    public boolean lessThanOrEquals(ResolutionSyntax resolutionSyntax) {
        if (resolutionSyntax == null) {
            throw new NullPointerException("other may not be null");
        }
        return this.crossFeedResolution <= resolutionSyntax.getCrossFeedResolutionDphi() && this.feedResolution <= resolutionSyntax.getFeedResolutionDphi();
    }

    public String toString() {
        return this.toString(1, "dphi");
    }

    public String toString(int n, String string) {
        return this.getCrossFeedResolution(n) + "x" + this.getFeedResolution(n) + " " + string;
    }
}

