/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class Size2DSyntax
implements Cloneable,
Serializable {
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private int x;
    private int y;

    protected Size2DSyntax(float f, float f2, int n) {
        if (f < 0.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("x and/or y may not be less than 0");
        }
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        this.x = (int)(f * (float)n + 0.5f);
        this.y = (int)(f2 * (float)n + 0.5f);
    }

    protected Size2DSyntax(int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("x and/or y may not be less then 0");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        this.x = n * n3;
        this.y = n2 * n3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Size2DSyntax)) {
            return false;
        }
        Size2DSyntax size2DSyntax = (Size2DSyntax)object;
        return this.x == size2DSyntax.getXMicrometers() && this.y == size2DSyntax.getYMicrometers();
    }

    public float[] getSize(int n) {
        float[] fArray = new float[]{this.getX(n), this.getY(n)};
        return fArray;
    }

    public float getX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (float)this.x / (float)n;
    }

    protected int getXMicrometers() {
        return this.x;
    }

    public float getY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return (float)this.y / (float)n;
    }

    protected int getYMicrometers() {
        return this.y;
    }

    public int hashCode() {
        return this.x + this.y;
    }

    public String toString() {
        return this.toString(1, "um");
    }

    public String toString(int n, String string) {
        return this.getX(n) + "x" + this.getY(n) + " " + string;
    }
}

