/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(inputStream);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileWriter"));
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                hashSet.add(typeArray[i]);
            }
        }
        return (AudioFileFormat.Type[])hashSet.toArray(new AudioFileFormat.Type[hashSet.size()]);
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileWriter"));
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes(audioInputStream);
            for (int i = 0; i < typeArray.length; ++i) {
                hashSet.add(typeArray[i]);
            }
        }
        return (AudioFileFormat.Type[])hashSet.toArray(new AudioFileFormat.Type[hashSet.size()]);
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("encoding not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("format not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(inputStream);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileReader"));
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static Clip getClip() throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line[] lineArray = mixer.getSourceLines();
            for (int j = 0; j < lineArray.length; ++j) {
                if (!(lineArray[j] instanceof Clip)) continue;
                return (Clip)lineArray[j];
            }
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Clip getClip(Mixer.Info info) throws LineUnavailableException {
        Mixer mixer = AudioSystem.getMixer(info);
        Line[] lineArray = mixer.getSourceLines();
        for (int i = 0; i < lineArray.length; ++i) {
            if (!(lineArray[i] instanceof Clip)) continue;
            return (Clip)lineArray[i];
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            try {
                return mixer.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException) {
                continue;
            }
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Mixer getMixer(Mixer.Info info) {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.MixerProvider"));
        while (iterator.hasNext()) {
            MixerProvider mixerProvider = (MixerProvider)iterator.next();
            if (!mixerProvider.isMixerSupported(info)) continue;
            return mixerProvider.getMixer(info);
        }
        throw new IllegalArgumentException("mixer not found");
    }

    public static Mixer.Info[] getMixerInfo() {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.MixerProvider"));
        while (iterator.hasNext()) {
            MixerProvider mixerProvider = (MixerProvider)iterator.next();
            Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                hashSet.add(infoArray[i]);
            }
        }
        return (Mixer.Info[])hashSet.toArray(new Mixer.Info[hashSet.size()]);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(AudioSystem.class$("javax.sound.sampled.SourceDataLine"), audioFormat);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (!mixer.isLineSupported(info)) continue;
            return (SourceDataLine)mixer.getLine(info);
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(AudioSystem.class$("javax.sound.sampled.SourceDataLine"), audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        if (mixer.isLineSupported(info2)) {
            return (SourceDataLine)mixer.getLine(info2);
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        HashSet hashSet = new HashSet();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            for (int j = 0; j < infoArray2.length; ++j) {
                hashSet.add(infoArray2[j]);
            }
        }
        return (Line.Info[])hashSet.toArray(new Line.Info[hashSet.size()]);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(AudioSystem.class$("javax.sound.sampled.TargetDataLine"), audioFormat);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (!mixer.isLineSupported(info)) continue;
            return (TargetDataLine)mixer.getLine(info);
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(AudioSystem.class$("javax.sound.sampled.TargetDataLine"), audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        if (mixer.isLineSupported(info2)) {
            return (TargetDataLine)mixer.getLine(info2);
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isSourceEncodingSupported(encoding)) continue;
            AudioFormat.Encoding[] encodingArray = formatConversionProvider.getTargetEncodings();
            for (int i = 0; i < encodingArray.length; ++i) {
                hashSet.add(encodingArray[i]);
            }
        }
        return (AudioFormat.Encoding[])hashSet.toArray(new AudioFormat.Encoding[hashSet.size()]);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            AudioFormat.Encoding[] encodingArray = formatConversionProvider.getTargetEncodings(audioFormat);
            for (int i = 0; i < encodingArray.length; ++i) {
                hashSet.add(encodingArray[i]);
            }
        }
        return (AudioFormat.Encoding[])hashSet.toArray(new AudioFormat.Encoding[hashSet.size()]);
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        HashSet hashSet = new HashSet();
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            AudioFormat[] audioFormatArray = formatConversionProvider.getTargetFormats(encoding, audioFormat);
            for (int i = 0; i < audioFormatArray.length; ++i) {
                hashSet.add(audioFormatArray[i]);
            }
        }
        return (AudioFormat[])hashSet.toArray(new AudioFormat[hashSet.size()]);
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        HashSet hashSet = new HashSet();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            for (int j = 0; j < infoArray2.length; ++j) {
                hashSet.add(infoArray2[j]);
            }
        }
        return (Line.Info[])hashSet.toArray(new Line.Info[hashSet.size()]);
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.FormatConversionProvider"));
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileTypeSupported(AudioFileFormat.Type[] typeArray, AudioFileFormat.Type type) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeArray[i].equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(), type);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(audioInputStream), type);
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            if (!AudioSystem.getMixer(infoArray[i]).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileWriter"));
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return audioFileWriter.write(audioInputStream, type, file);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        Iterator iterator = ServiceFactory.lookupProviders(AudioSystem.class$("javax.sound.sampled.spi.AudioFileWriter"));
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return audioFileWriter.write(audioInputStream, type, outputStream);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }
}

