/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final long serialVersionUID = 5654585963292734470L;
    private static final int DEFAULT_MAXIMUM_ROW_COUNT = 8;
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount;
    protected boolean isEditable;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand;
    protected boolean lightWeightPopupEnabled;
    private Action action;
    private Object prototypeDisplayValue;

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setEditable(false);
        this.setEnabled(true);
        this.setMaximumRowCount(8);
        this.setModel(comboBoxModel);
        this.setActionCommand("comboBoxChanged");
        this.lightWeightPopupEnabled = true;
        this.isEditable = false;
        this.updateUI();
    }

    public JComboBox(Object[] objectArray) {
        this(new DefaultComboBoxModel(objectArray));
        if (objectArray.length > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox(Vector vector) {
        this(new DefaultComboBoxModel(vector));
        if (vector.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox() {
        this(new DefaultComboBoxModel());
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    protected void installAncestorListener() {
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ComboBoxUI";
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        if (this.dataModel != null) {
            if (this.dataModel == comboBoxModel) {
                return;
            }
            this.dataModel.removeListDataListener(this);
        }
        comboBoxModel.addListDataListener(this);
        ComboBoxModel comboBoxModel2 = this.dataModel;
        this.dataModel = comboBoxModel;
        this.selectedItemReminder = comboBoxModel.getSelectedItem();
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            this.isEditable = bl;
            this.firePropertyChange("editable", this.isEditable ^ true, this.isEditable);
        }
    }

    public void setMaximumRowCount(int n) {
        if (this.maximumRowCount != n) {
            int n2 = this.maximumRowCount;
            this.maximumRowCount = n;
            this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        if (this.renderer != listCellRenderer) {
            ListCellRenderer listCellRenderer2 = this.renderer;
            this.renderer = listCellRenderer;
            this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        }
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editor == comboBoxEditor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        ComboBoxEditor comboBoxEditor2 = this.editor;
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        this.dataModel.setSelectedItem(object);
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n >= this.dataModel.getSize()) {
            throw new IllegalArgumentException("illegal index: " + n);
        }
        this.setSelectedItem(n == -1 ? null : this.dataModel.getElementAt(n));
    }

    public int getSelectedIndex() {
        Object object = this.getSelectedItem();
        if (object != null) {
            if (this.dataModel instanceof DefaultComboBoxModel) {
                return ((DefaultComboBoxModel)this.dataModel).getIndexOf(object);
            }
            int n = this.dataModel.getSize();
            for (int i = 0; i < n; ++i) {
                Object object2 = this.dataModel.getElementAt(i);
                if (!(object != null ? object.equals(object2) : object2 == null)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(Object object) {
        Object object2 = this.prototypeDisplayValue;
        this.prototypeDisplayValue = object;
        this.firePropertyChange("prototypeDisplayValue", object2, object);
    }

    public void addItem(Object object) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to add the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to insert the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    public void removeItem(Object object) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeAllItems() {
        if (this.dataModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.dataModel).removeAllElements();
        } else if (this.dataModel instanceof MutableComboBoxModel) {
            MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
            for (int i = mutableComboBoxModel.getSize() - 1; i >= 0; --i) {
                mutableComboBoxModel.removeElementAt(i);
            }
        } else {
            throw new RuntimeException("Unable to remove the items because the data model it is not an instance of MutableComboBoxModel.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean bl) {
        this.getUI().setPopupVisible(this, bl);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action action) {
        Action action2 = this.action;
        this.action = action;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.addActionListener(this.action);
        }
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        if (action == null) {
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(this){
            private /* synthetic */ JComboBox this$0;
            {
                this.this$0 = jComboBox;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Action action = (Action)propertyChangeEvent.getSource();
                this.this$0.configurePropertiesFromAction(action);
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        ItemListener[] itemListenerArray = this.getItemListeners();
        for (int i = 0; i < itemListenerArray.length; ++i) {
            itemListenerArray[i].itemStateChanged(itemEvent);
        }
    }

    protected void fireActionEvent() {
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void firePopupMenuCanceled() {
        PopupMenuListener[] popupMenuListenerArray = this.getPopupMenuListeners();
        PopupMenuEvent popupMenuEvent = new PopupMenuEvent(this);
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuCanceled(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] popupMenuListenerArray = this.getPopupMenuListeners();
        PopupMenuEvent popupMenuEvent = new PopupMenuEvent(this);
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] popupMenuListenerArray = this.getPopupMenuListeners();
        PopupMenuEvent popupMenuEvent = new PopupMenuEvent(this);
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    protected void selectedItemChanged() {
        Object object;
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        if ((object = this.getSelectedItem()) != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, object, 1));
        }
        this.fireActionEvent();
        this.selectedItemReminder = object;
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setSelectedItem(((ComboBoxEditor)actionEvent.getSource()).getItem());
        this.setPopupVisible(false);
    }

    public boolean selectWithKeyChar(char c) {
        return false;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.repaint();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.repaint();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
            this.selectedItemChanged();
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = super.isEnabled();
        if (bl != bl2) {
            super.setEnabled(bl);
            this.firePropertyChange("enabled", bl2, bl);
        }
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.setPopupVisible(false);
        } else if (this.keySelectionManager != null) {
            int n = this.keySelectionManager.selectionForKey(keyEvent.getKeyChar(), this.getModel());
            if (n >= 0) {
                this.setSelectedIndex(n);
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return null;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return null;
    }

    protected String paramString() {
        return "JComboBox";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox(this);
        }
        return this.accessibleContext;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(JComboBox.class$("java.awt.event.ActionListener"), actionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(JComboBox.class$("java.awt.event.ActionListener"), actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(JComboBox.class$("java.awt.event.ActionListener"));
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(JComboBox.class$("java.awt.event.ItemListener"), itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(JComboBox.class$("java.awt.event.ItemListener"), itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(JComboBox.class$("java.awt.event.ItemListener"));
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(JComboBox.class$("javax.swing.event.PopupMenuListener"), popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(JComboBox.class$("javax.swing.event.PopupMenuListener"), popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.getListeners(JComboBox.class$("javax.swing.event.PopupMenuListener"));
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private /* synthetic */ JComboBox this$0;
        private static final long serialVersionUID = 8217828307256675666L;

        protected AccessibleJComboBox(JComboBox jComboBox) {
            this.this$0 = jComboBox;
            super(jComboBox);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public String getAccessibleActionDescription(int n) {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

