/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NavigationFilter;

public class JFormattedTextField
extends JTextField {
    private static final long serialVersionUID = 5464657870110180632L;
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private Object value;
    private int focusLostBehavior;
    private AbstractFormatterFactory formatterFactory;
    boolean editValid;

    private /* synthetic */ void finit$() {
        this.focusLostBehavior = 1;
        this.editValid = true;
    }

    public JFormattedTextField() {
        this(null, null);
    }

    public JFormattedTextField(Format format) {
        this.finit$();
        throw new InternalError("not implemented");
    }

    public JFormattedTextField(AbstractFormatter abstractFormatter) {
        this(new FormatterFactoryWrapper(abstractFormatter), null);
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory) {
        this(abstractFormatterFactory, null);
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory, Object object) {
        this.finit$();
        this.formatterFactory = abstractFormatterFactory;
        this.value = object;
    }

    public JFormattedTextField(Object object) {
        this.finit$();
        this.value = object;
    }

    public void commitEdit() throws ParseException {
        throw new InternalError("not implemented");
    }

    public Action[] getActions() {
        return super.getActions();
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public AbstractFormatter getFormatter() {
        if (this.formatterFactory == null) {
            return null;
        }
        return this.formatterFactory.getFormatter(this);
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public String getUIClassID() {
        return "FormattedTextFieldUI";
    }

    public Object getValue() {
        return this.value;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 == document) {
            return;
        }
        super.setDocument(document);
    }

    public void setFocusLostBehavior(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 2) {
            throw new IllegalArgumentException("invalid behavior");
        }
        this.focusLostBehavior = n;
    }

    protected void setFormatter(AbstractFormatter abstractFormatter) {
        AbstractFormatter abstractFormatter2 = null;
        if (this.formatterFactory != null) {
            abstractFormatter2 = this.formatterFactory.getFormatter(this);
        }
        if (abstractFormatter2 == abstractFormatter) {
            return;
        }
        this.setFormatterFactory(new FormatterFactoryWrapper(abstractFormatter));
        this.firePropertyChange("formatter", abstractFormatter2, abstractFormatter);
    }

    public void setFormatterFactory(AbstractFormatterFactory abstractFormatterFactory) {
        if (this.formatterFactory == abstractFormatterFactory) {
            return;
        }
        AbstractFormatterFactory abstractFormatterFactory2 = this.formatterFactory;
        this.formatterFactory = abstractFormatterFactory;
        this.firePropertyChange("formatterFactory", abstractFormatterFactory2, abstractFormatterFactory);
    }

    public void setValue(Object object) {
        if (this.value == object) {
            return;
        }
        AbstractFormatter abstractFormatter = this.createFormatter(object);
        try {
            this.setText(abstractFormatter.valueToString(object));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Object object2 = this.value;
        this.value = object;
        this.firePropertyChange("value", object2, object);
    }

    AbstractFormatter createFormatter(Object object) {
        AbstractFormatter abstractFormatter = null;
        abstractFormatter = this.formatterFactory != null && this.formatterFactory.getFormatter(this) != null ? this.formatterFactory.getFormatter(this) : (object instanceof Date ? new DateFormatter() : new DefaultFormatter());
        return abstractFormatter;
    }

    static class FormatterFactoryWrapper
    extends AbstractFormatterFactory {
        AbstractFormatter formatter;

        public FormatterFactoryWrapper(AbstractFormatter abstractFormatter) {
            this.formatter = abstractFormatter;
        }

        public AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            return this.formatter;
        }
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private static final long serialVersionUID = -5193212041738979680L;
        private JFormattedTextField textField;

        protected Object clone() throws CloneNotSupportedException {
            throw new InternalError("not implemented");
        }

        protected Action[] getActions() {
            return this.textField.getActions();
        }

        protected DocumentFilter getDocumentFilter() {
            throw new InternalError("not implemented");
        }

        protected JFormattedTextField getFormattedTextField() {
            return this.textField;
        }

        protected NavigationFilter getNavigationFilter() {
            return this.textField.getNavigationFilter();
        }

        public void install(JFormattedTextField jFormattedTextField) {
            if (this.textField != null) {
                this.uninstall();
            }
            this.textField = jFormattedTextField;
        }

        public void uninstall() {
            this.textField = null;
        }

        protected void invalidEdit() {
            this.textField.invalidEdit();
        }

        protected void setEditValid(boolean bl) {
            this.textField.editValid = bl;
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;
    }
}

