/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JLayeredPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5534920399324590459L;
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    public static Integer FRAME_CONTENT_LAYER;
    public static Integer DEFAULT_LAYER;
    public static Integer PALETTE_LAYER;
    public static Integer MODAL_LAYER;
    public static Integer POPUP_LAYER;
    public static Integer DRAG_LAYER;
    TreeMap layers = new TreeMap();
    Hashtable componentToLayer = new Hashtable();
    private transient Rectangle rectCache;

    public JLayeredPane() {
        this.setLayout(null);
    }

    public int getLayer(Component component) {
        Component component2 = component;
        while (!this.componentToLayer.containsKey(component2) && (component2 = component2.getParent()) != null) {
        }
        if (component2 == null) {
            throw new IllegalArgumentException("component is not in this JLayeredPane");
        }
        Integer n = (Integer)this.componentToLayer.get(component2);
        return n;
    }

    public static int getLayer(JComponent jComponent) {
        JLayeredPane jLayeredPane = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class$("javax.swing.JLayeredPane"), jComponent);
        if (jLayeredPane == null) {
            return 0;
        }
        return jLayeredPane.getLayer(jComponent);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        JLayeredPane jLayeredPane = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class$("javax.swing.JLayeredPane"), component);
        return jLayeredPane;
    }

    private int[] layerToRange(Integer n) {
        int[] nArray = new int[2];
        nArray[1] = this.getComponents().length;
        Iterator iterator = this.layers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Integer n2 = (Integer)entry.getKey();
            Integer n3 = (Integer)entry.getValue();
            int n4 = n2;
            if (n4 == n) {
                nArray[0] = nArray[1] - n3;
                break;
            }
            if (n4 > n) {
                nArray[1] = nArray[0];
                break;
            }
            nArray[1] = nArray[1] - n3;
        }
        return nArray;
    }

    private void incrLayer(Integer n) {
        int n2 = 1;
        if (this.layers.containsKey(n)) {
            n2 += ((Integer)this.layers.get(n)).intValue();
        }
        this.layers.put(n, new Integer(n2));
    }

    private void decrLayer(Integer n) {
        int n2 = 0;
        if (this.layers.containsKey(n)) {
            n2 = (Integer)this.layers.get(n) - 1;
        }
        this.layers.put(n, new Integer(n2));
    }

    public int highestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.lastKey();
    }

    public int lowestLayer() {
        if (this.layers.size() == 0) {
            return 0;
        }
        return (Integer)this.layers.firstKey();
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, -1);
    }

    public int getPosition(Component component) {
        int n = this.getLayer(component);
        int[] nArray = this.layerToRange(new Integer(n));
        int n2 = nArray[0];
        int n3 = nArray[1];
        Component[] componentArray = this.getComponents();
        for (int i = n2; i < n3; ++i) {
            if (componentArray[i] != component) continue;
            return i - n2;
        }
        throw new IllegalArgumentException();
    }

    public void setPosition(Component component, int n) {
        int n2 = this.getLayer(component);
        int[] nArray = this.layerToRange(new Integer(n2));
        if (nArray[0] == nArray[1]) {
            throw new IllegalArgumentException();
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n == -1) {
            n = n4 - n3 - 1;
        }
        int n5 = Math.min(n3 + n, n4 - 1);
        int n6 = -1;
        Component[] componentArray = this.getComponents();
        for (int i = n3; i < n4; ++i) {
            if (componentArray[i] != component) continue;
            n6 = i;
            break;
        }
        if (n6 == -1) {
            throw new IllegalArgumentException();
        }
        super.swapComponents(n6, n5);
        this.revalidate();
        this.repaint();
    }

    public Component[] getComponentsInLayer(int n) {
        int[] nArray = this.layerToRange(this.getObjectForLayer(n));
        if (nArray[0] == nArray[1]) {
            return new Component[0];
        }
        Component[] componentArray = this.getComponents();
        int n2 = nArray[1] - nArray[0];
        Component[] componentArray2 = new Component[n2];
        for (int i = 0; i < n2; ++i) {
            componentArray2[i] = componentArray[nArray[0] + i];
        }
        return componentArray2;
    }

    public int getComponentCountInLayer(int n) {
        int[] nArray = this.layerToRange(this.getObjectForLayer(n));
        if (nArray[0] == nArray[1]) {
            return 0;
        }
        return nArray[1] - nArray[0];
    }

    protected Hashtable getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component component) {
        int n = this.getLayer(component);
        int[] nArray = this.layerToRange(new Integer(n));
        Component[] componentArray = this.getComponents();
        for (int i = nArray[0]; i < nArray[1]; ++i) {
            if (componentArray[i] != component) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    protected Integer getObjectForLayer(int n) {
        switch (n) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(n);
    }

    protected int insertIndexForLayer(int n, int n2) {
        int[] nArray;
        Integer n3 = this.getObjectForLayer(n);
        if (!this.layers.containsKey(n3)) {
            this.layers.put(n3, new Integer(0));
        }
        if ((nArray = this.layerToRange(n3))[0] == nArray[1]) {
            return nArray[0];
        }
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (n2 == -1 || n2 > n5 - n4) {
            return n5;
        }
        return n4 + n2;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        int n2 = this.getLayer(component);
        this.decrLayer(new Integer(n2));
        this.componentToLayer.remove(component);
        super.remove(n);
        this.revalidate();
    }

    public void setLayer(Component component, int n) {
        this.componentToLayer.put(component, this.getObjectForLayer(n));
    }

    public void setLayer(Component component, int n, int n2) {
        this.remove(component);
        this.add(component, this.getObjectForLayer(n));
        this.setPosition(component, n2);
        this.revalidate();
        this.repaint();
    }

    protected void addImpl(Component component, Object object, int n) {
        Integer n2 = object != null && object instanceof Integer ? (Integer)object : (this.componentToLayer.containsKey(component) ? (Integer)this.componentToLayer.remove(component) : DEFAULT_LAYER);
        int n3 = this.insertIndexForLayer(n2, n);
        this.componentToLayer.put(component, n2);
        this.incrLayer(n2);
        super.addImpl(component, null, n3);
    }

    public static void putLayer(JComponent jComponent, int n) {
        JLayeredPane.getLayeredPaneAbove(jComponent).setLayer(jComponent, n);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane(this);
        }
        return this.accessibleContext;
    }

    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Color color = graphics.getColor();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        super.paint(graphics);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    static {
        LAYER_PROPERTY = LAYER_PROPERTY;
        FRAME_CONTENT_LAYER = new Integer(-30000);
        DEFAULT_LAYER = new Integer(0);
        PALETTE_LAYER = new Integer(100);
        MODAL_LAYER = new Integer(200);
        POPUP_LAYER = new Integer(300);
        DRAG_LAYER = new Integer(400);
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JLayeredPane this$0;

        public AccessibleJLayeredPane(JLayeredPane jLayeredPane) {
            this.this$0 = jLayeredPane;
            super(jLayeredPane);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

