/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = 1980046021813598781L;
    private transient boolean indeterminate;
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;

    private /* synthetic */ void finit$() {
        this.indeterminate = false;
        this.orientation = 0;
        this.paintBorder = true;
        this.paintString = false;
    }

    public JProgressBar() {
        this(0, 0, 100);
    }

    public JProgressBar(int n) {
        this(n, 0, 100);
    }

    public JProgressBar(int n, int n2) {
        this(0, n, n2);
    }

    public JProgressBar(int n, int n2, int n3) {
        this.finit$();
        this.model = new DefaultBoundedRangeModel(n2, 0, n2, n3);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        this.setOrientation(n);
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JProgressBar(BoundedRangeModel boundedRangeModel) {
        this.finit$();
        this.model = boundedRangeModel;
        this.changeListener = this.createChangeListener();
        boundedRangeModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int n) {
        this.model.setValue(n);
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (this.paintBorder && border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL or HORIZONTAL");
        }
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, this.orientation);
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean bl) {
        if (this.paintString != bl) {
            boolean bl2 = this.paintString;
            this.paintString = bl;
            this.firePropertyChange("stringPainted", bl2, this.paintString);
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        return (int)(this.getPercentComplete() * 100.0) + "%";
    }

    public void setString(String string) {
        if ((string == null || this.progressString == null) && string != this.progressString || string != null && !string.equals(this.progressString)) {
            String string2 = this.progressString;
            this.progressString = string;
            this.firePropertyChange("string", string2, this.progressString);
        }
    }

    public double getPercentComplete() {
        if (this.getMaximum() == this.getMinimum()) {
            return 1.0;
        }
        return (double)(this.model.getValue() - this.model.getMinimum()) / (double)(this.model.getMaximum() - this.model.getMinimum());
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        if (bl != this.paintBorder) {
            boolean bl2 = this.paintBorder;
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, this.paintBorder);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI progressBarUI) {
        super.setUI(progressBarUI);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ JProgressBar this$0;
            {
                this.this$0 = jProgressBar;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.this$0.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(JProgressBar.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(JProgressBar.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JProgressBar.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JProgressBar.class$("javax.swing.event.ChangeListener")) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != this.model) {
            this.model.removeChangeListener(this.changeListener);
            this.model = boundedRangeModel;
            this.model.addChangeListener(this.changeListener);
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    protected String paramString() {
        return "JProgressBar";
    }

    public void setIndeterminate(boolean bl) {
        if (this.indeterminate != bl) {
            boolean bl2 = this.indeterminate;
            this.indeterminate = bl;
            this.firePropertyChange("indeterminate", bl2, this.indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JProgressBar this$0;
        private static final long serialVersionUID = -2938130009392721813L;

        protected AccessibleJProgressBar(JProgressBar jProgressBar) {
            this.this$0 = jProgressBar;
            super(jProgressBar);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

