/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.DateFormatter;

public class JSpinner
extends JComponent {
    private static final long serialVersionUID = 3412663575706551720L;
    private SpinnerModel model;
    private JComponent editor;
    private ChangeListener listener;

    private /* synthetic */ void finit$() {
        this.listener = new ChangeListener(this){
            private /* synthetic */ JSpinner this$0;
            {
                this.this$0 = jSpinner;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.this$0.fireStateChanged();
            }
        };
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel spinnerModel) {
        this.finit$();
        this.model = spinnerModel;
        spinnerModel.addChangeListener(this.listener);
        this.setEditor(this.createEditor(spinnerModel));
        this.updateUI();
    }

    public void commitEdit() throws ParseException {
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)this.editor).commitEdit();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)jComponent).dismiss(this);
        } else if (this.editor instanceof ChangeListener) {
            this.removeChangeListener((ChangeListener)((Object)this.editor));
        }
        if (jComponent instanceof ChangeListener) {
            this.addChangeListener((ChangeListener)((Object)jComponent));
        }
        this.editor = jComponent;
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.model == spinnerModel) {
            return;
        }
        SpinnerModel spinnerModel2 = this.model;
        this.model = spinnerModel;
        this.firePropertyChange("model", spinnerModel2, spinnerModel);
        if (this.editor == null) {
            this.setEditor(this.createEditor(this.model));
        }
    }

    public Object getNextValue() {
        return this.model.getNextValue();
    }

    public Object getPreviousValue() {
        return this.model.getPreviousValue();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object object) {
        this.model.setValue(object);
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(JSpinner.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(JSpinner.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JSpinner.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        if (spinnerModel instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (spinnerModel instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        return new DefaultEditor(this);
    }

    public static class DateEditor
    extends DefaultEditor {
        private static final long serialVersionUID = -4279356973770397815L;
        SimpleDateFormat dateFormat;

        public DateEditor(JSpinner jSpinner) {
            super(jSpinner);
            this.init(new SimpleDateFormat());
        }

        public DateEditor(JSpinner jSpinner, String string) {
            super(jSpinner);
            this.init(new SimpleDateFormat(string));
        }

        private void init(SimpleDateFormat simpleDateFormat) {
            this.dateFormat = simpleDateFormat;
            this.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(this){
                private /* synthetic */ DateEditor this$1;
                {
                    this.this$1 = dateEditor;
                }

                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                    return new DateFormatter(this.this$1.dateFormat);
                }
            });
        }

        public SimpleDateFormat getFormat() {
            return this.dateFormat;
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public ListEditor(JSpinner jSpinner) {
            super(jSpinner);
        }

        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        private static final long serialVersionUID = 3791956183098282942L;

        public NumberEditor(JSpinner jSpinner) {
            super(jSpinner);
        }

        public NumberEditor(JSpinner jSpinner, String string) {
            super(jSpinner);
        }

        public DecimalFormat getFormat() {
            return null;
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private JSpinner spinner;
        JFormattedTextField ftf;
        private static final long serialVersionUID = -5317788736173368172L;

        public DefaultEditor(JSpinner jSpinner) {
            this.setLayout(this);
            this.spinner = jSpinner;
            this.ftf = new JFormattedTextField();
            this.add(this.ftf);
            this.ftf.setValue(jSpinner.getValue());
            jSpinner.addChangeListener(this);
        }

        public JSpinner getSpinner() {
            return this.spinner;
        }

        public void commitEdit() throws ParseException {
        }

        public void dismiss(JSpinner jSpinner) {
            jSpinner.removeChangeListener(this);
        }

        public JFormattedTextField getTextField() {
            return this.ftf;
        }

        public void layoutContainer(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            this.ftf.setBounds(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.ftf.getMinimumSize();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = this.getInsets();
            Dimension dimension = this.ftf.getPreferredSize();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }
}

