/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Caret;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final long serialVersionUID = 3876025080382781659L;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    protected Hashtable defaultEditorsByColumnClass;
    protected Hashtable defaultRenderersByColumnClass;
    protected int editingColumn;
    protected int editingRow;
    protected transient Component editorComp;
    protected boolean autoCreateColumnsFromModel;
    protected int autoResizeMode;
    protected int rowHeight;
    protected int rowMargin;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected TableCellEditor cellEditor;
    private boolean dragEnabled;
    protected Color gridColor;
    protected Dimension preferredViewportSize;
    protected Color selectionBackground;
    private static final String SELECTION_BACKGROUND_CHANGED_PROPERTY = "selectionBackground";
    protected Color selectionForeground;
    private static final String SELECTION_FOREGROUND_CHANGED_PROPERTY = "selectionForeground";
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected JTableHeader tableHeader;
    int rowBeingEdited;
    int columnBeingEdited;
    Timer editorTimer;
    Object oldCellValue;
    TableColumnPropertyChangeHandler tableColumnPropertyChangeHandler;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.rowBeingEdited = -1;
        this.columnBeingEdited = -1;
        this.editorTimer = new EditorUpdateTimer(this);
        this.tableColumnPropertyChangeHandler = new TableColumnPropertyChangeHandler(this);
    }

    public JTable() {
        this(null, null, null);
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(Object[][] objectArray, Object[] objectArray2) {
        this(new DefaultTableModel(objectArray, objectArray2));
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.finit$();
        boolean bl = false;
        if (tableColumnModel != null) {
            this.setColumnModel(tableColumnModel);
        } else {
            this.setColumnModel(this.createDefaultColumnModel());
            bl = true;
        }
        this.setSelectionModel(listSelectionModel == null ? this.createDefaultSelectionModel() : listSelectionModel);
        this.setModel(tableModel == null ? this.createDefaultDataModel() : tableModel);
        this.setAutoCreateColumnsFromModel(bl);
        this.initializeLocalVars();
        this.selectionModel.setAnchorSelectionIndex(0);
        this.selectionModel.setLeadSelectionIndex(0);
        this.columnModel.getSelectionModel().setAnchorSelectionIndex(0);
        this.columnModel.getSelectionModel().setLeadSelectionIndex(0);
        this.updateUI();
    }

    protected void initializeLocalVars() {
        this.setTableHeader(this.createDefaultTableHeader());
        if (this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        this.columnModel.addColumnModelListener(this);
        this.defaultRenderersByColumnClass = new Hashtable();
        this.createDefaultRenderers();
        this.defaultEditorsByColumnClass = new Hashtable();
        this.createDefaultEditors();
        this.autoResizeMode = 2;
        this.rowHeight = 16;
        this.rowMargin = 1;
        this.rowSelectionAllowed = true;
        this.cellEditor = null;
        this.dragEnabled = true;
        this.preferredViewportSize = new Dimension(450, 400);
        this.showHorizontalLines = true;
        this.showVerticalLines = true;
        this.editingColumn = -1;
        this.editingRow = -1;
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    public JTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getHeaderValue() == null) {
            String string = this.dataModel.getColumnName(tableColumn.getModelIndex());
            tableColumn.setHeaderValue(string);
        }
        this.columnModel.addColumn(tableColumn);
        tableColumn.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
    }

    protected void createDefaultEditors() {
    }

    protected void createDefaultRenderers() {
        this.setDefaultRenderer(JTable.class$("java.lang.Boolean"), new BooleanCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Number"), new NumberCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Double"), new DoubleCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Double"), new FloatCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.util.Date"), new DateCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("javax.swing.Icon"), new IconCellRenderer(this));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.repaint();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        if (this.rowBeingEdited > -1 && this.columnBeingEdited > -1) {
            if (this.getValueAt(this.rowBeingEdited, this.columnBeingEdited) instanceof JTextField) {
                this.remove((Component)this.getValueAt(this.rowBeingEdited, this.columnBeingEdited));
                this.setValueAt(this.oldCellValue, this.rowBeingEdited, this.columnBeingEdited);
            }
            this.rowBeingEdited = -1;
            this.columnBeingEdited = -1;
        }
        this.editorTimer.stop();
        this.editorComp = null;
        this.cellEditor = null;
        this.requestFocusInWindow(false);
        this.repaint();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        if (this.rowBeingEdited > -1 && this.columnBeingEdited > -1) {
            if (this.getValueAt(this.rowBeingEdited, this.columnBeingEdited) instanceof JTextField) {
                this.remove((Component)this.getValueAt(this.rowBeingEdited, this.columnBeingEdited));
                this.setValueAt(((JTextField)this.editorComp).getText(), this.rowBeingEdited, this.columnBeingEdited);
            }
            this.rowBeingEdited = -1;
            this.columnBeingEdited = -1;
        }
        this.editorTimer.stop();
        this.editorComp = null;
        this.cellEditor = null;
        this.requestFocusInWindow(false);
        this.repaint();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() == -1 && this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        if (tableModelEvent.getType() == 1) {
            this.revalidate();
        } else if (tableModelEvent.getType() == -1) {
            if (this.dataModel.getRowCount() == 0) {
                this.clearSelection();
            }
            this.revalidate();
        }
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.repaint();
    }

    public int columnAtPoint(Point point) {
        if (point != null) {
            int n = this.getLocation().x;
            int n2 = this.getColumnCount();
            Dimension dimension = this.getIntercellSpacing();
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n3 = point.x;
            for (int i = 0; i < n2; ++i) {
                int n4 = tableColumnModel.getColumn(i).getWidth() + (dimension == null ? 0 : dimension.width);
                if (n3 >= 0 && n3 < n4) {
                    return i;
                }
                n3 -= n4;
            }
        }
        return -1;
    }

    public int rowAtPoint(Point point) {
        if (point != null) {
            int n = this.getLocation().y;
            int n2 = this.getRowCount();
            int n3 = this.getRowHeight();
            int n4 = point.y;
            for (int i = 0; i < n2; ++i) {
                if (n4 >= 0 && n4 < n3) {
                    return i;
                }
                n4 -= n3;
            }
        }
        return -1;
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3 = this.getRowHeight(n);
        int n4 = this.columnModel.getColumn(n2).getWidth();
        int n5 = this.columnModel.getColumnMargin();
        int n6 = this.rowMargin;
        n2 = Math.max(0, Math.min(n2, this.getColumnCount() - 1));
        n = Math.max(0, Math.min(n, this.getRowCount() - 1));
        int n7 = 0;
        int n8 = (n3 + n6) * n;
        for (int i = 0; i < n2; ++i) {
            n7 += this.columnModel.getColumn(i).getWidth();
        }
        if (bl) {
            return new Rectangle(n7, n8, n4, n3);
        }
        return new Rectangle(n7, n8, n4 - n5, n3 - n6);
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.getColumnModel().getSelectionModel().clearSelection();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height * n2;
        }
        return rectangle.width * n2;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        if (n == 1) {
            return n2 * this.rowHeight;
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
            n4 += this.columnModel.getColumn(0).getWidth();
        }
        n3 = this.getColumnCount() == 0 ? 10 : n4 / this.getColumnCount();
        return n2 * n3;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = this.columnModel.getColumn(n2).getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.dataModel.getColumnClass(n2));
        }
        return tableCellEditor;
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (this.defaultEditorsByColumnClass.containsKey(clazz)) {
            return (TableCellEditor)this.defaultEditorsByColumnClass.get(clazz);
        }
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        this.defaultEditorsByColumnClass.put(clazz, defaultCellEditor);
        return defaultCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.columnModel.getColumn(n2).getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.dataModel.getColumnClass(n2));
        }
        return tableCellRenderer;
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (this.defaultRenderersByColumnClass.containsKey(clazz)) {
            return (TableCellRenderer)this.defaultRenderersByColumnClass.get(clazz);
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        this.defaultRenderersByColumnClass.put(clazz, defaultTableCellRenderer);
        return defaultTableCellRenderer;
    }

    public int convertColumnIndexToModel(int n) {
        if (n < 0) {
            return n;
        }
        return this.columnModel.getColumn(n).getModelIndex();
    }

    public int convertColumnIndexToView(int n) {
        if (n < 0) {
            return n;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (this.columnModel.getColumn(i).getModelIndex() != n) continue;
            return i;
        }
        return -1;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        boolean bl = this.getRowSelectionAllowed();
        boolean bl2 = this.getColumnSelectionAllowed();
        boolean bl3 = bl ? this.getSelectionModel().isSelectedIndex(n) : false;
        boolean bl4 = bl2 ? this.columnModel.getSelectionModel().isSelectedIndex(n2) : false;
        boolean bl5 = bl && bl2 && bl3 && bl4 || bl && !bl2 && bl3 || !bl && bl2 && bl4;
        return tableCellRenderer.getTableCellRendererComponent(this, this.dataModel.getValueAt(n, this.convertColumnIndexToModel(n2)), bl5, false, n, n2);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowHeight(int n) {
        return this.rowHeight;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getCellSelectionEnabled() {
        return this.getColumnSelectionAllowed() && this.getRowSelectionAllowed();
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    private static int countSelections(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = n2 - n + 1;
                    break;
                }
                case 2: {
                    for (int i = n; i <= n2; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        ++n3;
                    }
                    break;
                }
            }
        }
        return n3;
    }

    private static int[] getSelections(ListSelectionModel listSelectionModel) {
        int n = JTable.countSelections(listSelectionModel);
        int[] nArray = new int[n];
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        ArrayList arrayList = new ArrayList();
        if (n2 != -1 && n3 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    nArray[0] = n2;
                    break;
                }
                case 1: {
                    int n5 = n2;
                    while (n5 <= n3) {
                        nArray[n4++] = n5++;
                    }
                    break;
                }
                case 2: {
                    for (int i = n2; i <= n3; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        nArray[n4++] = i;
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    public int getSelectedColumnCount() {
        return JTable.countSelections(this.columnModel.getSelectionModel());
    }

    public int[] getSelectedColumns() {
        return JTable.getSelections(this.columnModel.getSelectionModel());
    }

    public boolean getColumnSelectionAllowed() {
        return this.getColumnModel().getColumnSelectionAllowed();
    }

    public int getSelectedRowCount() {
        return JTable.countSelections(this.selectionModel);
    }

    public int[] getSelectedRows() {
        return JTable.getSelections(this.selectionModel);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.columnModel.getColumnMargin(), this.rowMargin);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removeColumn(TableColumn tableColumn) {
        this.columnModel.removeColumn(tableColumn);
    }

    public void moveColumn(int n, int n2) {
        this.columnModel.moveColumn(n, n2);
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        if (this.autoCreateColumnsFromModel != bl) {
            this.autoCreateColumnsFromModel = bl;
            if (bl) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public void setAutoResizeMode(int n) {
        this.autoResizeMode = n;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.rowHeight = n;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n, int n2) {
        this.setRowHeight(n2);
    }

    public void setRowMargin(int n) {
        this.rowMargin = n;
        this.revalidate();
        this.repaint();
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.rowSelectionAllowed = bl;
        this.repaint();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.setColumnSelectionAllowed(bl);
        this.setRowSelectionAllowed(bl);
        this.cellSelectionEnabled = true;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataModel == tableModel) {
            return;
        }
        TableModel tableModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        if (tableModel != null) {
            this.dataModel = tableModel;
            this.dataModel.addTableModelListener(this);
            if (this.autoCreateColumnsFromModel) {
                this.createDefaultColumnsFromModel();
            }
        }
        this.firePropertyChange("model", tableModel2, this.dataModel);
        this.revalidate();
        this.repaint();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException();
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel2 != null) {
            tableColumnModel2.removeColumnModelListener(this);
        }
        if (tableColumnModel != null) {
            tableColumnModel.addColumnModelListener(this);
        }
        this.columnModel = tableColumnModel;
        if (this.dataModel != null && this.columnModel != null) {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.columnModel.getColumn(i).setHeaderValue(this.dataModel.getColumnName(i));
            }
        }
        if (this.tableHeader != null) {
            this.tableHeader.setColumnModel(tableColumnModel);
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.getColumnModel().setColumnSelectionAllowed(bl);
        this.repaint();
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this);
        }
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
        }
        this.selectionModel = listSelectionModel;
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
        this.columnModel.getSelectionModel().setSelectionMode(n);
        this.repaint();
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        if (tableCellEditor2 != null) {
            tableCellEditor2.removeCellEditorListener(this);
        }
        if (tableCellEditor != null) {
            tableCellEditor.addCellEditorListener(this);
        }
        this.cellEditor = tableCellEditor;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.repaint();
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.rowMargin = dimension.height;
        this.columnModel.setColumnMargin(dimension.width);
        this.repaint();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
        this.revalidate();
        this.repaint();
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        if (color2 == null && color != null || color == null && color2 != null || color2 != null && color != null && !color2.equals(color)) {
            this.firePropertyChange(SELECTION_BACKGROUND_CHANGED_PROPERTY, color2, color);
        }
        this.repaint();
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        if (color2 == null && color != null || color == null && color2 != null || color2 != null && color != null && !color2.equals(color)) {
            this.firePropertyChange(SELECTION_FOREGROUND_CHANGED_PROPERTY, color2, color);
        }
        this.repaint();
    }

    public void setShowGrid(boolean bl) {
        this.setShowVerticalLines(bl);
        this.setShowHorizontalLines(bl);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.repaint();
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.setTable(null);
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.setTable(this);
        }
        this.revalidate();
        this.repaint();
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jScrollPane != null && this.tableHeader != null) {
            jScrollPane.setColumnHeaderView(this.tableHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jScrollPane != null) {
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void removeNotify() {
        super.addNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private void distributeSpill(TableColumn[] tableColumnArray, int n) {
        int n2 = n / tableColumnArray.length;
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null) continue;
            tableColumnArray[i].setWidth(tableColumnArray[i].getWidth() + n2);
        }
    }

    public void doLayout() {
        int n;
        TableColumn[] tableColumnArray;
        int n2;
        TableColumn tableColumn = null;
        int n3 = this.getColumnCount();
        if (n3 < 1) {
            return;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = -1;
        if (this.tableHeader != null) {
            tableColumn = this.tableHeader.getResizingColumn();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnArray = this.columnModel.getColumn(n2);
            nArray[n2] = n = tableColumnArray.getWidth();
            n4 += n;
            if (tableColumn != tableColumnArray) continue;
            n5 = n2;
        }
        n2 = this.getWidth() - n4;
        if (tableColumn != null) {
            switch (this.getAutoResizeMode()) {
                case 3: {
                    TableColumn tableColumn2 = this.columnModel.getColumn(n3 - 1);
                    tableColumn2.setWidth(tableColumn2.getPreferredWidth() + n2);
                    break;
                }
                case 1: {
                    TableColumn tableColumn3 = this.columnModel.getColumn(n3 - 1);
                    tableColumn3.setWidth(tableColumn3.getPreferredWidth() + n2);
                    break;
                }
                case 4: {
                    tableColumnArray = new TableColumn[n3];
                    for (int i = 0; i < n3; ++i) {
                        tableColumnArray[i] = this.columnModel.getColumn(i);
                    }
                    this.distributeSpill(tableColumnArray, n2);
                    break;
                }
                case 2: {
                    tableColumnArray = new TableColumn[n3];
                    for (int i = n5; i < n3; ++i) {
                        tableColumnArray[i] = this.columnModel.getColumn(i);
                    }
                    this.distributeSpill(tableColumnArray, n2);
                    break;
                }
                default: {
                    int n6 = tableColumn.getPreferredWidth();
                    tableColumn.setWidth(n6);
                    break;
                }
            }
        } else {
            tableColumnArray = new TableColumn[n3];
            for (n = 0; n < n3; ++n) {
                tableColumnArray[n] = this.columnModel.getColumn(n);
            }
            this.distributeSpill(tableColumnArray, n2);
        }
    }

    public void sizeColumnsToFit(boolean bl) {
        this.doLayout();
    }

    public void sizeColumnsToFit(int n) {
        this.doLayout();
    }

    public String getUIClassID() {
        return "TableUI";
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
    }

    public void updateUI() {
        this.setUI((TableUI)UIManager.getUI(this));
        this.revalidate();
        this.repaint();
    }

    public Class getColumnClass(int n) {
        return this.dataModel.getColumnClass(n);
    }

    public String getColumnName(int n) {
        int n2 = this.columnModel.getColumn(n).getModelIndex();
        return this.dataModel.getColumnName(n2);
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public void setDefaultEditor(Class clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public void addColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
    }

    public void addRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void setColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().setSelectionInterval(n, n2);
    }

    public void setRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void removeRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public boolean isColumnSelected(int n) {
        return this.getColumnModel().getSelectionModel().isSelectedIndex(n);
    }

    public boolean isRowSelected(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        return this.isRowSelected(n) && this.isColumnSelected(n2);
    }

    public void selectAll() {
        int n = this.selectionModel.getLeadSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.setRowSelectionInterval(0, this.getRowCount() - 1);
        this.addColumnSelectionInterval(n2, n2);
        this.addRowSelectionInterval(n, n);
    }

    public Object getValueAt(int n, int n2) {
        return this.dataModel.getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellEditable(n, n2)) {
            return;
        }
        if (object instanceof Component) {
            this.add((Component)object);
        }
        this.dataModel.setValueAt(object, n, this.convertColumnIndexToModel(n2));
    }

    public TableColumn getColumn(Object object) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(object));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.dataModel.isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    public void createDefaultColumnsFromModel() {
        if (!$assertionsDisabled && this.columnModel == null) {
            throw new AssertionError((Object)"The columnModel must not be null.");
        }
        for (int i = this.columnModel.getColumnCount() - 1; i >= 0; --i) {
            this.columnModel.removeColumn(this.columnModel.getColumn(i));
        }
        int n = this.dataModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(this.dataModel.getColumnName(i));
            tableColumn.setHeaderValue(this.dataModel.getColumnName(i));
            this.columnModel.addColumn(tableColumn);
            tableColumn.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.selectionModel.setAnchorSelectionIndex(n);
            this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
        } else if (bl) {
            if (this.isCellSelected(n, n2)) {
                this.selectionModel.removeSelectionInterval(n, n);
                this.getColumnModel().getSelectionModel().removeSelectionInterval(n2, n2);
            } else {
                this.selectionModel.addSelectionInterval(n, n);
                this.getColumnModel().getSelectionModel().addSelectionInterval(n2, n2);
            }
        } else if (bl2) {
            this.selectionModel.setLeadSelectionIndex(n);
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
        } else {
            this.selectionModel.clearSelection();
            this.selectionModel.setSelectionInterval(n, n);
            this.getColumnModel().getSelectionModel().clearSelection();
            this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    public boolean editCellAt(int n, int n2) {
        this.oldCellValue = this.getValueAt(n, n2);
        this.setCellEditor(this.getCellEditor(n, n2));
        this.editorComp = this.prepareEditor(this.cellEditor, n, n2);
        this.cellEditor.addCellEditorListener(this);
        this.rowBeingEdited = n;
        this.columnBeingEdited = n2;
        this.setValueAt(this.editorComp, n, n2);
        ((JTextField)this.editorComp).requestFocusInWindow(false);
        this.editorTimer.start();
        return true;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        return this.editCellAt(n, n2);
    }

    public void removeEditor() {
        this.editingStopped(new ChangeEvent(this));
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        return tableCellEditor.getTableCellEditorComponent(this, this.getValueAt(n, n2), this.isCellSelected(n, n2), n, n2);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    static {
        SELECTION_BACKGROUND_CHANGED_PROPERTY = SELECTION_BACKGROUND_CHANGED_PROPERTY;
        SELECTION_FOREGROUND_CHANGED_PROPERTY = SELECTION_FOREGROUND_CHANGED_PROPERTY;
        $assertionsDisabled = JTable.class$("javax.swing.JTable").desiredAssertionStatus() ^ true;
    }

    private class EditorUpdateTimer
    extends Timer
    implements ActionListener {
        private /* synthetic */ JTable this$0;

        public EditorUpdateTimer(JTable jTable) {
            this.this$0 = jTable;
            super(500, null);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Caret caret = ((JTextField)this.this$0.editorComp).getCaret();
            if (caret != null) {
                caret.setVisible(caret.isVisible() ^ true);
            }
            this.this$0.repaint();
        }

        public void update() {
            this.stop();
            Caret caret = ((JTextField)this.this$0.editorComp).getCaret();
            if (caret != null) {
                this.setDelay(caret.getBlinkRate());
                if (((JTextField)this.this$0.editorComp).isEditable()) {
                    this.start();
                } else {
                    caret.setVisible(false);
                }
            }
        }
    }

    private class IconCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Icon) {
                Icon icon = (Icon)object;
                this.setIcon(icon);
            }
            return this;
        }

        IconCellRenderer(JTable jTable) {
            this.this$0 = jTable;
        }
    }

    private class NumberCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public NumberCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }
    }

    private class FloatCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public FloatCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Float) {
                Float f = (Float)object;
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setText(numberFormat.format(f.floatValue()));
            }
            return this;
        }
    }

    private class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public DoubleCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Double) {
                Double d = (Double)object;
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setText(numberFormat.format(d));
            }
            return this;
        }
    }

    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                Date date = (Date)object;
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                this.setText(dateFormat.format(date));
            }
            return this;
        }

        DateCellRenderer(JTable jTable) {
            this.this$0 = jTable;
        }
    }

    private class BooleanCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;
        private JCheckBox checkBox;

        private /* synthetic */ void finit$() {
            this.checkBox = new JCheckBox();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Boolean bl3 = (Boolean)object;
            this.checkBox.setSelected(bl3);
            return this.checkBox;
        }

        BooleanCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.finit$();
        }
    }

    class TableColumnPropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ JTable this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("preferredWidth")) {
                JTableHeader jTableHeader = this.this$0.getTableHeader();
                TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
                jTableHeader.setResizingColumn(tableColumn);
                this.this$0.doLayout();
                jTableHeader.setResizingColumn(null);
            }
        }

        TableColumnPropertyChangeHandler(JTable jTable) {
            this.this$0 = jTable;
        }
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        private /* synthetic */ JTable this$0;

        protected AccessibleJTable(JTable jTable) {
            this.this$0 = jTable;
            super(jTable);
            jTable.getModel().addTableModelListener(this);
            jTable.getSelectionModel().addListSelectionListener(this);
            jTable.getColumnModel().addColumnModelListener(this);
            jTable.getCellEditor().addCellEditorListener(this);
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectedColumnCount();
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent);
                    break;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent);
                }
            }
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tableModel")) {
                TableModel tableModel = (TableModel)propertyChangeEvent.getOldValue();
                tableModel.removeTableModelListener(this);
                TableModel tableModel2 = (TableModel)propertyChangeEvent.getNewValue();
                tableModel2.addTableModelListener(this);
            } else if (string.equals("columnModel")) {
                TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getOldValue();
                tableColumnModel.removeColumnModelListener(this);
                TableColumnModel tableColumnModel2 = (TableColumnModel)propertyChangeEvent.getNewValue();
                tableColumnModel2.addColumnModelListener(this);
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(this);
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                listSelectionModel2.addListSelectionListener(this);
            } else if (string.equals("cellEditor")) {
                CellEditor cellEditor = (CellEditor)propertyChangeEvent.getOldValue();
                cellEditor.removeCellEditorListener(this);
                CellEditor cellEditor2 = (CellEditor)propertyChangeEvent.getNewValue();
                cellEditor2.addCellEditorListener(this);
            }
        }

        public int getAccessibleRow(int n) {
            return 0;
        }

        public int getAccessibleColumn(int n) {
            return 0;
        }

        public int getAccessibleIndex(int n, int n2) {
            return 0;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public void setAccessibleCaption(Accessible accessible) {
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public void setAccessibleSummary(Accessible accessible) {
        }

        public int getAccessibleRowCount() {
            return 0;
        }

        public int getAccessibleColumnCount() {
            return 0;
        }

        public Accessible getAccessibleAt(int n, int n2) {
            return null;
        }

        public int getAccessibleRowExtentAt(int n, int n2) {
            return 0;
        }

        public int getAccessibleColumnExtentAt(int n, int n2) {
            return 0;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public Accessible getAccessibleRowDescription(int n) {
            return null;
        }

        public void setAccessibleRowDescription(int n, Accessible accessible) {
        }

        public Accessible getAccessibleColumnDescription(int n) {
            return null;
        }

        public void setAccessibleColumnDescription(int n, Accessible accessible) {
        }

        public boolean isAccessibleSelected(int n, int n2) {
            return false;
        }

        public boolean isAccessibleRowSelected(int n) {
            return false;
        }

        public boolean isAccessibleColumnSelected(int n) {
            return false;
        }

        public int[] getSelectedAccessibleRows() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            return null;
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            private /* synthetic */ AccessibleJTable this$1;
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(AccessibleJTable accessibleJTable, int n, int n2, int n3, int n4, int n5) {
                this.this$1 = accessibleJTable;
                this.type = n;
                this.firstRow = n2;
                this.lastRow = n3;
                this.firstColumn = n4;
                this.lastColumn = n5;
            }

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private /* synthetic */ AccessibleJTable this$1;
            private JTable table;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(AccessibleJTable accessibleJTable, JTable jTable, int n, int n2, int n3) {
                this.this$1 = accessibleJTable;
                this.table = jTable;
                this.row = n;
                this.column = n2;
                this.index = n3;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return new AccessibleStateSet();
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return Locale.ENGLISH;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.table.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.table.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.table.getCursor();
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return this.table.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.table.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.table.isEnabled();
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isVisible() {
                return this.table.isVisible();
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return this.table.isShowing();
            }

            public boolean contains(Point point) {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                rectangle.x = 0;
                rectangle.y = 0;
                return rectangle.contains(point);
            }

            public Point getLocationOnScreen() {
                Point point = this.table.getLocationOnScreen();
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }

            public Point getLocation() {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                return new Point(rectangle.x, rectangle.y);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.table.getCellRect(this.row, this.column, true);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                return new Dimension(rectangle.width, rectangle.height);
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return this.table.isFocusable();
            }

            public void requestFocus() {
                this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(this.column);
                this.table.getSelectionModel().setLeadSelectionIndex(this.row);
                this.table.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                this.table.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.table.removeFocusListener(focusListener);
            }
        }
    }
}

