/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = 7559816092864483649L;
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";
    private static final Object EXPANDED;
    private static final Object COLLAPSED;
    private boolean dragEnabled;
    private boolean expandsSelectedPaths;
    private TreePath anchorSelectionPath;
    private TreePath leadSelectionPath;
    private Hashtable nodeStates;
    protected transient TreeCellEditor cellEditor;
    protected transient TreeCellRenderer cellRenderer;
    protected boolean editable;
    protected boolean invokesStopCellEditing;
    protected boolean largeModel;
    protected boolean rootVisible;
    protected int rowHeight;
    protected boolean scrollsOnExpand;
    protected transient TreeSelectionModel selectionModel;
    protected boolean showsRootHandles;
    protected int toggleClickCount;
    protected transient TreeModel treeModel;
    protected int visibleRowCount;
    protected transient TreeModelListener treeModelListener;
    protected TreeSelectionRedirector selectionRedirector;

    private /* synthetic */ void finit$() {
        this.nodeStates = new Hashtable();
        this.selectionRedirector = new TreeSelectionRedirector(this);
    }

    public JTree() {
        this(JTree.createTreeModel(null));
    }

    public JTree(Hashtable hashtable) {
        this(JTree.createTreeModel(hashtable));
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
    }

    public JTree(TreeModel treeModel) {
        this.finit$();
        this.updateUI();
        this.setRootVisible(true);
        this.setModel(treeModel);
        this.setSelectionModel(new EmptySelectionModel());
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    public JTree(Vector vector) {
        this(JTree.createTreeModel(vector));
    }

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(this, treePath);
        }
        return -1;
    }

    public TreePath getPathForRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathForRow(this, n);
        }
        return null;
    }

    protected TreePath[] getPathBetweenRows(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI == null) {
            return null;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        TreePath[] treePathArray = new TreePath[n4 - n3 + 1];
        for (int i = n3; i <= n4; ++i) {
            treePathArray[i - n3] = treeUI.getPathForRow(this, i);
        }
        return treePathArray;
    }

    protected static TreeModel createTreeModel(Object object) {
        return new DefaultTreeModel(new DynamicUtilTreeNode(object, object));
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TreeUI";
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTree(this);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, this.getVisibleRowCount() * this.getRowHeight());
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(JTree.class$("javax.swing.event.TreeExpansionListener"), treeExpansionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(JTree.class$("javax.swing.event.TreeExpansionListener"), treeExpansionListener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.getListeners(JTree.class$("javax.swing.event.TreeExpansionListener"));
    }

    public void fireTreeCollapsed(TreePath treePath) {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeExpansionListener[] treeExpansionListenerArray = this.getTreeExpansionListeners();
        for (int i = 0; i < treeExpansionListenerArray.length; ++i) {
            treeExpansionListenerArray[i].treeCollapsed(treeExpansionEvent);
        }
    }

    public void fireTreeExpanded(TreePath treePath) {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeExpansionListener[] treeExpansionListenerArray = this.getTreeExpansionListeners();
        for (int i = 0; i < treeExpansionListenerArray.length; ++i) {
            treeExpansionListenerArray[i].treeExpanded(treeExpansionEvent);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(JTree.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(JTree.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.getListeners(JTree.class$("javax.swing.event.TreeSelectionListener"));
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListenerArray.length; ++i) {
            treeSelectionListenerArray[i].valueChanged(treeSelectionEvent);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(JTree.class$("javax.swing.event.TreeWillExpandListener"), treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(JTree.class$("javax.swing.event.TreeWillExpandListener"), treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.getListeners(JTree.class$("javax.swing.event.TreeWillExpandListener"));
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeWillExpandListener[] treeWillExpandListenerArray = this.getTreeWillExpandListeners();
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            treeWillExpandListenerArray[i].treeWillCollapse(treeExpansionEvent);
        }
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeWillExpandListener[] treeWillExpandListenerArray = this.getTreeWillExpandListeners();
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            treeWillExpandListenerArray[i].treeWillExpand(treeExpansionEvent);
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        if (this.treeModel == treeModel) {
            return;
        }
        if (this.treeModelListener == null) {
            this.treeModelListener = this.createTreeModelListener();
        }
        if (treeModel != null) {
            treeModel.addTreeModelListener(this.treeModelListener);
        }
        TreeModel treeModel2 = this.treeModel;
        this.treeModel = treeModel;
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, treeModel);
        this.updateUI();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, this.editable);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        if (this.rootVisible == bl) {
            return;
        }
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setShowsRootHandles(boolean bl) {
        if (this.showsRootHandles == bl) {
            return;
        }
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl2, bl);
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        if (this.cellEditor == treeCellEditor) {
            return;
        }
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.cellRenderer == treeCellRenderer) {
            return;
        }
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, treeCellRenderer);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.selectionModel == treeSelectionModel) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        this.selectionModel = treeSelectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, treeSelectionModel);
        this.revalidate();
        this.repaint();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        if (this.visibleRowCount == n) {
            return;
        }
        int n2 = this.visibleRowCount;
        this.visibleRowCount = n;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n2, n);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setLargeModel(boolean bl) {
        if (this.largeModel == bl) {
            return;
        }
        boolean bl2 = this.largeModel;
        this.largeModel = bl;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl2, bl);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        if (this.rowHeight == n) {
            return;
        }
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n2, n);
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        if (this.invokesStopCellEditing == bl) {
            return;
        }
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public void setToggleClickCount(int n) {
        if (this.toggleClickCount == n) {
            return;
        }
        int n2 = this.toggleClickCount;
        this.toggleClickCount = n;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, n2, n);
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Object[] objectArray = treePath.getPath();
        TreePath treePath2 = new TreePath(objectArray[0]);
        boolean bl = false;
        int n = 1;
        while (!bl) {
            while (this.isVisible(treePath2)) {
                if (n < objectArray.length) {
                    treePath2 = treePath2.pathByAddingChild(objectArray[n++]);
                    continue;
                }
                bl = true;
                break;
            }
            this.makeVisible(treePath2);
        }
        Rectangle rectangle = this.getPathBounds(treePath);
        this.scrollRectToVisible(rectangle);
        this.revalidate();
        this.repaint();
    }

    public void scrollRowToVisible(int n) {
        this.scrollPathToVisible(this.getPathForRow(n));
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setScrollsOnExpand(boolean bl) {
        if (this.scrollsOnExpand == bl) {
            return;
        }
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, bl2, bl);
    }

    public void setSelectionPath(TreePath treePath) {
        this.selectionModel.setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.setSelectionPaths(treePathArray);
    }

    public void setSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.setSelectionPath(treePath);
        }
    }

    public void setSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            treePathArray[i] = this.getPathForRow(nArray[i]);
        }
        this.setSelectionPaths(treePathArray);
    }

    public void setSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.setSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPath(TreePath treePath) {
        this.selectionModel.addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.addSelectionPaths(treePathArray);
    }

    public void addSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.addSelectionPath(treePath);
        }
    }

    public void addSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            treePathArray[i] = this.getPathForRow(nArray[i]);
        }
        this.addSelectionPaths(treePathArray);
    }

    public void addSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.addSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        this.selectionModel.removeSelectionPath(treePath);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.removeSelectionPaths(treePathArray);
    }

    public void removeSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.removeSelectionPath(treePath);
        }
    }

    public void removeSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            treePathArray[i] = this.getPathForRow(nArray[i]);
        }
        this.removeSelectionPaths(treePathArray);
    }

    public void removeSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.setLeadSelectionPath(null);
    }

    public TreePath getLeadSelectionPath() {
        return this.leadSelectionPath;
    }

    public void setLeadSelectionPath(TreePath treePath) {
        if (this.leadSelectionPath == treePath) {
            return;
        }
        TreePath treePath2 = this.leadSelectionPath;
        this.leadSelectionPath = treePath;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorSelectionPath;
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        if (this.anchorSelectionPath == treePath) {
            return;
        }
        TreePath treePath2 = this.anchorSelectionPath;
        this.anchorSelectionPath = treePath;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public int getLeadSelectionRow() {
        return this.selectionModel.getLeadSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.selectionModel.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.selectionModel.getMinSelectionRow();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.selectionModel.getSelectionRows();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.selectionModel.isPathSelected(treePath);
    }

    public boolean isRowSelected(int n) {
        return this.selectionModel.isPathSelected(this.getPathForRow(n));
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount(this);
        }
        return 0;
    }

    public void collapsePath(TreePath treePath) {
        try {
            this.fireTreeWillCollapse(treePath);
        }
        catch (ExpandVetoException expandVetoException) {
            // empty catch block
        }
        this.setExpandedState(treePath, false);
        this.fireTreeCollapsed(treePath);
    }

    public void collapseRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.collapsePath(treePath);
        }
    }

    public void expandPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        try {
            this.fireTreeWillExpand(treePath);
        }
        catch (ExpandVetoException expandVetoException) {
            // empty catch block
        }
        this.setExpandedState(treePath, true);
        this.fireTreeExpanded(treePath);
    }

    public void expandRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.expandPath(treePath);
        }
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.isExpanded(treePath) ^ true;
    }

    public boolean isCollapsed(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return false;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.isCollapsed(treePath);
        }
        return false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = this.nodeStates.get(treePath);
        if (object == null || object != EXPANDED) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean isExpanded(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return false;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.isExpanded(treePath);
        }
        return false;
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public void setExpandsSelectedPaths(boolean bl) {
        if (this.expandsSelectedPaths == bl) {
            return;
        }
        boolean bl2 = this.expandsSelectedPaths;
        this.expandsSelectedPaths = bl;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, bl2, bl);
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI == null) {
            return null;
        }
        return treeUI.getPathBounds(this, treePath);
    }

    public Rectangle getRowBounds(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.getPathBounds(treePath);
        }
        return null;
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.cancelEditing(this);
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(this, treePath);
        }
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath(this);
        }
        return null;
    }

    public TreePath getPathForLocation(int n, int n2) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && rectangle.contains(n, n2)) {
            return treePath;
        }
        return null;
    }

    public int getRowForLocation(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(this, n, n2);
        }
        return null;
    }

    public int getClosestRowForLocation(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    private void doExpandParents(TreePath treePath, boolean bl) {
        TreePath treePath2 = treePath.getParentPath();
        if (!this.isExpanded(treePath2) && treePath2 != null) {
            this.doExpandParents(treePath2, false);
        }
        this.nodeStates.put(treePath, bl ? EXPANDED : COLLAPSED);
    }

    protected void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath == null) {
            return;
        }
        this.doExpandParents(treePath, bl);
    }

    protected void clearToggledPaths() {
        this.nodeStates.clear();
    }

    protected Enumeration getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Enumeration enumeration = this.nodeStates.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (!treePath2.isDescendant(treePath)) continue;
            vector.addElement(treePath2);
        }
        return vector.elements();
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        return this.nodeStates.get(treePath) != null;
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        return this.isExpanded(treePath2);
    }

    public void makeVisible(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.expandPath(treePath.getParentPath());
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler(this);
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root node");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Child node 1");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Child node 1.1");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Child node 1.2");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Child node 1.3");
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Child node 2");
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Child node 2.1");
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Child node 2.2");
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Child node 2.3");
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("Child node 2.4");
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("Child node 3");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode2.add(defaultMutableTreeNode5);
        defaultMutableTreeNode6.add(defaultMutableTreeNode7);
        defaultMutableTreeNode6.add(defaultMutableTreeNode8);
        defaultMutableTreeNode6.add(defaultMutableTreeNode9);
        defaultMutableTreeNode6.add(defaultMutableTreeNode10);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return object.toString();
    }

    public String paramString() {
        return "";
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        Enumeration enumeration = this.nodeStates.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (this.nodeStates.get(treePath2) != EXPANDED || !treePath.isDescendant(treePath2)) continue;
            vector.add(treePath2);
        }
        return vector.elements();
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        if (string == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be less than zero.");
        }
        int n2 = this.getRowCount();
        if (n > n2) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be greater than the number of elements in the TreeModel.");
        }
        TreePath treePath = null;
        if (bias == Position.Bias.Forward) {
            for (int i = n; i < n2; ++i) {
                TreePath treePath2 = this.getPathForRow(i);
                Object object = treePath2.getLastPathComponent();
                String string2 = this.convertValueToText(object, this.isRowSelected(i), this.isExpanded(i), this.treeModel.isLeaf(object), i, false);
                if (!string2.startsWith(string)) continue;
                treePath = treePath2;
                break;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                TreePath treePath3 = this.getPathForRow(i);
                Object object = treePath3.getLastPathComponent();
                String string3 = this.convertValueToText(object, this.isRowSelected(i), this.isExpanded(i), this.treeModel.isLeaf(object), i, false);
                if (!string3.startsWith(string)) continue;
                treePath = treePath3;
                break;
            }
        }
        return treePath;
    }

    protected boolean removeDescendantSelectedPaths(TreePath treePath, boolean bl) {
        boolean bl2 = false;
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            if ((treePathArray[i] != treePath || !bl) && !treePathArray[i].isDescendant(treePath)) continue;
            this.removeSelectionPath(treePathArray[i]);
            bl2 = true;
        }
        return bl2;
    }

    protected void removeDescendantToggledPaths(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            TreePath treePath = (TreePath)enumeration.nextElement();
            Enumeration enumeration2 = this.getDescendantToggledPaths(treePath);
            while (enumeration2.hasMoreElements()) {
                TreePath treePath2 = (TreePath)enumeration2.nextElement();
                if (!this.isExpanded(treePath2)) continue;
                this.nodeStates.remove(treePath2);
            }
        }
    }

    public void treeDidChange() {
        this.repaint();
    }

    static {
        CELL_EDITOR_PROPERTY = CELL_EDITOR_PROPERTY;
        CELL_RENDERER_PROPERTY = CELL_RENDERER_PROPERTY;
        EDITABLE_PROPERTY = EDITABLE_PROPERTY;
        INVOKES_STOP_CELL_EDITING_PROPERTY = INVOKES_STOP_CELL_EDITING_PROPERTY;
        LARGE_MODEL_PROPERTY = LARGE_MODEL_PROPERTY;
        ROOT_VISIBLE_PROPERTY = ROOT_VISIBLE_PROPERTY;
        ROW_HEIGHT_PROPERTY = ROW_HEIGHT_PROPERTY;
        SCROLLS_ON_EXPAND_PROPERTY = SCROLLS_ON_EXPAND_PROPERTY;
        SELECTION_MODEL_PROPERTY = SELECTION_MODEL_PROPERTY;
        SHOWS_ROOT_HANDLES_PROPERTY = SHOWS_ROOT_HANDLES_PROPERTY;
        TOGGLE_CLICK_COUNT_PROPERTY = TOGGLE_CLICK_COUNT_PROPERTY;
        TREE_MODEL_PROPERTY = TREE_MODEL_PROPERTY;
        VISIBLE_ROW_COUNT_PROPERTY = VISIBLE_ROW_COUNT_PROPERTY;
        ANCHOR_SELECTION_PATH_PROPERTY = ANCHOR_SELECTION_PATH_PROPERTY;
        LEAD_SELECTION_PATH_PROPERTY = LEAD_SELECTION_PATH_PROPERTY;
        EXPANDS_SELECTED_PATHS_PROPERTY = EXPANDS_SELECTED_PATHS_PROPERTY;
        EXPANDED = new Object();
        COLLAPSED = new Object();
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -5815023306225701477L;
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        protected EmptySelectionModel() {
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }
    }

    protected class TreeSelectionRedirector
    implements TreeSelectionListener,
    Serializable {
        private /* synthetic */ JTree this$0;
        private static final long serialVersionUID = -3505069663646241664L;

        protected TreeSelectionRedirector(JTree jTree) {
            this.this$0 = jTree;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(this.this$0);
            this.this$0.fireValueChanged(treeSelectionEvent2);
            this.this$0.repaint();
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener {
        private /* synthetic */ JTree this$0;

        protected TreeModelHandler(JTree jTree) {
            this.this$0 = jTree;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            this.this$0.setExpandedState(treePath, this.this$0.isExpanded(treePath));
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected Object childValue;
        protected boolean loadedChildren;
        protected boolean hasChildren;

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            this.loadedChildren = false;
        }

        public int getChildCount() {
            this.loadChildren();
            return super.getChildCount();
        }

        protected void loadChildren() {
            if (!this.loadedChildren) {
                DynamicUtilTreeNode.createChildren(this, this.childValue);
                this.loadedChildren = true;
            }
        }

        public Enumeration children() {
            this.loadChildren();
            return super.children();
        }

        public TreeNode getChildAt(int n) {
            this.loadChildren();
            return super.getChildAt(n);
        }

        public boolean isLeaf() {
            return this.childValue == null || !(this.childValue instanceof Hashtable) && !(this.childValue instanceof Vector) && !this.childValue.getClass().isArray();
        }

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            block4: {
                block5: {
                    block3: {
                        if (!(object instanceof Hashtable)) break block3;
                        Hashtable hashtable = (Hashtable)object;
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            Object object2 = enumeration.nextElement();
                            Object object3 = hashtable.get(object2);
                            defaultMutableTreeNode.add(new DynamicUtilTreeNode(object2, object3));
                        }
                        break block4;
                    }
                    if (!(object instanceof Vector)) break block5;
                    Iterator iterator = ((Vector)object).iterator();
                    while (iterator.hasNext()) {
                        Object object4 = iterator.next();
                        defaultMutableTreeNode.add(new DynamicUtilTreeNode(object4, object4));
                    }
                    break block4;
                }
                if (object == null || !object.getClass().isArray()) break block4;
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[i], objectArray[i]));
                }
            }
        }
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        private /* synthetic */ JTree this$0;

        static /* synthetic */ JTree access$2(AccessibleJTree accessibleJTree, JTree jTree) {
            accessibleJTree.this$0 = jTree;
            return accessibleJTree.this$0;
        }

        static JTree access$0(AccessibleJTree accessibleJTree) {
            return accessibleJTree.this$0;
        }

        public AccessibleJTree(JTree jTree) {
            this.this$0 = jTree;
            super(jTree);
        }

        public void addAccessibleSelection(int n) {
            this.this$0.addSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            this.this$0.clearSelection();
        }

        public void fireVisibleDataPropertyChange() {
            this.this$0.treeDidChange();
        }

        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = this.this$0.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(this, this.this$0, treePath, null);
            }
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                return treeModel.getChildCount(treeModel.getRoot());
            }
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleSelection getAccessibleSelection() {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                return new AccessibleJTreeNode(this, this.this$0, new TreePath(treeModel.getRoot()), null).getAccessibleSelection();
            }
            return null;
        }

        public Accessible getAccessibleSelection(int n) {
            TreeModel treeModel = this.this$0.getModel();
            if (treeModel != null) {
                return new AccessibleJTreeNode(this, this.this$0, new TreePath(treeModel.getRoot()), null).getAccessibleSelection(n);
            }
            return null;
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectionCount();
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public void removeAccessibleSelection(int n) {
            this.this$0.removeSelectionInterval(n, n);
        }

        public void selectAllAccessibleSelection() {
            if (this.this$0.getSelectionModel().getSelectionMode() != 1) {
                this.this$0.addSelectionInterval(0, this.this$0.getVisibleRowCount());
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.fireTreeCollapsed(treeExpansionEvent.getPath());
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.fireTreeExpanded(treeExpansionEvent.getPath());
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.this$0.fireValueChanged(treeSelectionEvent);
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private /* synthetic */ AccessibleJTree this$1;
            private JTree tree;
            private TreePath tp;
            private Accessible acc;
            private AccessibleStateSet states = new AccessibleStateSet();
            private Vector selectionList = new Vector();
            private Vector actionList = new Vector();
            private TreeModel mod = this.tree.getModel();
            private Cursor cursor;

            public AccessibleJTreeNode(AccessibleJTree accessibleJTree, JTree jTree, TreePath treePath, Accessible accessible) {
                this.this$1 = accessibleJTree;
                this.cursor = AccessibleJTree.access$0(accessibleJTree).getCursor();
                this.tree = jTree;
                this.tp = treePath;
                this.acc = accessible;
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath2 = treePathArray[i];
                    if (!treePath2.getParentPath().equals(this.tp)) continue;
                    this.selectionList.add(treePath2);
                }
                this.actionList.add("EXPAND");
                this.actionList.add("COLLAPSE");
                this.actionList.add("EDIT");
                this.actionList.add("SELECT");
                this.actionList.add("DESELECT");
            }

            public void addAccessibleSelection(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    this.selectionList.add(object);
                    this.tree.addSelectionPath(this.tp.pathByAddingChild(object));
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                this.tree.addFocusListener(focusListener);
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void clearAccessibleSelection() {
                this.selectionList.clear();
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public boolean doAccessibleAction(int n) {
                if (n >= this.actionList.size() || n < 0) {
                    return false;
                }
                if (this.actionList.get(n).equals("EXPAND")) {
                    this.tree.expandPath(this.tp);
                } else if (this.actionList.get(n).equals("COLLAPSE")) {
                    this.tree.collapsePath(this.tp);
                } else if (this.actionList.get(n).equals("SELECT")) {
                    this.tree.addSelectionPath(this.tp);
                } else if (this.actionList.get(n).equals("DESELECT")) {
                    this.tree.removeSelectionPath(this.tp);
                } else if (this.actionList.get(n).equals("EDIT")) {
                    this.tree.startEditingAtPath(this.tp);
                } else {
                    return false;
                }
                return true;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                return this.actionList.size();
            }

            public String getAccessibleActionDescription(int n) {
                if (n < 0 || n >= this.actionList.size()) {
                    return this.actionList.get(n).toString();
                }
                return super.getAccessibleDescription();
            }

            public Accessible getAccessibleAt(Point point) {
                TreePath treePath = this.tree.getClosestPathForLocation(point.x, point.y);
                if (treePath != null) {
                    return new AccessibleJTreeNode(this.this$1, this.tree, treePath, this);
                }
                return null;
            }

            public Accessible getAccessibleChild(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    return new AccessibleJTreeNode(this.this$1, this.tree, this.tp.pathByAddingChild(object), this.acc);
                }
                return null;
            }

            public int getAccessibleChildrenCount() {
                TreeModel treeModel = this.this$1.this$0.getModel();
                if (treeModel != null) {
                    return treeModel.getChildCount(this.tp.getLastPathComponent());
                }
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                return super.getAccessibleDescription();
            }

            public int getAccessibleIndexInParent() {
                AccessibleContext accessibleContext = this.getAccessibleParent().getAccessibleContext();
                if (accessibleContext != null) {
                    for (int i = 0; i < accessibleContext.getAccessibleChildrenCount(); ++i) {
                        if (!accessibleContext.getAccessibleChild(i).equals(this)) continue;
                        return i;
                    }
                }
                return -1;
            }

            public String getAccessibleName() {
                return super.getAccessibleName();
            }

            public Accessible getAccessibleParent() {
                return super.getAccessibleParent();
            }

            public AccessibleRole getAccessibleRole() {
                return this.this$1.getAccessibleRole();
            }

            public AccessibleSelection getAccessibleSelection() {
                return this;
            }

            public Accessible getAccessibleSelection(int n) {
                if (n > 0 && n < this.getAccessibleSelectionCount()) {
                    return new AccessibleJTreeNode(this.this$1, this.tree, this.tp.pathByAddingChild(this.selectionList.get(n)), this.acc);
                }
                return null;
            }

            public int getAccessibleSelectionCount() {
                return this.selectionList.size();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                if (this.isVisible()) {
                    this.states.add(AccessibleState.VISIBLE);
                }
                if (this.tree.isCollapsed(this.tp)) {
                    this.states.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    this.states.add(AccessibleState.EDITABLE);
                }
                if (this.mod != null && !this.mod.isLeaf(this.tp.getLastPathComponent())) {
                    this.states.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.tp)) {
                    this.states.add(AccessibleState.EXPANDED);
                }
                if (this.this$1.this$0.isFocusable()) {
                    this.states.add(AccessibleState.FOCUSABLE);
                }
                if (this.this$1.this$0.hasFocus()) {
                    this.states.add(AccessibleState.FOCUSED);
                }
                if (this.tree.getSelectionModel().getSelectionMode() != 1) {
                    this.states.add(AccessibleState.MULTISELECTABLE);
                }
                if (this.tree.isOpaque()) {
                    this.states.add(AccessibleState.OPAQUE);
                }
                if (this.tree.isPathSelected(this.tp)) {
                    this.states.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    this.states.add(AccessibleState.SHOWING);
                }
                this.states.add(AccessibleState.SELECTABLE);
                return this.states;
            }

            public AccessibleText getAccessibleText() {
                return super.getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return super.getAccessibleValue();
            }

            public Color getBackground() {
                return this.tree.getBackground();
            }

            public Rectangle getBounds() {
                return this.tree.getPathBounds(this.tp);
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public Font getFont() {
                return this.tree.getFont();
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.tree.getFontMetrics(font);
            }

            public Color getForeground() {
                return this.tree.getForeground();
            }

            public Locale getLocale() {
                return this.tree.getLocale();
            }

            public Point getLocation() {
                return this.getLocationInJTree();
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.tp);
                return new Point(rectangle.x, rectangle.y);
            }

            public Point getLocationOnScreen() {
                Point point = this.getLocation();
                SwingUtilities.convertPointToScreen(point, this.tree);
                return point;
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                return rectangle.getSize();
            }

            public boolean isAccessibleChildSelected(int n) {
                Object object = this.mod.getChild(this.tp.getLastPathComponent(), n);
                if (object != null) {
                    return this.tree.isPathSelected(this.tp.pathByAddingChild(object));
                }
                return false;
            }

            public boolean isEnabled() {
                return this.tree.isEnabled();
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public boolean isShowing() {
                return this.isVisible() && this.tree.isShowing();
            }

            public boolean isVisible() {
                return this.tree.isVisible(this.tp);
            }

            public void removeAccessibleSelection(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    if (this.selectionList.contains(object)) {
                        this.selectionList.remove(object);
                        this.tree.removeSelectionPath(this.tp.pathByAddingChild(object));
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.tree.removeFocusListener(focusListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void requestFocus() {
                this.tree.requestFocus();
            }

            public void selectAllAccessibleSelection() {
                Object object = this.tp.getLastPathComponent();
                if (this.mod != null) {
                    for (int i = 0; i < this.mod.getChildCount(object); ++i) {
                        Object object2 = this.mod.getChild(object, i);
                        if (object2 == null) continue;
                        if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                            this.clearAccessibleSelection();
                        }
                        if (!this.selectionList.contains(object2)) continue;
                        this.selectionList.add(object2);
                        this.tree.addSelectionPath(this.tp.pathByAddingChild(object2));
                    }
                }
            }

            public void setAccessibleDescription(String string) {
                super.setAccessibleDescription(string);
            }

            public void setAccessibleName(String string) {
                super.setAccessibleName(string);
            }

            public void setBackground(Color color) {
            }

            public void setBounds(Rectangle rectangle) {
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public void setEnabled(boolean bl) {
            }

            public void setFont(Font font) {
            }

            public void setForeground(Color color) {
            }

            public void setLocation(Point point) {
            }

            public void setSize(Dimension dimension) {
            }

            public void setVisible(boolean bl) {
            }
        }
    }
}

