/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    static HashMap currentRepaintManagers;
    HashMap dirtyComponents = new HashMap();
    HashMap workDirtyComponents = new HashMap();
    ArrayList repaintOrder = new ArrayList();
    ArrayList workRepaintOrder = new ArrayList();
    Comparator comparator;
    RepaintWorker repaintWorker;
    ArrayList invalidComponents = new ArrayList();
    ArrayList workInvalidComponents = new ArrayList();
    boolean doubleBufferingEnabled = true;
    Image doubleBuffer;
    Dimension doubleBufferMaximumSize;

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker(this);
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
    }

    public static RepaintManager currentManager(Component component) {
        ThreadGroup threadGroup;
        RepaintManager repaintManager;
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new HashMap();
        }
        if ((repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup = Thread.currentThread().getThreadGroup())) == null) {
            repaintManager = new RepaintManager();
            currentRepaintManagers.put(threadGroup, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new HashMap();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        currentRepaintManagers.put(threadGroup, repaintManager);
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Container container;
        for (container = jComponent.getParent(); !(container == null || container instanceof JComponent && ((JComponent)container).isValidateRoot()); container = container.getParent()) {
        }
        if (container != null && container instanceof JComponent && ((JComponent)container).isValidateRoot()) {
            jComponent = (JComponent)container;
        }
        if (this.invalidComponents.contains(jComponent)) {
            return;
        }
        this.invalidComponents.add(jComponent);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        this.invalidComponents.remove(jComponent);
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0 || !jComponent.isShowing()) {
            return;
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.dirtyComponents.containsKey(jComponent)) {
            rectangle = rectangle.union((Rectangle)this.dirtyComponents.get(jComponent));
        } else {
            this.insertInRepaintOrder(jComponent);
        }
        this.dirtyComponents.put(jComponent, rectangle);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    private void insertInRepaintOrder(JComponent jComponent) {
        int n;
        if (this.comparator == null) {
            this.comparator = new ComponentComparator(this);
        }
        if ((n = Collections.binarySearch(this.repaintOrder, jComponent, this.comparator)) < 0) {
            n ^= 0xFFFFFFFF;
        }
        this.repaintOrder.add(n, jComponent);
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public void markCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        this.addDirtyRegion(jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jComponent.isCompletelyDirty = true;
    }

    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            try {
                this.dirtyComponents.remove(jComponent);
            }
            finally {
                Object var3_3 = null;
            }
            jComponent.isCompletelyDirty = false;
            return;
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        if (!this.dirtyComponents.containsKey(jComponent)) {
            return false;
        }
        return jComponent.isCompletelyDirty;
    }

    public void validateInvalidComponents() {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            Object object;
            try {
                object = this.invalidComponents;
                this.invalidComponents = this.workInvalidComponents;
                this.workInvalidComponents = object;
            }
            finally {
                object = null;
            }
            object = this.workInvalidComponents.iterator();
            while (object.hasNext()) {
                JComponent jComponent = (JComponent)object.next();
                if (!jComponent.isVisible() || !jComponent.isShowing()) continue;
                jComponent.validate();
            }
            this.workInvalidComponents.clear();
            return;
        }
    }

    public synchronized void paintDirtyRegions() {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            Serializable serializable;
            Object object;
            try {
                object = this.workRepaintOrder;
                this.workRepaintOrder = this.repaintOrder;
                this.repaintOrder = object;
                serializable = this.workDirtyComponents;
                this.workDirtyComponents = this.dirtyComponents;
                this.dirtyComponents = serializable;
            }
            finally {
                object = null;
            }
            object = this.workRepaintOrder.iterator();
            while (object.hasNext()) {
                serializable = (JComponent)object.next();
                Rectangle rectangle = (Rectangle)this.workDirtyComponents.get(serializable);
                if (rectangle == null || rectangle.isEmpty()) continue;
                ((JComponent)serializable).paintImmediately(rectangle);
            }
            this.workRepaintOrder.clear();
            this.workDirtyComponents.clear();
            return;
        }
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        if (this.doubleBuffer == null || (this.doubleBuffer.getWidth(null) < n || this.doubleBuffer.getHeight(null) < n2) && n < this.doubleBufferMaximumSize.width && n2 < this.doubleBufferMaximumSize.height) {
            this.doubleBuffer = component.createImage(n, n2);
        }
        return this.doubleBuffer;
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        int n3 = this.doubleBufferMaximumSize.width;
        int n4 = this.doubleBufferMaximumSize.height;
        return component.createVolatileImage(Math.min(n3, n), Math.min(n4, n2));
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaximumSize = dimension;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    private class ComponentComparator
    implements Comparator {
        private /* synthetic */ RepaintManager this$0;

        public int compare(Object object, Object object2) {
            if (object instanceof JComponent && object2 instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                JComponent jComponent2 = (JComponent)object2;
                return this.getDepth(jComponent) - this.getDepth(jComponent2);
            }
            throw new ClassCastException("This comparator can only be used with JComponents");
        }

        private int getDepth(JComponent jComponent) {
            Container container = jComponent;
            int n = 0;
            while (container != null) {
                container = container.getParent();
                ++n;
            }
            return n;
        }

        ComponentComparator(RepaintManager repaintManager) {
            this.this$0 = repaintManager;
        }
    }

    protected class RepaintWorker
    implements Runnable {
        private /* synthetic */ RepaintManager this$0;
        boolean live = false;

        public RepaintWorker(RepaintManager repaintManager) {
            this.this$0 = repaintManager;
        }

        public synchronized void setLive(boolean bl) {
            this.live = bl;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        public void run() {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            RepaintManager repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup);
            this.setLive(false);
            repaintManager.validateInvalidComponents();
            repaintManager.paintDirtyRegions();
        }
    }
}

