/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    private static final long serialVersionUID = -4480022884523193743L;
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy;
    protected int hsbPolicy;

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        this.viewport = jScrollPane.getViewport();
        this.rowHead = jScrollPane.getRowHeader();
        this.colHead = jScrollPane.getColumnHeader();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        this.lowerLeft = jScrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = jScrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = jScrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = jScrollPane.getCorner("UPPER_RIGHT_CORNER");
    }

    protected Component addSingletonComponent(Component component, Component component2) {
        if (component != null && component != component2) {
            component.getParent().remove(component);
        }
        return component2;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == "VIEWPORT") {
            this.viewport = (JViewport)component;
        } else if (string == "VERTICAL_SCROLLBAR") {
            this.vsb = (JScrollBar)component;
        } else if (string == "HORIZONTAL_SCROLLBAR") {
            this.hsb = (JScrollBar)component;
        } else if (string == "ROW_HEADER") {
            this.rowHead = (JViewport)component;
        } else if (string == "COLUMN_HEADER") {
            this.colHead = (JViewport)component;
        } else if (string == "LOWER_RIGHT_CORNER") {
            this.lowerRight = component;
        } else if (string == "UPPER_RIGHT_CORNER") {
            this.upperRight = component;
        } else if (string == "LOWER_LEFT_CORNER") {
            this.lowerLeft = component;
        } else if (string == "UPPER_LEFT_CORNER") {
            this.upperLeft = component;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (n != 20 && n != 21 && n != 22) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.vsbPolicy = n;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        if (n != 30 && n != 31 && n != 32) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.hsbPolicy = n;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String string) {
        if (string == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (string == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (string == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (string == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public Dimension preferredLayoutSize(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        Dimension dimension = this.viewport.getPreferredSize();
        Dimension dimension2 = this.viewport.getViewSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.hsb != null && dimension2.width > dimension.width) {
            n2 += this.hsb.getPreferredSize().height;
        }
        if (this.vsb != null && dimension2.height > dimension.height) {
            n += this.vsb.getPreferredSize().width;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 += this.colHead.getPreferredSize().height;
        }
        Insets insets = jScrollPane.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.left + insets.right);
    }

    public Dimension minimumLayoutSize(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        Dimension dimension = this.viewport.getMinimumSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.hsb != null && this.hsb.isVisible()) {
            n2 += this.hsb.getMinimumSize().height;
        }
        if (this.vsb != null && this.vsb.isVisible()) {
            n += this.vsb.getMinimumSize().width;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getMinimumSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 += this.colHead.getMinimumSize().height;
        }
        Insets insets = jScrollPane.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public void layoutContainer(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        JViewport jViewport = jScrollPane.getViewport();
        Dimension dimension = jViewport.getViewSize();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Rectangle rectangle = SwingUtilities.calculateInnerArea(jScrollPane, null);
        n = rectangle.x;
        n5 = rectangle.y;
        n4 = rectangle.x + rectangle.width;
        n8 = rectangle.y + rectangle.height;
        n6 = this.colHead != null ? n5 + this.colHead.getPreferredSize().height : n5;
        n2 = this.rowHead != null ? n + this.rowHead.getPreferredSize().width : n;
        int n9 = jScrollPane.getVerticalScrollBarPolicy();
        int n10 = jScrollPane.getHorizontalScrollBarPolicy();
        boolean bl = this.vsb != null && (n9 == 22 || n9 == 20 && dimension.height > n8 - n6);
        boolean bl2 = this.hsb != null && (n10 == 32 || n10 == 30 && dimension.width > n4 - n2);
        n3 = !bl ? n4 : n4 - this.vsb.getPreferredSize().width;
        n7 = !bl2 ? n8 : n8 - this.hsb.getPreferredSize().height;
        if (jViewport != null) {
            jViewport.setBounds(new Rectangle(n2, n6, n3 - n2, n7 - n6));
        }
        if (this.colHead != null) {
            this.colHead.setBounds(new Rectangle(n2, n5, n3 - n2, n6 - n5));
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(new Rectangle(n, n6, n2 - n, n7 - n6));
        }
        if (bl) {
            this.vsb.setVisible(true);
            this.vsb.setBounds(new Rectangle(n3, n6, n4 - n3, n7 - n6));
        } else if (this.vsb != null) {
            this.vsb.setVisible(false);
        }
        if (bl2) {
            this.hsb.setVisible(true);
            this.hsb.setBounds(new Rectangle(n2, n7, n3 - n2, n8 - n7));
        } else if (this.hsb != null) {
            this.hsb.setVisible(false);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(new Rectangle(n, n5, n2 - n, n6 - n5));
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(new Rectangle(n3, n5, n4 - n3, n6 - n5));
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(new Rectangle(n, n7, n2 - n, n8 - n7));
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(new Rectangle(n3, n7, n4 - n3, n8 - n7));
        }
    }

    public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
        return null;
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

