/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import javax.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private static final long serialVersionUID = 7279176385485777821L;
    private Number value;
    private Comparable minimum;
    private Comparable maximum;
    private Number stepSize;

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public SpinnerNumberModel(double d, double d2, double d3, double d4) {
        this(new Double(d), new Double(d2), new Double(d3), new Double(d4));
    }

    public SpinnerNumberModel(int n, int n2, int n3, int n4) {
        this(new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
    }

    public SpinnerNumberModel(Number number, Comparable comparable, Comparable comparable2, Number number2) {
        if (number2 == null) {
            throw new IllegalArgumentException("stepSize may not be null");
        }
        if (number == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        if (comparable != null) {
            if (comparable.compareTo(number) > 0) {
                throw new IllegalArgumentException("minimum is not <= value");
            }
        } else {
            comparable = new Comparable(this){
                private /* synthetic */ SpinnerNumberModel this$0;
                {
                    this.this$0 = spinnerNumberModel;
                }

                public int compareTo(Object object) {
                    return -1;
                }
            };
        }
        if (comparable2 != null) {
            if (comparable2.compareTo(number) < 0) {
                throw new IllegalArgumentException("maximum is not >= value");
            }
        } else {
            comparable2 = new Comparable(this){
                private /* synthetic */ SpinnerNumberModel this$0;
                {
                    this.this$0 = spinnerNumberModel;
                }

                public int compareTo(Object object) {
                    return 1;
                }
            };
        }
        this.value = number;
        this.stepSize = number2;
        this.minimum = comparable;
        this.maximum = comparable2;
    }

    public void setValue(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("value must be a Number");
        }
        this.value = (Number)object;
        this.fireStateChanged();
    }

    public Object getValue() {
        return this.value;
    }

    public Object getNextValue() {
        Number number = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() + this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() + this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() + this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() + this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short(this.value.shortValue() + this.stepSize.shortValue()) : (Number)new Byte(this.value.byteValue() + this.stepSize.byteValue())))));
        if (this.maximum.compareTo(number) >= 0) {
            return number;
        }
        return null;
    }

    public Object getPreviousValue() {
        Number number = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() - this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() - this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() - this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() - this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short(this.value.shortValue() - this.stepSize.shortValue()) : (Number)new Byte(this.value.byteValue() - this.stepSize.byteValue())))));
        if (this.minimum.compareTo(number) <= 0) {
            return number;
        }
        return null;
    }

    public Number getNumber() {
        return this.value;
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Comparable comparable) {
        if (this.minimum != comparable) {
            this.minimum = comparable;
            this.fireStateChanged();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Comparable comparable) {
        if (this.maximum != comparable) {
            this.maximum = comparable;
            this.fireStateChanged();
        }
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(Number number) {
        if (number == null) {
            throw new IllegalArgumentException();
        }
        if (this.stepSize != number) {
            this.stepSize = number;
            this.fireStateChanged();
        }
    }
}

