/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public static Spring constant(int n) {
        return new SimpleSpring(n, n, n);
    }

    public static Spring constant(int n, int n2, int n3) {
        return new SimpleSpring(n, n2, n3);
    }

    public abstract int getMaximumValue();

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getValue();

    public static Spring max(Spring spring, Spring spring2) {
        return new MaxSpring(spring, spring2);
    }

    public static Spring minus(Spring spring) {
        return new MinusSpring(spring);
    }

    public abstract void setValue(int var1);

    public static Spring sum(Spring spring, Spring spring2) {
        return new AddSpring(spring, spring2);
    }

    private static final class MaxSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        protected MaxSpring(Spring spring, Spring spring2) {
            this.s1 = spring;
            this.s2 = spring2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int n = this.s1.getMaximumValue();
            int n2 = this.s2.getMaximumValue();
            return Math.max(n, n2);
        }

        public int getMinimumValue() {
            int n = this.s1.getMinimumValue();
            int n2 = this.s2.getMinimumValue();
            return Math.max(n, n2);
        }

        public int getPreferredValue() {
            int n = this.s1.getPreferredValue();
            int n2 = this.s2.getPreferredValue();
            return Math.max(n, n2);
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int n = this.s1.getValue();
                int n2 = this.s2.getValue();
                this.value = Math.max(n, n2);
            }
            return this.value;
        }

        public void setValue(int n) {
            this.value = n > this.getMaximumValue() ? this.getMaximumValue() : (n < this.getMinimumValue() ? this.getMinimumValue() : n);
        }
    }

    private static final class MinusSpring
    extends Spring {
        private final Spring s;
        private int value;

        protected MinusSpring(Spring spring) {
            this.s = spring;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                this.value = -this.s.getValue();
            }
            return this.value;
        }

        public void setValue(int n) {
            this.value = n > this.getMaximumValue() ? this.getMaximumValue() : (n < this.getMinimumValue() ? this.getMinimumValue() : n);
        }
    }

    private static final class AddSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        protected AddSpring(Spring spring, Spring spring2) {
            this.s1 = spring;
            this.s2 = spring2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int n = this.s1.getMaximumValue();
            int n2 = this.s2.getMaximumValue();
            return n + n2;
        }

        public int getMinimumValue() {
            int n = this.s1.getMinimumValue();
            int n2 = this.s2.getMinimumValue();
            return n + n2;
        }

        public int getPreferredValue() {
            int n = this.s1.getPreferredValue();
            int n2 = this.s2.getPreferredValue();
            return n + n2;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int n = this.s1.getValue();
                int n2 = this.s2.getValue();
                this.value = n + n2;
            }
            return this.value;
        }

        public void setValue(int n) {
            this.value = n > this.getMaximumValue() ? this.getMaximumValue() : (n < this.getMinimumValue() ? this.getMinimumValue() : n);
        }
    }

    private static final class SimpleSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;
        private int value;

        public SimpleSpring(int n, int n2, int n3) {
            this.min = n;
            this.pref = n2;
            this.max = n3;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            return this.max;
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                this.value = this.pref;
            }
            return this.value;
        }

        public void setValue(int n) {
            this.value = n > this.max ? this.max : (n < this.min ? this.min : n);
        }
    }
}

