/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;

public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;

    private SwingUtilities() {
    }

    public static Rectangle calculateInsetArea(Rectangle rectangle, Insets insets, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        return rectangle2;
    }

    public static Rectangle calculateInnerArea(JComponent jComponent, Rectangle rectangle) {
        Rectangle rectangle2 = SwingUtilities.getLocalBounds(jComponent);
        return SwingUtilities.calculateInsetArea(rectangle2, jComponent.getInsets(), rectangle);
    }

    public static Component findFocusOwner(Component component) {
        Component component2;
        for (Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component3 != null; component3 = component3.getParent()) {
            if (component3 != component) continue;
            return component2;
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        return component.getAccessibleContext().getAccessibleComponent().getAccessibleAt(point);
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        return component.getAccessibleContext().getAccessibleChild(n);
    }

    public static int getAccessibleChildrenCount(Component component) {
        return component.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component component) {
        return component.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        return component.getAccessibleContext().getAccessibleStateSet();
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(SwingUtilities.class$("javax.swing.JRootPane"), component);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Container getAncestorNamed(String string, Component component) {
        while (component != null && component.getName() != string) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Container getAncestorOfClass(Class clazz, Component component) {
        while (component != null && !clazz.isInstance(component)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Window getWindowAncestor(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(SwingUtilities.class$("java.awt.Window"), component);
    }

    public static Window windowForComponent(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(SwingUtilities.class$("java.awt.Window"), component);
    }

    public static Component getRoot(Component component) {
        Applet applet = null;
        Window window = null;
        while (component != null) {
            if (window == null && component instanceof Window) {
                window = (Window)component;
            } else if (component instanceof Applet) {
                applet = (Applet)component;
            }
            component = component.getParent();
        }
        if (window != null) {
            return window;
        }
        return applet;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null && component2 != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentAt(n, n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null) {
            component = SwingUtilities.getRoot(component2);
        }
        if (component2 == null) {
            component2 = SwingUtilities.getRoot(component);
        }
        if (component.isShowing() && component2.isShowing()) {
            SwingUtilities.convertPointToScreen(point, component);
            SwingUtilities.convertPointFromScreen(point, component2);
        }
        return point;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        return SwingUtilities.convertPoint(component, point.x, point.y, component2);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = SwingUtilities.convertPoint(component, rectangle.x, rectangle.y, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = SwingUtilities.convertPoint(component, mouseEvent.getX(), mouseEvent.getY(), component2);
        return new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static void updateComponentTreeUI(Component component) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtilities.updateComponentTreeUI(componentArray[i]);
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (n4 == 10) {
            n4 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (n4 == 11) {
            n4 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        if (n2 == 10) {
            n2 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (n2 == 11) {
            n2 = jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        return SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        if (icon == null) {
            n5 = 0;
            rectangle2.width = 0;
            rectangle2.height = 0;
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (string == null || string.equals("")) {
            n5 = 0;
            rectangle3.width = 0;
            rectangle3.height = 0;
        } else {
            n6 = 0;
            rectangle3.width = fontMetrics.stringWidth(string);
            rectangle3.height = fontMetrics.getHeight();
            while (string.indexOf(10, n6) != -1) {
                rectangle3.height += fontMetrics.getHeight();
                n6 = string.indexOf(10, n6) + 1;
            }
        }
        switch (n4) {
            case 2: {
                rectangle3.x = 0;
                rectangle2.x = rectangle3.width + n5;
                break;
            }
            case 4: {
                rectangle2.x = 0;
                rectangle3.x = rectangle2.width + n5;
                break;
            }
            case 0: {
                n6 = Math.max(rectangle3.width, rectangle2.width) / 2;
                rectangle3.x = n6 - rectangle3.width / 2;
                rectangle2.x = n6 - rectangle2.width / 2;
            }
        }
        switch (n3) {
            case 1: {
                rectangle3.y = 0;
                rectangle2.y = n4 == 0 ? rectangle3.height + n5 : 0;
                break;
            }
            case 3: {
                rectangle2.y = 0;
                rectangle3.y = n4 == 0 ? rectangle2.height + n5 : Math.max(rectangle2.height - rectangle3.height, 0);
                break;
            }
            case 0: {
                n6 = Math.max(rectangle3.height, rectangle2.height) / 2;
                rectangle3.y = n6 - rectangle3.height / 2;
                rectangle2.y = n6 - rectangle2.height / 2;
            }
        }
        Rectangle rectangle4 = rectangle3.union(rectangle2);
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        switch (n) {
            case 1: {
                break;
            }
            case 3: {
                n8 += rectangle.height - rectangle4.height;
                break;
            }
            case 0: {
                n8 += rectangle.height / 2 - rectangle4.height / 2;
            }
        }
        switch (n2) {
            case 2: {
                break;
            }
            case 4: {
                n7 += rectangle.width - rectangle4.width;
                break;
            }
            case 0: {
                n7 += rectangle.width / 2 - rectangle4.width / 2;
            }
        }
        rectangle2.x += n7;
        rectangle2.y += n8;
        rectangle3.x += n7;
        rectangle3.y += n8;
        return string;
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        Container container2 = component.getParent();
        if (container2 != null) {
            container2.remove(component);
        }
        if (container != null) {
            container.add(component);
        }
        Shape shape = graphics.getClip();
        graphics.setClip(n, n2, n3, n4);
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
        graphics.setClip(shape);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static Frame getOwnerFrame() {
        if (ownerFrame == null) {
            ownerFrame = new OwnerFrame();
        }
        return ownerFrame;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x400) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x800) != 0;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x1000) != 0;
    }

    public static boolean notifyAction(Action action, KeyStroke keyStroke, KeyEvent keyEvent, Object object, int n) {
        if (action != null && action.isEnabled()) {
            String string = (String)action.getValue("ActionCommandKey");
            if (string == null && keyEvent.getKeyChar() != '\uffff') {
                string = new String(new char[]{keyEvent.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(object, 1001, string, n));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent jComponent, ActionMap actionMap) {
        ActionMap actionMap2 = jComponent.getActionMap();
        if (actionMap2 == null) {
            jComponent.setActionMap(actionMap);
        } else {
            ActionMap actionMap3 = actionMap2.getParent();
            while (actionMap3 != null && !(actionMap3 instanceof ActionMapUIResource)) {
                actionMap2 = actionMap3;
                actionMap3 = actionMap2.getParent();
            }
            actionMap2.setParent(actionMap);
        }
    }

    public static void replaceUIInputMap(JComponent jComponent, int n, InputMap inputMap) {
        InputMap inputMap2 = jComponent.getInputMap(n);
        if (inputMap2 == null) {
            jComponent.setInputMap(n, inputMap);
        } else {
            for (InputMap inputMap3 = inputMap2.getParent(); inputMap3 != null && !(inputMap3 instanceof InputMapUIResource); inputMap3 = inputMap3.getParent()) {
                inputMap2 = inputMap3;
            }
            inputMap2.setParent(inputMap);
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[4];
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        int n7 = rectangle2.width;
        int n8 = rectangle2.height;
        int n9 = n6 > n2 ? n6 - n2 : 0;
        int n10 = n6 + n8 < n2 + n4 ? n2 + n4 - n6 - n8 : 0;
        int n11 = n5 > n ? n5 - n : 0;
        int n12 = n + n3 > n5 + n7 ? n + n3 - n5 - n7 : 0;
        int n13 = n9 + n10 < n4 ? n4 - n9 - n10 : 0;
        rectangleArray[0] = n9 > 0 ? new Rectangle(n, n2, n3, n9) : null;
        rectangleArray[1] = n11 > 0 && n13 > 0 ? new Rectangle(n, n2 + n9, n11, n13) : null;
        rectangleArray[2] = n12 > 0 && n13 > 0 ? new Rectangle(n5 + n7, n2 + n9, n12, n13) : null;
        rectangleArray[3] = n10 > 0 ? new Rectangle(n, n2 + n9 + n13, n3, n10) : null;
        int n14 = 0;
        for (int i = 0; i < 4; ++i) {
            if (rectangleArray[i] == null) continue;
            ++n14;
        }
        Rectangle[] rectangleArray2 = new Rectangle[n14];
        for (int i = 3; i >= 0; --i) {
            if (rectangleArray[i] == null) continue;
            rectangleArray2[--n14] = rectangleArray[i];
        }
        return rectangleArray2;
    }

    public static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = (int)rectangle.getX();
        int n7 = (int)rectangle.getY();
        int n8 = (int)rectangle.getWidth();
        int n9 = (int)rectangle.getHeight();
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            return new Rectangle(n10, n11, n12, n5);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static Rectangle computeUnion(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = (int)rectangle.getX();
        int n7 = (int)rectangle.getY();
        int n8 = (int)rectangle.getWidth();
        int n9 = (int)rectangle.getHeight();
        int n10 = n < n6 ? n : n6;
        int n11 = n2 < n7 ? n2 : n7;
        int n12 = n + n3 > n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 > n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            return new Rectangle(n10, n11, n12, n5);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public static InputMap getUIInputMap(JComponent jComponent, int n) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getInputMap(n).getParent();
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent jComponent) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getActionMap().getParent();
        }
        return null;
    }

    private static class OwnerFrame
    extends Frame {
        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return true;
        }

        OwnerFrame() {
        }
    }
}

