/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class Timer
implements Serializable {
    private static final long serialVersionUID = -1116180831621385484L;
    private Runnable drainer;
    private static java.util.Timer timer = new java.util.Timer("swing.Timer", true);
    static boolean logTimers;
    protected EventListenerList listenerList;
    boolean coalesce;
    boolean repeats;
    int delay;
    int initialDelay;
    int ticks;
    private Task task;
    private long queue;
    private Object queueLock;

    private /* synthetic */ void finit$() {
        this.drainer = new Runnable(this){
            private /* synthetic */ Timer this$0;
            {
                this.this$0 = timer;
            }

            public void run() {
                this.this$0.drainEvents();
            }
        };
        this.listenerList = new EventListenerList();
        this.coalesce = true;
        this.repeats = true;
        this.queueLock = new Object();
    }

    static /* synthetic */ Task access$1(Timer timer) {
        return timer.task;
    }

    public Timer(int n, ActionListener actionListener) {
        this.finit$();
        this.delay = n;
        this.initialDelay = n;
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(Timer.class$("java.awt.event.ActionListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public static void setLogTimers(boolean bl) {
        logTimers = bl;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int n) {
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(Timer.class$("java.awt.event.ActionListener"), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(Timer.class$("java.awt.event.ActionListener"), actionListener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        Task task = this.task;
        if (task == null) {
            task = new Task(this);
            if (this.isRepeats()) {
                timer.schedule((TimerTask)task, this.getInitialDelay(), (long)this.getDelay());
            } else {
                timer.schedule((TimerTask)task, this.getInitialDelay());
            }
            this.task = task;
        }
    }

    public void stop() {
        Task task = this.task;
        if (task != null) {
            task.cancel();
            this.task = null;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, this.ticks++, "Timer"));
    }

    void drainEvents() {
        Object object = this.queueLock;
        synchronized (object) {
            try {
                if (this.isCoalesce()) {
                    if (this.queue > 0L) {
                        this.fireActionPerformed();
                    }
                } else {
                    while (this.queue > 0L) {
                        this.fireActionPerformed();
                        --this.queue;
                    }
                }
                this.queue = 0L;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    void queueEvent() {
        Object object = this.queueLock;
        synchronized (object) {
            block3: {
                try {
                    ++this.queue;
                    if (this.queue != 1L) break block3;
                    SwingUtilities.invokeLater(this.drainer);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    private class Task
    extends TimerTask {
        private /* synthetic */ Timer this$0;

        public void run() {
            if (logTimers) {
                System.out.println("javax.swing.Timer -> queueEvent()");
            }
            this.this$0.queueEvent();
            if (!this.this$0.repeats) {
                this.this$0.task = null;
            }
        }

        Task(Timer timer) {
            this.this$0 = timer;
        }
    }
}

