/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    transient Color shadow;
    transient Color darkShadow;
    transient Color highlight;
    private static final Dimension PREFERRED_SIZE = new Dimension(16, 16);
    private static final Dimension MINIMUM_SIZE = new Dimension(5, 5);
    private static final Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private /* synthetic */ void finit$() {
        this.shadow = Color.GRAY;
        this.darkShadow = new Color(102, 102, 102);
        this.highlight = Color.WHITE;
    }

    public BasicArrowButton(int n) {
        this.finit$();
        this.setDirection(n);
    }

    public BasicArrowButton(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.setBackground(color);
        this.shadow = color2;
        this.darkShadow = color3;
        this.highlight = color4;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Rectangle rectangle = this.getBounds();
        int n = rectangle.height / 4;
        int n2 = (rectangle.width - n) / 2;
        int n3 = (rectangle.height - n) / 2;
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed()) {
            ++n2;
            ++n3;
        }
        this.paintTriangle(graphics, n2, n3, n, this.direction, this.isEnabled());
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    public Dimension getMaximumSize() {
        return MAXIMUM_SIZE;
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        switch (n4) {
            case 1: {
                this.paintTriangleNorth(graphics, n, n2, n3, bl);
                break;
            }
            case 5: {
                this.paintTriangleSouth(graphics, n, n2, n3, bl);
                break;
            }
            case 2: 
            case 7: {
                this.paintTriangleWest(graphics, n, n2, n3, bl);
                break;
            }
            case 3: 
            case 4: {
                this.paintTriangleEast(graphics, n, n2, n3, bl);
            }
        }
        graphics.setColor(color);
    }

    private void paintTriangleNorth(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 2) / 2;
        int n5 = n2;
        int n6 = n4 - (n3 - 1);
        int n7 = n4 + (n3 - 1);
        int n8 = n2 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n8);
        polygon.addPoint(n7, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n8 + 1, n7 + 1, n8 + 1);
        }
    }

    private void paintTriangleSouth(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 2) / 2;
        int n5 = n2 + (n3 - 1);
        int n6 = n4 - (n3 - 1);
        int n7 = n4 + (n3 - 1);
        int n8 = n2;
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n8);
        polygon.addPoint(n7, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n4 + 1, n5, n7, n8 + 1);
            graphics.drawLine(n4 + 1, n5 + 1, n7 + 1, n8 + 1);
        }
    }

    private void paintTriangleEast(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n + (n3 - 1);
        int n5 = n2 + (n3 - 2) / 2;
        int n6 = n;
        int n7 = n5 - (n3 - 1);
        int n8 = n5 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n7);
        polygon.addPoint(n6, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n8, n4, n5 + 1);
            graphics.drawLine(n6 + 1, n8 + 1, n4 + 1, n5 + 1);
        }
    }

    private void paintTriangleWest(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = n;
        int n5 = n2 + (n3 - 2) / 2;
        int n6 = n + (n3 - 1);
        int n7 = n5 - (n3 - 1);
        int n8 = n5 + (n3 - 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(n4, n5);
        polygon.addPoint(n6, n7);
        polygon.addPoint(n6, n8);
        if (bl) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
        } else {
            graphics.setColor(Color.GRAY);
            graphics.fillPolygon(polygon);
            graphics.drawPolygon(polygon);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n8 + 1);
        }
    }
}

