/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class BasicComboBoxRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public BasicComboBoxRenderer() {
        this.setHorizontalAlignment(2);
        this.setBorder(noFocusBorder);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        String string = object.toString();
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(jList.getFont());
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        int n3 = this.getSize().width;
        if (n3 != 0 && n2 > n3) {
            char[] cArray = string.toCharArray();
            int n4 = 0;
            int n5 = 0;
            String string2 = "... ";
            n3 -= SwingUtilities.computeStringWidth(fontMetrics, string2);
            while (n5 < cArray.length && n4 < n3) {
                n4 = SwingUtilities.computeStringWidth(fontMetrics, new String(cArray, 0, ++n5));
            }
            this.setText(new String(cArray, 0, n5) + string2);
        } else {
            this.setText(string);
        }
        this.setOpaque(true);
        if (bl || bl2) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        return this;
    }

    public static class UIResource
    extends BasicComboBoxRenderer
    implements javax.swing.plaf.UIResource {
    }
}

