/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public BasicComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.installComboBoxListeners();
        this.configurePopup();
        this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
    }

    public void show() {
        Rectangle rectangle = this.comboBox.getBounds();
        int n = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        this.scroller.setPreferredSize(new Dimension(rectangle.width, n));
        this.pack();
        if (this.comboBox.getSelectedIndex() != -1) {
            this.list.setSelectedIndex(this.comboBox.getSelectedIndex());
        }
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n2 = this.comboBox.getSelectedIndex();
        if (n2 > this.comboBox.getMaximumRowCount()) {
            jScrollBar.setValue(this.getPopupHeightForRowCount(n2));
        }
        super.show(this.comboBox, 0, rectangle.height);
    }

    public void hide() {
        super.setVisible(false);
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        comboBoxModel.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeVisible(new PopupMenuEvent(this.comboBox));
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeInvisible(new PopupMenuEvent(this.comboBox));
        }
    }

    protected void firePopupMenuCanceled() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuCanceled(new PopupMenuEvent(this.comboBox));
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler(this);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler(this);
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler(this);
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected JList createList() {
        JList jList = new JList(this.comboBox.getModel());
        jList.setSelectionMode(1);
        return jList;
    }

    protected void configureList() {
        this.list.setModel(this.comboBox.getModel());
        this.list.setVisibleRowCount(this.comboBox.getMaximumRowCount());
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane();
    }

    protected void configureScroller() {
        this.scroller.setBorder(null);
        this.scroller.getViewport().setView(this.list);
        this.scroller.setHorizontalScrollBarPolicy(31);
    }

    protected void configurePopup() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.list = this.createList();
        ((JLabel)((Object)this.list.getCellRenderer())).setHorizontalAlignment(2);
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        super.add(this.scroller);
    }

    protected void installComboBoxListeners() {
        this.mouseListener = this.createMouseListener();
        this.comboBox.addMouseListener(this.mouseListener);
        this.mouseMotionListener = this.createMouseMotionListener();
        this.comboBox.addMouseMotionListener(this.mouseMotionListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        this.isAutoScrolling = true;
        if (n == 0) {
            this.autoScrollUp();
        } else {
            this.autoScrollDown();
        }
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
    }

    protected void autoScrollUp() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 0);
        jScrollBar.setValue(jScrollBar.getValue() - n);
        if (this.list.getSelectedIndex() != 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    protected void autoScrollDown() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 1);
        jScrollBar.setValue(jScrollBar.getValue() + n);
        if (this.list.getSelectedIndex() + 1 != this.comboBox.getItemCount()) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        return null;
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < n) {
            n = this.comboBox.getItemCount();
        }
        for (int i = 0; i < n; ++i) {
            Component component = listCellRenderer.getListCellRendererComponent(this.list, this.comboBox.getModel().getElementAt(i), -1, false, false);
            Dimension dimension = component.getPreferredSize();
            n2 += dimension.height;
        }
        return n2;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        return new Rectangle(n, n2, n3, n4);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        int n = this.list.locationToIndex(mouseEvent.getPoint());
        if (n >= 0) {
            this.list.setSelectedIndex(n);
        }
    }

    private void uninstallListeners() {
        this.uninstallListListeners();
        this.uninstallComboBoxListeners();
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
    }

    private void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    private void uninstallComboBoxListeners() {
        this.comboBox.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.removeMouseMotionListener(this.mouseMotionListener);
        this.mouseMotionListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        public InvocationKeyHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListSelectionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboPopup this$0;

        public ListDataHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected PropertyChangeHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("renderer")) {
                this.this$0.list.setCellRenderer((ListCellRenderer)propertyChangeEvent.getNewValue());
                this.this$0.revalidate();
                this.this$0.repaint();
            }
            if (propertyChangeEvent.getPropertyName().equals("dataModel")) {
                this.this$0.list.setModel((ComboBoxModel)propertyChangeEvent.getNewValue());
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.this$0.updateListBoxSelectionForEvent(mouseEvent, false);
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = this.this$0.list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                this.this$0.comboBox.setSelectedIndex(n);
            }
            this.this$0.hide();
        }
    }

    protected class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ItemHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.isVisible()) {
                int n = (int)this.this$0.comboBox.getPreferredSize().getHeight();
                int n2 = this.this$0.getSize().height;
                if (mouseEvent.getY() > n && mouseEvent.getY() - n < n2) {
                    int n3 = this.this$0.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY() - n));
                    int n4 = this.this$0.list.getFirstVisibleIndex();
                    if (n4 != 0) {
                        n3 += n4 + 1;
                    }
                    this.this$0.list.setSelectedIndex(n3);
                } else {
                    boolean bl;
                    boolean bl2 = mouseEvent.getY() < n;
                    boolean bl3 = bl = mouseEvent.getY() > n;
                    if (bl2) {
                        this.this$0.scrollDirection = 0;
                        this.this$0.startAutoScrolling(0);
                    } else if (bl) {
                        this.this$0.scrollDirection = 1;
                        this.this$0.startAutoScrolling(1);
                    }
                }
            }
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.comboBox.isEnabled()) {
                this.this$0.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            int n2;
            Component component = (Component)mouseEvent.getSource();
            Component component2 = SwingUtilities.getDeepestComponentAt(component, n2 = mouseEvent.getX(), n = mouseEvent.getY());
            if (!(component2 instanceof JComboBox)) {
                this.this$0.comboBox.setSelectedIndex(this.this$0.list.getSelectedIndex());
                if (this.this$0.isAutoScrolling) {
                    this.this$0.stopAutoScrolling();
                }
                this.this$0.hide();
            }
        }
    }
}

