/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected MouseInputAdapter borderListener;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected PropertyChangeListener propertyChangeListener;
    private VetoableChangeListener internalFrameVetoableChangeListener;
    private transient BasicInternalFrameListener internalFrameListener;
    protected JComponent eastPane;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected KeyStroke openMenuKey;
    protected BasicInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    protected LayoutManager internalFrameLayout;
    private transient JDesktopPane desktopPane;

    public BasicInternalFrameUI(JInternalFrame jInternalFrame) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame) {
            this.frame = (JInternalFrame)jComponent;
            this.internalFrameLayout = this.createLayoutManager();
            this.frame.setLayout(this.internalFrameLayout);
            ((JComponent)this.frame.getRootPane().getGlassPane()).setOpaque(false);
            this.frame.getRootPane().getGlassPane().setVisible(true);
            this.installDefaults();
            this.installListeners();
            this.installComponents();
            this.installKeyboardActions();
            this.frame.setOpaque(true);
            this.frame.invalidate();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.setLayout(null);
        ((JComponent)this.frame.getRootPane().getGlassPane()).setOpaque(true);
        this.frame.getRootPane().getGlassPane().setVisible(false);
        this.frame = null;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        this.frame.setVisible(false);
    }

    protected void installKeyboardActions() {
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.createInternalFrameListener();
        this.borderListener = this.createBorderListener(this.frame);
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.internalFrameVetoableChangeListener = new InternalFramePropertyChangeListener(this);
        this.frame.addMouseListener(this.borderListener);
        this.frame.addMouseMotionListener(this.borderListener);
        this.frame.addInternalFrameListener(this.internalFrameListener);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.frame.addVetoableChangeListener(this.internalFrameVetoableChangeListener);
        this.frame.getRootPane().getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
    }

    protected void uninstallDefaults() {
        this.frame.setBorder(null);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        if (this.desktopPane != null) {
            this.desktopPane.removeComponentListener(this.componentListener);
        }
        this.frame.getRootPane().getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.frame.removeInternalFrameListener(this.internalFrameListener);
        this.frame.removeMouseMotionListener(this.borderListener);
        this.frame.removeMouseListener(this.borderListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.borderListener = null;
        this.internalFrameListener = null;
        this.glassPaneDispatcher = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener(this);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.internalFrameLayout.preferredLayoutSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.internalFrameLayout.minimumLayoutSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.installMouseHandlers(jComponent2);
            this.frame.add(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new BasicInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener(this);
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener(this);
    }

    protected final boolean isKeyBindingRegistered() {
        return false;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
    }

    public final boolean isKeyBindingActive() {
        return false;
    }

    protected final void setKeyBindingActive(boolean bl) {
    }

    protected void setupMenuOpenKey() {
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent jComponent) {
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent jComponent) {
        this.replacePane(this.southPane, jComponent);
        this.southPane = jComponent;
    }

    public void setEastPane(JComponent jComponent) {
        this.replacePane(this.eastPane, jComponent);
        this.eastPane = jComponent;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setWestPane(JComponent jComponent) {
        this.replacePane(this.westPane, jComponent);
        this.westPane = jComponent;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    protected DesktopManager getDesktopManager() {
        DesktopManager desktopManager = null;
        JDesktopPane jDesktopPane = this.frame.getDesktopPane();
        if (jDesktopPane != null) {
            desktopManager = this.frame.getDesktopPane().getDesktopManager();
        }
        if (desktopManager == null) {
            desktopManager = this.createDesktopManager();
        }
        return desktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher(this);
    }

    private class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private /* synthetic */ BasicInternalFrameUI this$0;
        private static final int bSize = 5;
        private static final int offset = 10;

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(5, 5, 5, 5);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            Rectangle rectangle = this.this$0.frame.getBounds();
            Color color2 = component.getBackground();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, 5, rectangle.height);
            graphics.fillRect(0, 0, rectangle.width, 5);
            graphics.fillRect(0, rectangle.height - 5, rectangle.width, 5);
            graphics.fillRect(rectangle.width - 5, 0, 5, rectangle.height);
            boolean bl = false;
            int n5 = 5;
            int n6 = rectangle.width - 5;
            int n7 = rectangle.width;
            boolean bl2 = false;
            int n8 = 5;
            int n9 = rectangle.height - 5;
            int n10 = rectangle.height;
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0, 0, 5, n10);
            graphics.fillRect(0, 0, n7, 5);
            graphics.fillRect(0, n9, rectangle.width, 5);
            graphics.fillRect(n6, 0, 5, rectangle.height);
            graphics.fill3DRect(0, 10, 5, rectangle.height - 20, false);
            graphics.fill3DRect(10, 0, rectangle.width - 20, 5, false);
            graphics.fill3DRect(10, rectangle.height - 5, rectangle.width - 20, 5, false);
            graphics.fill3DRect(rectangle.width - 5, 10, 5, rectangle.height - 20, false);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        InternalFrameBorder(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("closed")) {
                if (this.this$0.frame.getDefaultCloseOperation() == 1) {
                    this.this$0.frame.setVisible(false);
                    this.this$0.frame.getDesktopPane().repaint();
                    throw new PropertyVetoException("close operation is HIDE_ON_CLOSE\n", propertyChangeEvent);
                }
                if (this.this$0.frame.getDefaultCloseOperation() == 2) {
                    this.this$0.closeFrame(this.this$0.frame);
                } else {
                    throw new PropertyVetoException("close operation is DO_NOTHING_ON_CLOSE\n", propertyChangeEvent);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("maximum")) {
                if (this.this$0.frame.isMaximum()) {
                    this.this$0.maximizeFrame(this.this$0.frame);
                } else {
                    this.this$0.minimizeFrame(this.this$0.frame);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("icon")) {
                if (this.this$0.frame.isIcon()) {
                    this.this$0.iconifyFrame(this.this$0.frame);
                } else {
                    this.this$0.deiconifyFrame(this.this$0.frame);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("selected")) {
                if (this.this$0.frame.isSelected()) {
                    this.this$0.activateFrame(this.this$0.frame);
                } else {
                    this.this$0.deactivateFrame(this.this$0.frame);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("rootPane") || propertyChangeEvent.getPropertyName().equals("glassPane")) {
                Component component = (Component)propertyChangeEvent.getOldValue();
                component.removeMouseListener(this.this$0.glassPaneDispatcher);
                component.removeMouseMotionListener(this.this$0.glassPaneDispatcher);
                Component component2 = (Component)propertyChangeEvent.getNewValue();
                component2.addMouseListener(this.this$0.glassPaneDispatcher);
                component2.addMouseMotionListener(this.this$0.glassPaneDispatcher);
                this.this$0.frame.revalidate();
            }
        }

        public InternalFramePropertyChangeListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private /* synthetic */ BasicInternalFrameUI this$0;
        private transient Component mouseEventTarget;
        private transient Component pressedComponent;
        private transient Component lastComponentEntered;
        private transient Component tempComponent;
        private transient int pressCount;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.activateFrame(this.this$0.frame);
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        private void acquireComponentForMouseEvent(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2;
            Point point;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Container container = this.this$0.frame.getLayeredPane();
            if (container == null) {
                return;
            }
            Component component = null;
            Point point2 = mouseEvent.getPoint();
            while (component == null && container != null) {
                component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
                if (component != null) continue;
                point2 = SwingUtilities.convertPoint(container, point2.x, point2.y, container.getParent());
                container = container.getParent();
            }
            if (component == this.this$0.frame.getContentPane()) {
                component = null;
            }
            if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != component) {
                point = SwingUtilities.convertPoint(this.this$0.frame.getContentPane(), n, n2, this.lastComponentEntered);
                mouseEvent2 = new MouseEvent(this.lastComponentEntered, 505, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                this.tempComponent = this.lastComponentEntered;
                this.lastComponentEntered = null;
                this.tempComponent.dispatchEvent(mouseEvent2);
            }
            if (component != null) {
                this.mouseEventTarget = component;
                if (component.isLightweight() && component.isShowing() && component != this.this$0.frame.getContentPane() && component != this.lastComponentEntered) {
                    this.lastComponentEntered = this.mouseEventTarget;
                    point = SwingUtilities.convertPoint(this.this$0.frame.getContentPane(), n, n2, this.lastComponentEntered);
                    mouseEvent2 = new MouseEvent(this.lastComponentEntered, 504, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    this.lastComponentEntered.dispatchEvent(mouseEvent2);
                }
            }
            if (mouseEvent.getID() == 502 || mouseEvent.getID() == 501 && this.pressCount > 0 || mouseEvent.getID() == 506) {
                this.mouseEventTarget = this.pressedComponent;
            } else if (mouseEvent.getID() == 500) {
                if (component != this.pressedComponent) {
                    this.mouseEventTarget = null;
                } else if (this.pressCount == 0) {
                    this.pressedComponent = null;
                }
            }
        }

        private void handleEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.acquireComponentForMouseEvent(mouseEvent);
                if (this.mouseEventTarget == null) {
                    return;
                }
                if (this.mouseEventTarget.equals(this.this$0.frame.getGlassPane())) {
                    return;
                }
                if (this.mouseEventTarget.isShowing() && aWTEvent.getID() != 504 && aWTEvent.getID() != 505) {
                    MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.this$0.frame.getGlassPane(), mouseEvent, this.mouseEventTarget);
                    this.mouseEventTarget.dispatchEvent(mouseEvent2);
                    switch (aWTEvent.getID()) {
                        case 501: {
                            if (this.pressCount++ != 0) break;
                            this.pressedComponent = this.mouseEventTarget;
                            break;
                        }
                        case 502: {
                            if (--this.pressCount != 0 || this.mouseEventTarget == this.pressedComponent) break;
                            this.pressedComponent = null;
                        }
                    }
                }
            }
        }

        protected GlassPaneDispatcher(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            Dimension dimension3 = this.this$0.frame.getSize();
            Insets insets = this.this$0.frame.getInsets();
            dimension3.width -= insets.left + insets.right;
            dimension3.height -= insets.top + insets.bottom;
            this.this$0.frame.getRootPane().getGlassPane().setBounds(0, 0, dimension3.width, dimension3.height);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.this$0.northPane != null) {
                dimension2 = this.this$0.northPane.getPreferredSize();
                n = Math.min(dimension2.height, dimension3.height);
                this.this$0.northPane.setBounds(insets.left, insets.top, dimension3.width, n);
            }
            if (this.this$0.southPane != null) {
                dimension2 = this.this$0.southPane.getPreferredSize();
                n2 = Math.min(dimension2.height, dimension3.height - n);
                this.this$0.southPane.setBounds(insets.left, insets.top + dimension3.height - n2, dimension3.width, n2);
            }
            int n5 = dimension3.height - n2 - n;
            if (this.this$0.westPane != null) {
                dimension = this.this$0.westPane.getPreferredSize();
                n4 = Math.min(dimension3.width, dimension.width);
                this.this$0.westPane.setBounds(insets.left, insets.top + n, n4, n5);
            }
            if (this.this$0.eastPane != null) {
                dimension = this.this$0.eastPane.getPreferredSize();
                n3 = Math.min(dimension.width, dimension3.width - n4);
                this.this$0.eastPane.setBounds(insets.left + dimension3.width - n3, insets.top + n, n3, n5);
            }
            int n6 = dimension3.width - n4 - n3;
            this.this$0.frame.getRootPane().setBounds(insets.left + n4, insets.top + n, n6, n5);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.getSize(container, true);
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getSize(container, false);
        }

        private Dimension getSize(Container container, boolean bl) {
            Dimension dimension;
            Insets insets = this.this$0.frame.getInsets();
            Dimension dimension2 = this.this$0.frame.getContentPane().getPreferredSize();
            if (bl) {
                dimension2.height = 0;
                dimension2.width = 0;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (this.this$0.northPane != null && (dimension = this.this$0.northPane.getPreferredSize()) != null) {
                n = dimension.width;
                n2 = dimension.height;
            }
            if (this.this$0.southPane != null && (dimension = this.this$0.southPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (this.this$0.eastPane != null && (dimension = this.this$0.eastPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (this.this$0.westPane != null && (dimension = this.this$0.westPane.getPreferredSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            int n9 = Math.max(n3, n);
            n9 = Math.max(n9, dimension2.width + n5 + n7);
            int n10 = Math.max(n6, n8);
            n10 = Math.max(n10, dimension2.height);
            n10 += n2 + n4;
            return new Dimension(n9 += insets.left + insets.right, n10 += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component component) {
        }

        public InternalFrameLayout(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this.this$0.frame.isMaximum()) {
                JDesktopPane jDesktopPane = (JDesktopPane)componentEvent.getSource();
                Insets insets = jDesktopPane.getInsets();
                Rectangle rectangle = jDesktopPane.getBounds();
                this.this$0.frame.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
                this.this$0.frame.revalidate();
                this.this$0.frame.repaint();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        protected ComponentHandler(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        private /* synthetic */ BasicInternalFrameUI this$0;
        protected final int RESIZE_NONE;
        private transient int xOffset;
        private transient int yOffset;
        private transient int direction;
        private transient Rectangle cacheRect;

        private /* synthetic */ void finit$() {
            this.RESIZE_NONE = 0;
            this.xOffset = 0;
            this.yOffset = 0;
            this.direction = -1;
            this.cacheRect = new Rectangle();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.frame.isMaximum()) {
                return;
            }
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            Rectangle rectangle = this.this$0.frame.getBounds();
            Dimension dimension = this.this$0.frame.getMinimumSize();
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Insets insets = this.this$0.frame.getInsets();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                switch (this.direction) {
                    case 1: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width, rectangle.height - n2);
                        break;
                    }
                    case 2: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), n, rectangle.height - n2);
                        break;
                    }
                    case 3: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n, rectangle.height);
                        break;
                    }
                    case 4: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n, n2);
                        break;
                    }
                    case 5: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, rectangle.width, n2);
                        break;
                    }
                    case 6: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, n2);
                        break;
                    }
                    case 7: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, rectangle.height);
                        break;
                    }
                    case 8: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width - n, rectangle.height - n2);
                    }
                }
                desktopManager.resizeFrame(this.this$0.frame, this.cacheRect.x, this.cacheRect.y, Math.max(dimension.width, this.cacheRect.width), Math.max(dimension.height, this.cacheRect.height));
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                Rectangle rectangle2 = this.this$0.frame.getBounds();
                desktopManager.dragFrame(this.this$0.frame, mouseEvent.getX() - this.xOffset + rectangle.x, mouseEvent.getY() - this.yOffset + rectangle.y);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.activateFrame(this.this$0.frame);
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Insets insets = this.this$0.frame.getInsets();
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                this.direction = this.sectionOfClick(n, n2);
                desktopManager.beginResizingFrame(this.this$0.frame, this.direction);
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                Rectangle rectangle = this.this$0.titlePane.getBounds();
                this.xOffset = mouseEvent.getX() - rectangle.x + insets.left;
                this.yOffset = mouseEvent.getY() - rectangle.y + insets.top;
                desktopManager.beginDraggingFrame(this.this$0.frame);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            this.xOffset = 0;
            this.yOffset = 0;
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                desktopManager.endResizingFrame(this.this$0.frame);
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                desktopManager.endDraggingFrame(this.this$0.frame);
            }
        }

        private int sectionOfClick(int n, int n2) {
            Insets insets = this.this$0.frame.getInsets();
            Rectangle rectangle = this.this$0.frame.getBounds();
            if (n < insets.left && n2 < insets.top) {
                return 8;
            }
            if (n > rectangle.width - insets.right && n2 < insets.top) {
                return 2;
            }
            if (n > rectangle.width - insets.right && n2 > rectangle.height - insets.bottom) {
                return 4;
            }
            if (n < insets.left && n2 > rectangle.height - insets.bottom) {
                return 6;
            }
            if (n2 < insets.top) {
                return 1;
            }
            if (n < insets.left) {
                return 7;
            }
            if (n2 > rectangle.height - insets.bottom) {
                return 5;
            }
            if (n > rectangle.width - insets.right) {
                return 3;
            }
            return -1;
        }

        protected BorderListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
            this.finit$();
        }
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        protected BasicInternalFrameListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }
}

