/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu;
    static transient MouseInputListener mouseInputListener;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler(this);
    TopWindowListener topWindowListener = new TopWindowListener(this);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.popupMenu = (JPopupMenu)jComponent;
        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
    }

    public void installDefaults() {
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return false;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicPopupMenuUI this$0;
        private JLayeredPane layeredPane;
        private Container glassPane;
        private Cursor nativeCursor;
        private transient Component mouseEventTarget;
        private transient Component pressedComponent;
        private transient Component lastComponentEntered;
        private transient Component tempComponent;
        private transient int pressCount;

        public MouseInputHandler(BasicPopupMenuUI basicPopupMenuUI, RootPaneContainer rootPaneContainer) {
            this.this$0 = basicPopupMenuUI;
            this.layeredPane = rootPaneContainer.getLayeredPane();
            this.glassPane = (Container)rootPaneContainer.getGlassPane();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void acquireComponentForMouseEvent(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2;
            Point point;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Container container = this.layeredPane;
            Component component = null;
            Point point2 = mouseEvent.getPoint();
            while (component == null && container != null) {
                point2 = SwingUtilities.convertPoint(this.glassPane, point2.x, point2.y, container);
                component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
                if (component != null) continue;
                point2 = SwingUtilities.convertPoint(container, point2.x, point2.y, container.getParent());
                container = container.getParent();
            }
            if (component == this.layeredPane) {
                component = null;
            }
            if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != component) {
                if (SwingUtilities.isDescendingFrom(this.lastComponentEntered, this.layeredPane)) {
                    point = SwingUtilities.convertPoint(this.layeredPane, n, n2, this.lastComponentEntered);
                    mouseEvent2 = new MouseEvent(this.lastComponentEntered, 505, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    this.tempComponent = this.lastComponentEntered;
                    this.lastComponentEntered = null;
                    this.tempComponent.dispatchEvent(mouseEvent2);
                }
                this.lastComponentEntered = null;
            }
            if (component != null) {
                this.mouseEventTarget = component;
                if (component.isLightweight() && component.isShowing() && component != this.layeredPane && component != this.lastComponentEntered) {
                    this.lastComponentEntered = this.mouseEventTarget;
                    point = SwingUtilities.convertPoint(this.layeredPane, n, n2, this.lastComponentEntered);
                    mouseEvent2 = new MouseEvent(this.lastComponentEntered, 504, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    this.lastComponentEntered.dispatchEvent(mouseEvent2);
                }
            }
            if (mouseEvent.getID() == 502 || mouseEvent.getID() == 501 && this.pressCount > 0 || mouseEvent.getID() == 506) {
                if (SwingUtilities.isDescendingFrom(this.pressedComponent, this.layeredPane)) {
                    this.mouseEventTarget = this.pressedComponent;
                } else if (mouseEvent.getID() == 500) {
                    if (component != this.pressedComponent) {
                        this.mouseEventTarget = null;
                    } else if (this.pressCount == 0) {
                        this.pressedComponent = null;
                    }
                }
            }
        }

        public void handleEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.acquireComponentForMouseEvent(mouseEvent);
                if (this.mouseEventTarget != null && this.mouseEventTarget.isShowing() && aWTEvent.getID() != 504 && aWTEvent.getID() != 505) {
                    MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.glassPane, mouseEvent, this.mouseEventTarget);
                    this.mouseEventTarget.dispatchEvent(mouseEvent2);
                    if (aWTEvent.getID() == 502) {
                        boolean bl = false;
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        bl = menuSelectionManager.isComponentPartOfCurrentMenu(this.mouseEventTarget);
                        if (!bl) {
                            menuSelectionManager.clearSelectedPath();
                        }
                    }
                    switch (aWTEvent.getID()) {
                        case 501: {
                            if (this.pressCount++ != 0) break;
                            this.pressedComponent = this.mouseEventTarget;
                            break;
                        }
                        case 502: {
                            if (--this.pressCount != 0 || this.mouseEventTarget == this.pressedComponent) break;
                            this.pressedComponent = null;
                        }
                    }
                }
            }
        }
    }

    private class TopWindowListener
    implements ComponentListener {
        private /* synthetic */ BasicPopupMenuUI this$0;

        public void componentResized(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        TopWindowListener(BasicPopupMenuUI basicPopupMenuUI) {
            this.this$0 = basicPopupMenuUI;
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private /* synthetic */ BasicPopupMenuUI this$0;

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Component component = this.this$0.popupMenu.getInvoker();
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getRoot(component));
            if (rootPaneContainer != null) {
                boolean bl;
                ((Container)((Object)rootPaneContainer)).removeComponentListener(this.this$0.topWindowListener);
                boolean bl2 = bl = this.this$0.popupMenu.getInvoker() instanceof JMenu && ((JMenu)this.this$0.popupMenu.getInvoker()).isTopLevelMenu();
                if (bl || !(this.this$0.popupMenu.getInvoker() instanceof MenuElement)) {
                    Container container = (Container)rootPaneContainer.getGlassPane();
                    container.setVisible(false);
                    container.removeMouseListener(mouseInputListener);
                    mouseInputListener = null;
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Object object;
            Component component = this.this$0.popupMenu.getInvoker();
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getRoot(component));
            ((Container)((Object)rootPaneContainer)).addComponentListener(this.this$0.topWindowListener);
            if (mouseInputListener == null) {
                object = (Container)rootPaneContainer.getGlassPane();
                ((Component)object).setVisible(true);
                mouseInputListener = new MouseInputHandler(this.this$0, rootPaneContainer);
                ((Component)object).addMouseListener(mouseInputListener);
                ((Component)object).addMouseMotionListener(mouseInputListener);
            }
            if (((MenuSelectionManager)(object = MenuSelectionManager.defaultManager())).getSelectedPath().length == 0) {
                MenuElement[] menuElementArray = new MenuElement[2];
                menuElementArray[0] = this.this$0.popupMenu;
                Component[] componentArray = this.this$0.popupMenu.getComponents();
                if (componentArray.length != 0 && componentArray[0] instanceof MenuElement) {
                    menuElementArray[1] = (MenuElement)((Object)componentArray[0]);
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray);
                }
            }
        }

        PopupMenuHandler(BasicPopupMenuUI basicPopupMenuUI) {
            this.this$0 = basicPopupMenuUI;
        }
    }
}

