/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private PropertyChangeListener listener;

    private /* synthetic */ void finit$() {
        this.listener = this.createPropertyChangeListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSpinnerUI();
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected LayoutManager createLayout() {
        return new DefaultLayoutManager(this);
    }

    protected Component createNextButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(1);
        return basicArrowButton;
    }

    protected Component createPreviousButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5);
        return basicArrowButton;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(this){
            private /* synthetic */ BasicSpinnerUI this$0;
            {
                this.this$0 = basicSpinnerUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editor".equals(propertyChangeEvent.getPropertyName())) {
                    this.this$0.replaceEditor((JComponent)propertyChangeEvent.getOldValue(), (JComponent)propertyChangeEvent.getNewValue());
                }
            }
        };
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        this.spinner.setLayout(this.createLayout());
        this.spinner.setOpaque(true);
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(this.listener);
    }

    protected void installNextButtonListeners(Component component) {
        component.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ BasicSpinnerUI this$0;
            volatile boolean mouseDown;
            Timer timer;
            {
                this.this$0 = basicSpinnerUI;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.mouseDown = false;
                this.timer = new Timer(50, new ActionListener(this){
                    private /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.increment();
                    }
                });
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!this.this$0.spinner.isEnabled()) {
                    return;
                }
                this.increment();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.timer.stop();
            }

            void increment() {
                Object object = this.this$0.spinner.getNextValue();
                if (object != null) {
                    this.this$0.spinner.getModel().setValue(object);
                }
            }
        });
    }

    protected void installPreviousButtonListeners(Component component) {
        component.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ BasicSpinnerUI this$0;
            volatile boolean mouseDown;
            Timer timer;
            {
                this.this$0 = basicSpinnerUI;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.mouseDown = false;
                this.timer = new Timer(50, new ActionListener(this){
                    private /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.decrement();
                    }
                });
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!this.this$0.spinner.isEnabled()) {
                    return;
                }
                this.decrement();
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.timer.stop();
            }

            void decrement() {
                Object object = this.this$0.spinner.getPreviousValue();
                if (object != null) {
                    this.this$0.spinner.getModel().setValue(object);
                }
            }
        });
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        Component component = this.createNextButton();
        Component component2 = this.createPreviousButton();
        this.installNextButtonListeners(component);
        this.installPreviousButtonListeners(component2);
        jComponent.add((Component)this.createEditor(), "Editor");
        jComponent.add(component, "Next");
        jComponent.add(component2, "Previous");
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add(jComponent2);
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.listener);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults();
        this.uninstallListeners();
        jComponent.removeAll();
    }

    public BasicSpinnerUI() {
        this.finit$();
    }

    private class DefaultLayoutManager
    implements LayoutManager {
        private /* synthetic */ BasicSpinnerUI this$0;
        private Component editor;
        private Component next;
        private Component previous;

        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets;
                block4: {
                    try {
                        insets = container.getInsets();
                        boolean bl = container.getComponentOrientation().isLeftToRight();
                        Dimension dimension = this.minSize(this.editor);
                        Dimension dimension2 = this.minSize(this.next);
                        Dimension dimension3 = this.minSize(this.previous);
                        Dimension dimension4 = this.this$0.spinner.getPreferredSize();
                        int n = bl ? insets.left : insets.right;
                        int n2 = insets.top;
                        int n3 = Math.max(dimension3.width, dimension2.width);
                        int n4 = Math.max(dimension3.height, dimension2.height);
                        n4 = Math.max(n4, dimension.height / 2);
                        int n5 = dimension4.width - n3;
                        if (bl) {
                            this.setBounds(this.editor, n, n2 + (dimension4.height - dimension.height) / 2, n5, dimension.height);
                            this.setBounds(this.next, n += n5, n2, n3, n4);
                            this.setBounds(this.previous, n, n2 += n4, n3, n4);
                            break block4;
                        }
                        this.setBounds(this.next, n, n2 + (dimension4.height - dimension.height) / 2, n3, n4);
                        this.setBounds(this.previous, n, n2 += n4, n3, n4);
                        this.setBounds(this.editor, n += n3, n2 -= n4, n5, dimension.height);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        throw throwable;
                    }
                }
                insets = null;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            Dimension dimension2 = new Dimension();
            if (this.editor != null) {
                Dimension dimension3 = this.editor.getMinimumSize();
                dimension2.width += dimension3.width;
                dimension2.height = dimension3.height;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.next != null) {
                dimension = this.next.getMinimumSize();
                n = dimension.width;
                n3 += dimension.height;
            }
            if (this.previous != null) {
                dimension = this.previous.getMinimumSize();
                n2 = dimension.width;
                n3 += dimension.height;
            }
            dimension2.height = Math.max(dimension2.height, n3);
            dimension2.width += Math.max(n, n2);
            return dimension2;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Dimension dimension2 = new Dimension();
            if (this.editor != null) {
                Dimension dimension3 = this.editor.getPreferredSize();
                dimension2.width += Math.max(dimension3.width, 40);
                dimension2.height = dimension3.height;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.next != null) {
                dimension = this.next.getPreferredSize();
                n = dimension.width;
                n3 += dimension.height;
            }
            if (this.previous != null) {
                dimension = this.previous.getPreferredSize();
                n2 = dimension.width;
                n3 += dimension.height;
            }
            dimension2.height = Math.max(dimension2.height, n3);
            dimension2.width += Math.max(n, n2);
            return dimension2;
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.editor) {
                this.editor = null;
            } else if (component == this.next) {
                this.next = null;
            } else if (this.previous == component) {
                this.previous = null;
            }
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Editor".equals(string)) {
                this.editor = component;
            } else if ("Next".equals(string)) {
                this.next = component;
            } else if ("Previous".equals(string)) {
                this.previous = component;
            }
        }

        private Dimension minSize(Component component) {
            if (component == null) {
                return new Dimension();
            }
            return component.getMinimumSize();
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        DefaultLayoutManager(BasicSpinnerUI basicSpinnerUI) {
            this.this$0 = basicSpinnerUI;
        }
    }
}

