/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    transient ScrollingButton incrButton;
    transient ScrollingButton decrButton;
    transient ScrollingViewport viewport;
    transient ScrollingPanel panel;
    transient int currentScrollLocation;
    protected Rectangle calcRect;
    protected Rectangle[] rects;
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    transient LayoutManager layoutManager;
    transient Rectangle tabAreaRect;
    transient Rectangle contentRect;

    ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(this, 1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(this, 5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    Point findPointForIndex(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(n2);
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1 || n2 == 3) {
            if (n > 0) {
                n4 += this.rects[n - 1].x + this.rects[n - 1].width;
                if (n > n3) {
                    n4 -= insets.left + insets.right;
                }
            }
        } else if (n > 0) {
            n5 += this.rects[n - 1].y + this.rects[n - 1].height;
            if (n > n3) {
                n5 -= insets.top + insets.bottom;
            }
        }
        Point point = new Point(n4, n5);
        return point;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)jComponent;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
            this.tabPane.layout();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout(this);
        }
        this.incrButton = this.createIncreaseButton();
        this.decrButton = this.createDecreaseButton();
        this.viewport = new ScrollingViewport(this);
        this.viewport.setLayout(null);
        this.panel = new ScrollingPanel(this);
        this.viewport.setView(this.panel);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        this.currentScrollLocation = 0;
        this.decrButton.setEnabled(false);
        this.panel.addMouseListener(this.mouseListener);
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton.addMouseListener(this.mouseListener);
        this.viewport.setBackground(Color.LIGHT_GRAY);
        return new TabbedPaneScrollLayout(this);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabPane.setOpaque(false);
        this.highlight = UIManager.getColor("TabbedPane.highlight");
        this.lightHighlight = UIManager.getColor("TabbedPane.lightHighlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.tabbedPaneContentBorderInsets");
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.tabPane.setBackground(null);
        this.tabPane.setForeground(null);
        this.tabPane.setFont(null);
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            this.paintTabArea(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        }
        this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        boolean bl = this.tabPane.getTabLayoutPolicy() == 1;
        int n3 = this.tabPane.getTabCount();
        int n4 = 1;
        if (n3 > this.runCount) {
            this.runCount = n3;
        }
        if (n3 < 1) {
            return;
        }
        if (this.runCount > 1) {
            n4 = 0;
        }
        for (int i = 0; i < this.runCount; ++i) {
            int n5;
            int n6 = this.lastTabInRun(n3, this.getPreviousTabRun(n4)) + 1;
            if (bl) {
                n6 = this.currentScrollLocation;
            } else if (n6 == n3) {
                n6 = 0;
            }
            int n7 = this.lastTabInRun(n3, n4);
            if (bl) {
                for (n5 = n6; n5 < n3; ++n5) {
                    if (this.rects[n5].x + this.rects[n5].width - this.rects[n6].x <= this.viewport.getWidth()) continue;
                    n7 = n5;
                    break;
                }
            }
            for (n5 = n6; n5 <= n7; ++n5) {
                if (n5 == n2 && !bl) continue;
                this.paintTab(graphics, n, this.rects, n5, rectangle, rectangle2);
            }
            n4 = this.getPreviousTabRun(n4);
        }
        if (!bl) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        Icon icon = this.getIconForTab(n2);
        String string = this.tabPane.getTitleAt(n2);
        boolean bl = n2 == this.tabPane.getSelectedIndex();
        this.calcRect = this.getTabBounds(this.tabPane, n2);
        int n3 = this.calcRect.x;
        int n4 = this.calcRect.y;
        int n5 = this.calcRect.width;
        int n6 = this.calcRect.height;
        if (this.getRunForTab(this.tabPane.getTabCount(), n2) == 1) {
            Insets insets = this.getTabAreaInsets(n);
            switch (n) {
                case 1: {
                    n6 += insets.bottom;
                    break;
                }
                case 2: {
                    n5 += insets.right;
                    break;
                }
                case 3: {
                    n4 -= insets.top;
                    n6 += insets.top;
                    break;
                }
                case 4: {
                    n3 -= insets.left;
                    n5 += insets.left;
                }
            }
        }
        this.layoutLabel(n, fontMetrics, n2, string, icon, this.calcRect, rectangle, rectangle2, bl);
        this.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
        this.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        if (icon != null) {
            this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
        if (string != null && !string.equals("")) {
            this.paintText(graphics, n, this.tabPane.getFont(), fontMetrics, n2, string, rectangle2, bl);
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, 0, 0, 0, 4, rectangle, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        Color color;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
            return;
        }
        Color color2 = this.tabPane.getForegroundAt(n2);
        if (color2 == null) {
            color2 = this.tabPane.getForeground();
        }
        if ((color = this.tabPane.getBackgroundAt(n2)) == null) {
            color = this.tabPane.getBackground();
        }
        Color color3 = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        if (this.tabPane.isEnabledAt(n2)) {
            graphics.setColor(color2);
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (n3 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        } else {
            graphics.setColor(color.brighter());
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (n4 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y);
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y);
            }
            graphics.setColor(color.darker());
            if (n4 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x + 1, rectangle.y + 1);
            } else {
                graphics.drawString(string, rectangle.x + 1, rectangle.y + 1);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font2);
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Color color = graphics.getColor();
        this.calcRect = rectangle.union(rectangle2);
        graphics.setColor(this.focus);
        graphics.drawRect(this.calcRect.x, this.calcRect.y, this.calcRect.width, this.calcRect.height);
        graphics.setColor(color);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        if (!bl || n != 1) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
        }
        if (!bl || n != 2) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
        }
        if (!bl || n != 4) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(n3, n4, n3, n4 + n6);
        }
        if (!bl || n != 3) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(n3, n4, n3 + n5, n4);
        }
        graphics.setColor(color);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(Color.LIGHT_GRAY);
        } else {
            Color color2 = this.tabPane.getBackgroundAt(n2);
            if (color2 == null) {
                color2 = Color.GRAY;
            }
            graphics.setColor(color2);
        }
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(color);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        Insets insets = this.getContentBorderInsets(n);
        int n3 = this.contentRect.x;
        int n4 = this.contentRect.y;
        int n5 = this.contentRect.width;
        int n6 = this.contentRect.height;
        this.paintContentBorderTopEdge(graphics, n, n2, n3, n4, n5, n6);
        this.paintContentBorderLeftEdge(graphics, n, n2, n3, n4, n5, n6);
        this.paintContentBorderBottomEdge(graphics, n, n2, n3, n4, n5, n6);
        this.paintContentBorderRightEdge(graphics, n, n2, n3, n4, n5, n6);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].x;
        int n8 = this.rects[n2].x + this.rects[n2].width;
        int n9 = 0;
        if (n == 1) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.x;
            }
            graphics.drawLine(n3, n4, n7 - n9, n4);
            graphics.drawLine(n8 - n9, n4, n3 + n5, n4);
        } else {
            graphics.drawLine(n3, n4, n3 + n5, n4);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].y;
        int n8 = this.rects[n2].y + this.rects[n2].height;
        int n9 = 0;
        if (n == 2) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.y;
            }
            graphics.drawLine(n3, n4, n3, n7 - n9);
            graphics.drawLine(n3, n8 - n9, n3, n4 + n6);
        } else {
            graphics.drawLine(n3, n4, n3, n4 + n6);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].x;
        int n8 = this.rects[n2].x + this.rects[n2].width;
        int n9 = 0;
        if (n == 3) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.x;
            }
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n7 - n9, n4 + n6 - 1);
            graphics.drawLine(n8 - n9, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n7 - n9, n4 + n6);
            graphics.drawLine(n8 - n9, n4 + n6, n3 + n5, n4 + n6);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].y;
        int n8 = this.rects[n2].y + this.rects[n2].height;
        int n9 = 0;
        if (n == 4) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.y;
            }
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n7 - n9);
            graphics.drawLine(n3 + n5 - 1, n8 - n9, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n7 - n9);
            graphics.drawLine(n3 + n5, n8 - n9, n3 + n5, n4 + n6);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
        }
        graphics.setColor(color);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        return this.rects[n];
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = this.tabPane.getTabCount();
        int n4 = 1;
        for (int i = 0; i < this.runCount; ++i) {
            int n5 = this.lastTabInRun(n3, this.getPreviousTabRun(n4)) + 1;
            if (n5 == n3) {
                n5 = 0;
            }
            int n6 = this.lastTabInRun(n3, n4);
            for (int j = n5; j <= n6; ++j) {
                if (!this.getTabBounds(jTabbedPane, j).contains(point)) continue;
                return j;
            }
            n4 = this.getNextTabRun(n4);
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.setBounds(this.getTabBounds(this.tabPane, n));
        return rectangle;
    }

    protected Component getVisibleComponent() {
        return this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
    }

    protected void setVisibleComponent(Component component) {
        component.setVisible(true);
        this.tabPane.setSelectedComponent(component);
    }

    protected void assureRectsCreated(int n) {
        if (this.rects == null) {
            this.rects = new Rectangle[n];
        }
        if (n == this.rects.length) {
            return;
        }
        int n2 = Math.min(n, this.rects.length);
        Rectangle[] rectangleArray = new Rectangle[n];
        System.arraycopy(this.rects, 0, rectangleArray, 0, n2);
        this.rects = rectangleArray;
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] nArray = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, nArray, 0, this.tabRuns.length);
            this.tabRuns = nArray;
        }
    }

    protected int getRunForTab(int n, int n2) {
        if (this.runCount == 1 && n2 < n && n2 >= 0) {
            return 1;
        }
        for (int i = 0; i < this.runCount; ++i) {
            int n3;
            int n4 = this.lastTabInRun(n, this.getPreviousTabRun(i)) + 1;
            if (n4 == n) {
                n4 = 0;
            }
            if ((n3 = this.lastTabInRun(n, i)) < n2 || n4 > n2) continue;
            return i;
        }
        return -1;
    }

    protected int lastTabInRun(int n, int n2) {
        if (this.tabRuns[n2] == 0) {
            return n - 1;
        }
        return this.tabRuns[n2] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        if (this.tabPane.isEnabledAt(n)) {
            return this.tabPane.getIconAt(n);
        }
        return this.tabPane.getDisabledIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n4 = 0;
        if (icon != null) {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            this.layoutLabel(n, this.getFontMetrics(), n2, this.tabPane.getTitleAt(n2), icon, rectangle, rectangle2, rectangle3, n2 == this.tabPane.getSelectedIndex());
            n4 = rectangle3.union((Rectangle)rectangle2).height;
        } else {
            n4 = n3;
        }
        return n4 += insets.top + insets.bottom;
    }

    protected int calculateMaxTabHeight(int n) {
        this.maxTabHeight = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(n, i, n2), this.maxTabHeight);
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = 0;
        if (icon != null) {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            this.layoutLabel(n, this.getFontMetrics(), n2, this.tabPane.getTitleAt(n2), icon, rectangle, rectangle2, rectangle3, n2 == this.tabPane.getSelectedIndex());
            n3 = rectangle3.union((Rectangle)rectangle2).width;
        } else {
            n3 = fontMetrics.stringWidth(this.tabPane.getTitleAt(n2));
        }
        return n3 += insets.left + insets.right;
    }

    protected int calculateMaxTabWidth(int n) {
        this.maxTabWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(n, i, fontMetrics), this.maxTabWidth);
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.left + insets.right;
    }

    protected Insets getTabInsets(int n, int n2) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabInsets, insets, n);
        return insets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, insets, n);
        return insets;
    }

    protected Insets getTabAreaInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, insets, n);
        return insets;
    }

    protected Insets getContentBorderInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, insets, n);
        return insets;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.tabPane.getToolkit().getFontMetrics(this.tabPane.getFont());
        return fontMetrics;
    }

    protected void navigateSelectedTab(int n) {
        int n2;
        int n3 = this.tabPane.getTabPlacement();
        if (n3 == 1 || n3 == 3) {
            if (n == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                n2 = this.getTabRunOffset(n3, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), n3 == 4);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
        if (n3 == 2 || n3 == 4) {
            if (n == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                n2 = this.getTabRunOffset(n3, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), n3 == 4);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        this.tabPane.setSelectedIndex(this.getNextTabIndexInRun(this.tabPane.getTabCount(), n));
    }

    protected void selectPreviousTabInRun(int n) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), n));
    }

    protected void selectNextTab(int n) {
        this.tabPane.setSelectedIndex(this.getNextTabIndex(n));
    }

    protected void selectPreviousTab(int n) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndex(n));
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4 = this.rects[n2].x + this.rects[n2].width / 2;
        int n5 = this.rects[n2].y + this.rects[n2].height / 2;
        switch (n) {
            case 1: 
            case 3: {
                n5 += n3;
                break;
            }
            case 2: 
            case 4: {
                n4 += n3;
            }
        }
        int n6 = this.tabForCoordinate(this.tabPane, n4, n5);
        if (n6 != -1) {
            this.tabPane.setSelectedIndex(n6);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4 = this.getRunForTab(n2, n3);
        int n5 = bl ? this.getNextTabRun(n4) : this.getPreviousTabRun(n4);
        int n6 = n == 1 || n == 3 ? this.rects[this.lastTabInRun((int)n2, (int)n5)].y - this.rects[this.lastTabInRun((int)n2, (int)n4)].y : this.rects[this.lastTabInRun((int)n2, (int)n5)].x - this.rects[this.lastTabInRun((int)n2, (int)n4)].x;
        return n6;
    }

    protected int getPreviousTabIndex(int n) {
        if (--n < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return n;
    }

    protected int getNextTabIndex(int n) {
        if (++n == this.tabPane.getTabCount()) {
            return 0;
        }
        return n;
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        int n3;
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.lastTabInRun(n, n3 = this.getRunForTab(n, n2)) + 1) {
            n4 = this.lastTabInRun(n, this.getPreviousTabRun(n3)) + 1;
        }
        return this.getNextTabIndex(n2);
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        int n3;
        int n4 = this.getPreviousTabIndex(n2);
        if (n4 == this.lastTabInRun(n, this.getPreviousTabRun(n3 = this.getRunForTab(n, n2)))) {
            n4 = this.lastTabInRun(n, n3);
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = --n) < 0) {
            n2 = this.getTabRunCount(this.tabPane) - 1;
        }
        return n2;
    }

    protected int getNextTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = ++n) == this.getTabRunCount(this.tabPane)) {
            n2 = 0;
        }
        return n2;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 1: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                insets2.bottom = insets.bottom;
                break;
            }
            case 2: {
                insets2.left = insets.top;
                insets2.top = insets.left;
                insets2.right = insets.bottom;
                insets2.bottom = insets.right;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.bottom = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
            }
        }
    }

    private class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public ScrollingButton(BasicTabbedPaneUI basicTabbedPaneUI, int n) {
            this.this$0 = basicTabbedPaneUI;
            super(n);
        }
    }

    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        ScrollingViewport(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private class ScrollingPanel
    extends JPanel {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        static /* synthetic */ BasicTabbedPaneUI access$1(ScrollingPanel scrollingPanel, BasicTabbedPaneUI basicTabbedPaneUI) {
            scrollingPanel.this$0 = basicTabbedPaneUI;
            return scrollingPanel.this$0;
        }

        static BasicTabbedPaneUI access$0(ScrollingPanel scrollingPanel) {
            return scrollingPanel.this$0;
        }

        public void updateUI() {
            this.setUI(new ScrollingPanelUI(this));
        }

        ScrollingPanel(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }

        private class ScrollingPanelUI
        extends BasicPanelUI {
            private /* synthetic */ ScrollingPanel this$1;

            public void paint(Graphics graphics, JComponent jComponent) {
                this.this$1.this$0.paintTabArea(graphics, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getTabPlacement(), ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getSelectedIndex());
            }

            ScrollingPanelUI(ScrollingPanel scrollingPanel) {
                this.this$1 = scrollingPanel;
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.selectedRun = this.this$0.getRunForTab(this.this$0.tabPane.getTabCount(), this.this$0.tabPane.getSelectedIndex());
            this.this$0.tabPane.revalidate();
            this.this$0.tabPane.repaint();
        }

        public TabSelectionHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public Dimension preferredLayoutSize(Container container) {
            return super.calculateSize(true);
        }

        public Dimension minimumLayoutSize(Container container) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = this.this$0.calculateMaxTabHeight(n);
            int n5 = this.this$0.calculateTabAreaHeight(n, n3, n4);
            return n5;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = this.this$0.calculateMaxTabWidth(n);
            int n5 = this.this$0.calculateTabAreaWidth(n, n3, n4);
            return n5;
        }

        protected void calculateTabRects(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            this.this$0.assureRectsCreated(n2);
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            SwingUtilities.calculateInnerArea(this.this$0.tabPane, this.this$0.calcRect);
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            int n3 = 0;
            int n4 = 1;
            int n5 = 0;
            int n6 = 0;
            if (n == 1 || n == 3) {
                int n7 = this.this$0.calculateMaxTabHeight(n);
                this.this$0.calcRect.width -= insets.left + insets.right;
                n3 = this.this$0.calcRect.width + insets.left + insets2.left;
                n5 = insets.left + insets2.left;
                int n8 = 0;
                int n9 = n5;
                n6 = insets2.top + insets.top;
                for (int i = 0; i < n2; ++i) {
                    n8 = this.this$0.calculateTabWidth(n, i, fontMetrics);
                    this.this$0.rects[i] = new Rectangle(n9, n6, n8, n7);
                    n9 += n8;
                }
                this.this$0.tabAreaRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right;
                this.this$0.tabAreaRect.height = n4 * this.this$0.maxTabHeight - (n4 - 1) * this.this$0.tabRunOverlay + insets.top + insets.bottom;
                this.this$0.contentRect.width = this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom - this.this$0.tabAreaRect.height;
                this.this$0.contentRect.x = insets2.left;
                this.this$0.tabAreaRect.x = insets2.left;
                if (n == 3) {
                    this.this$0.contentRect.y = insets2.top;
                    this.this$0.tabAreaRect.y = this.this$0.contentRect.y + this.this$0.contentRect.height;
                } else {
                    this.this$0.tabAreaRect.y = insets2.top;
                    this.this$0.contentRect.y = this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height;
                }
            } else {
                int n10 = this.this$0.calculateMaxTabWidth(n);
                this.this$0.calcRect.height -= insets.top + insets.bottom;
                n3 = this.this$0.calcRect.height + insets.top;
                int n11 = 0;
                int n12 = n5 = insets.top + insets2.top;
                int n13 = fontMetrics.getHeight();
                n6 = insets2.left + insets.left;
                for (int i = 0; i < n2; ++i) {
                    n11 = this.this$0.calculateTabHeight(n, i, n13);
                    this.this$0.rects[i] = new Rectangle(n6, n12, n10, n11);
                    n12 += n11;
                }
                this.this$0.tabAreaRect.width = n4 * this.this$0.maxTabWidth - (n4 - 1) * this.this$0.tabRunOverlay + insets.left + insets.right;
                this.this$0.tabAreaRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom;
                this.this$0.tabAreaRect.y = insets2.top;
                this.this$0.contentRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right - this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabAreaRect.height;
                this.this$0.contentRect.y = insets2.top;
                if (n == 2) {
                    this.this$0.tabAreaRect.x = insets2.left;
                    this.this$0.contentRect.x = this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width;
                } else {
                    this.this$0.contentRect.x = insets2.left;
                    this.this$0.tabAreaRect.x = this.this$0.contentRect.x + this.this$0.contentRect.width;
                }
            }
            this.this$0.runCount = n4;
            this.padSelectedTab(n, this.this$0.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            super.layoutContainer(container);
            int n = this.this$0.tabPane.getTabCount();
            Point point = null;
            if (n == 0) {
                return;
            }
            int n2 = this.this$0.tabPane.getTabPlacement();
            this.this$0.incrButton.hide();
            this.this$0.decrButton.hide();
            if ((n2 == 1 || n2 == 3) && this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width < this.this$0.rects[n - 1].x + this.this$0.rects[n - 1].width) {
                dimension2 = this.this$0.incrButton.getPreferredSize();
                dimension = this.this$0.decrButton.getPreferredSize();
                this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width - dimension.width, this.this$0.tabAreaRect.y, dimension.width, this.this$0.tabAreaRect.height);
                this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width, this.this$0.tabAreaRect.y, dimension.width, this.this$0.tabAreaRect.height);
                this.this$0.tabAreaRect.width -= dimension.width + dimension2.width;
                this.this$0.incrButton.show();
                this.this$0.decrButton.show();
            }
            if ((n2 == 2 || n2 == 4) && this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height < this.this$0.rects[n - 1].y + this.this$0.rects[n - 1].height) {
                dimension2 = this.this$0.incrButton.getPreferredSize();
                dimension = this.this$0.decrButton.getPreferredSize();
                this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height - dimension.height, this.this$0.tabAreaRect.width, dimension.height);
                this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height, this.this$0.tabAreaRect.width, dimension2.height);
                this.this$0.tabAreaRect.height -= dimension.height + dimension2.height;
                this.this$0.incrButton.show();
                this.this$0.decrButton.show();
            }
            this.this$0.viewport.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y, this.this$0.tabAreaRect.width, this.this$0.tabAreaRect.height);
            int n3 = this.this$0.tabPane.getTabCount() - 1;
            if (n > 0) {
                int n4 = Math.max(this.this$0.rects[n3].width + this.this$0.rects[n3].x, this.this$0.tabAreaRect.width);
                int n5 = Math.max(this.this$0.rects[n3].height, this.this$0.tabAreaRect.height);
                point = this.this$0.findPointForIndex(this.this$0.currentScrollLocation);
                this.this$0.panel.setSize(n4 + point.x, n5 + point.y);
            }
            this.this$0.viewport.setViewPosition(point);
            this.this$0.viewport.repaint();
        }

        TabbedPaneScrollLayout(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
            super(basicTabbedPaneUI);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void addLayoutComponent(String string, Component component) {
        }

        public void calculateLayoutInfo() {
            this.calculateTabRects(this.this$0.tabPane.getTabPlacement(), this.this$0.tabPane.getTabCount());
            if (this.this$0.tabPane.getSelectedIndex() != -1) {
                Component component = this.this$0.getVisibleComponent();
                Insets insets = this.this$0.getContentBorderInsets(this.this$0.tabPane.getTabPlacement());
                if (component != null) {
                    component.setBounds(this.this$0.contentRect.x + insets.left, this.this$0.contentRect.y + insets.top, this.this$0.contentRect.width - insets.left - insets.right, this.this$0.contentRect.height - insets.top - insets.bottom);
                }
            }
        }

        protected Dimension calculateSize(boolean bl) {
            int n = this.this$0.tabPane.getTabPlacement();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.this$0.tabPane.getTabCount(); ++i) {
                Component component = this.this$0.tabPane.getComponentAt(i);
                if (component == null) continue;
                this.this$0.calcRect = component.getBounds();
                Dimension dimension = component.getPreferredSize();
                if (dimension == null) continue;
                n4 = Math.max(n4, dimension.height);
                n5 = Math.max(n5, dimension.width);
            }
            Insets insets = this.this$0.tabPane.getInsets();
            if (n == 1 || n == 3) {
                int n6 = this.this$0.calculateMaxTabWidth(n);
                n2 = Math.max(n6, n5);
                int n7 = this.preferredTabAreaHeight(n, n2);
                n3 = n7 + n4;
            } else {
                int n8 = this.this$0.calculateMaxTabHeight(n);
                n3 = Math.max(n8, n4);
                int n9 = this.preferredTabAreaWidth(n, n3);
                n2 = n9 + n5;
            }
            return new Dimension(n2, n3);
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            if (n2 == 0) {
                return;
            }
            this.this$0.assureRectsCreated(n2);
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            SwingUtilities.calculateInnerArea(this.this$0.tabPane, this.this$0.calcRect);
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            int n8 = 0;
            int n9 = 0;
            int n10 = this.this$0.getTabRunIndent(n, 1);
            if (n == 1 || n == 3) {
                n7 = this.this$0.calculateMaxTabHeight(n);
                this.this$0.calcRect.width -= insets.left + insets.right;
                n8 = this.this$0.calcRect.width + insets.left + insets2.left;
                n6 = 0;
                n5 = n10 += insets.left + insets2.left;
                for (n4 = 0; n4 < n2; ++n4) {
                    n6 = this.this$0.calculateTabWidth(n, n4, fontMetrics);
                    if (n5 + n6 > n8) {
                        n5 = insets.left + insets2.left + this.this$0.getTabRunIndent(n, ++n9);
                        this.this$0.rects[n4] = new Rectangle(n5, insets2.top + insets.top, n6, n7);
                        n5 += n6;
                        if (n9 > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[n9] = n4;
                        continue;
                    }
                    this.this$0.rects[n4] = new Rectangle(n5, insets2.top + insets.top, n6, n7);
                    n5 += n6;
                }
                this.this$0.tabAreaRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right;
                this.this$0.tabAreaRect.height = ++n9 * this.this$0.maxTabHeight - (n9 - 1) * this.this$0.tabRunOverlay + insets.top + insets.bottom;
                this.this$0.contentRect.width = this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom - this.this$0.tabAreaRect.height;
                this.this$0.contentRect.x = insets2.left;
                this.this$0.tabAreaRect.x = insets2.left;
                if (n == 3) {
                    this.this$0.contentRect.y = insets2.top;
                    this.this$0.tabAreaRect.y = this.this$0.contentRect.y + this.this$0.contentRect.height;
                } else {
                    this.this$0.tabAreaRect.y = insets2.top;
                    this.this$0.contentRect.y = this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height;
                }
            } else {
                n7 = this.this$0.calculateMaxTabWidth(n);
                this.this$0.calcRect.height -= insets.top + insets.bottom;
                n8 = this.this$0.calcRect.height + insets.top + insets2.top;
                n6 = 0;
                n5 = n10 += insets.top + insets2.top;
                n4 = fontMetrics.getHeight();
                for (n3 = 0; n3 < n2; ++n3) {
                    n6 = this.this$0.calculateTabHeight(n, n3, n4);
                    if (n5 + n6 > n8) {
                        n5 = insets.top + insets2.top + this.this$0.getTabRunIndent(n, ++n9);
                        this.this$0.rects[n3] = new Rectangle(insets2.left + insets.left, n5, n7, n6);
                        n5 += n6;
                        if (n9 > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[n9] = n3;
                        continue;
                    }
                    this.this$0.rects[n3] = new Rectangle(insets2.left + insets.left, n5, n7, n6);
                    n5 += n6;
                }
                this.this$0.tabAreaRect.width = ++n9 * this.this$0.maxTabWidth - (n9 - 1) * this.this$0.tabRunOverlay + insets.left + insets.right;
                this.this$0.tabAreaRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom;
                this.this$0.tabAreaRect.y = insets2.top;
                this.this$0.contentRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right - this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabAreaRect.height;
                this.this$0.contentRect.y = insets2.top;
                if (n == 2) {
                    this.this$0.tabAreaRect.x = insets2.left;
                    this.this$0.contentRect.x = this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width;
                } else {
                    this.this$0.contentRect.x = insets2.left;
                    this.this$0.tabAreaRect.x = this.this$0.contentRect.x + this.this$0.contentRect.width;
                }
            }
            this.this$0.runCount = n9;
            this.this$0.tabRuns[0] = 0;
            this.normalizeTabRuns(n, n2, n10, n8);
            this.this$0.selectedRun = this.this$0.getRunForTab(n2, this.this$0.tabPane.getSelectedIndex());
            if (this.this$0.shouldRotateTabRuns(n)) {
                this.rotateTabRuns(n, this.this$0.selectedRun);
            }
            for (n7 = 0; n7 < this.this$0.runCount; ++n7) {
                int n11;
                n6 = this.this$0.lastTabInRun(n2, this.this$0.getPreviousTabRun(n7)) + 1;
                if (n6 == n2) {
                    n6 = 0;
                }
                n5 = this.this$0.lastTabInRun(n2, n7);
                if (this.this$0.shouldPadTabRun(n, n7)) {
                    this.padTabRun(n, n6, n5, n8);
                }
                if (n == 1 && n7 > 0) {
                    for (n4 = n6; n4 <= n5; ++n4) {
                        this.this$0.rects[n4].y += (this.this$0.runCount - n7) * this.this$0.maxTabHeight - (this.this$0.runCount - n7) * this.this$0.tabRunOverlay;
                    }
                }
                if (n == 3) {
                    n4 = this.this$0.tabPane.getBounds().height - insets2.bottom - insets.bottom;
                    n3 = n7 == 0 ? n4 - this.this$0.maxTabHeight : n4 - (this.this$0.runCount - n7 + 1) * this.this$0.maxTabHeight - (this.this$0.runCount - n7) * this.this$0.tabRunOverlay;
                    for (n11 = n6; n11 <= n5; ++n11) {
                        this.this$0.rects[n11].y = n3;
                    }
                }
                if (n == 2 && n7 > 0) {
                    for (n4 = n6; n4 <= n5; ++n4) {
                        this.this$0.rects[n4].x += (this.this$0.runCount - n7) * this.this$0.maxTabWidth - (this.this$0.runCount - n7) * this.this$0.tabRunOverlay;
                    }
                }
                if (n != 4) continue;
                n4 = this.this$0.tabPane.getBounds().width - insets2.right - insets.right;
                n3 = n7 == 0 ? n4 - this.this$0.maxTabWidth : n4 - (this.this$0.runCount - n7 + 1) * this.this$0.maxTabWidth + (this.this$0.runCount - n7) * this.this$0.tabRunOverlay;
                for (n11 = n6; n11 <= n5; ++n11) {
                    this.this$0.rects[n11].x = n3;
                }
            }
            this.padSelectedTab(n, this.this$0.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container container) {
            this.calculateLayoutInfo();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            Insets insets = this.this$0.getTabAreaInsets(n);
            if (n == 1 || n == 3) {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                    Rectangle rectangle2 = this.this$0.rects[this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i))];
                    int n5 = rectangle.x + rectangle.width;
                    int n6 = rectangle2.x + rectangle2.width;
                    int n7 = n5 - n6;
                    int n8 = n5 - rectangle.width - (n6 + rectangle.width);
                    while (Math.abs(n8) < Math.abs(n7) && n6 + rectangle.width < n4) {
                        int n9 = i;
                        this.this$0.tabRuns[n9] = this.this$0.tabRuns[n9] - 1;
                        rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                        n7 = (n5 -= rectangle.width) - (n6 += rectangle.width);
                        n8 = n5 - rectangle.width - (n6 + rectangle.width);
                    }
                    int n10 = this.this$0.lastTabInRun(n2, i) + 1;
                    int n11 = this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i));
                    int n12 = insets.left;
                    for (int j = n10; j <= n11; ++j) {
                        this.this$0.rects[j].x = n12;
                        n12 += this.this$0.rects[j].width;
                    }
                }
            } else {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                    Rectangle rectangle3 = this.this$0.rects[this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i))];
                    int n13 = rectangle.y + rectangle.height;
                    int n14 = rectangle3.y + rectangle3.height;
                    int n15 = n13 - n14;
                    int n16 = n13 - rectangle.height - (n14 + rectangle.height);
                    while (Math.abs(n16) < Math.abs(n15) && n14 + rectangle.height < n4) {
                        int n17 = i;
                        this.this$0.tabRuns[n17] = this.this$0.tabRuns[n17] - 1;
                        rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                        n15 = (n13 -= rectangle.height) - (n14 += rectangle.height);
                        n16 = n13 - rectangle.height - (n14 + rectangle.height);
                    }
                    int n18 = this.this$0.lastTabInRun(n2, i) + 1;
                    int n19 = this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i));
                    int n20 = insets.top;
                    for (int j = n18; j <= n19; ++j) {
                        this.this$0.rects[j].y = n20;
                        n20 += this.this$0.rects[j].height;
                    }
                }
            }
        }

        protected void padSelectedTab(int n, int n2) {
            Insets insets = this.this$0.getSelectedTabPadInsets(n);
            this.this$0.rects[n2].x -= insets.left;
            this.this$0.rects[n2].y -= insets.top;
            this.this$0.rects[n2].width += insets.left + insets.right;
            this.this$0.rects[n2].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                int n5 = this.this$0.rects[n3].x + this.this$0.rects[n3].width;
                int n6 = n4 - n5;
                int n7 = n3 - n2 + 1;
                int n8 = n6 / n7;
                int n9 = this.this$0.rects[n2].x;
                for (int i = n2; i <= n3; ++i) {
                    this.this$0.rects[i].x = n9;
                    this.this$0.rects[i].width += n8;
                    n9 += this.this$0.rects[i].width;
                    if (i != n3 || this.this$0.rects[i].x + this.this$0.rects[i].width == n4) continue;
                    this.this$0.rects[i].width = n4 - this.this$0.rects[i].x;
                }
            } else {
                int n10 = this.this$0.rects[n3].y + this.this$0.rects[n3].height;
                int n11 = n4 - n10;
                int n12 = n3 - n2 + 1;
                int n13 = n11 / n12;
                int n14 = this.this$0.rects[n2].y;
                for (int i = n2; i <= n3; ++i) {
                    this.this$0.rects[i].y = n14;
                    this.this$0.rects[i].height += n13;
                    n14 += this.this$0.rects[i].height;
                    if (i != n3 || this.this$0.rects[i].y + this.this$0.rects[i].height == n4) continue;
                    this.this$0.rects[i].height = n4 - this.this$0.rects[i].y;
                }
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            int n3;
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            n2 -= insets.left + insets.right + insets2.left + insets2.right;
            for (n3 = 0; n3 < this.this$0.tabPane.getTabCount(); ++n3) {
                n6 = this.this$0.calculateTabWidth(n, n3, fontMetrics);
                if (n5 + n6 > n2) {
                    n5 = n6;
                    ++n4;
                    continue;
                }
                n5 += n6;
            }
            n3 = this.this$0.calculateMaxTabHeight(n);
            int n7 = this.this$0.calculateTabAreaHeight(n, ++n4, n3);
            return n7;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            int n3;
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            n2 -= insets.top + insets.bottom + insets2.top + insets2.bottom;
            int n7 = fontMetrics.getHeight();
            for (n3 = 0; n3 < this.this$0.tabPane.getTabCount(); ++n3) {
                n6 = this.this$0.calculateTabHeight(n, n3, n7);
                if (n5 + n6 > n2) {
                    n5 = n6;
                    ++n4;
                    continue;
                }
                n5 += n6;
            }
            n3 = this.this$0.calculateMaxTabWidth(n);
            int n8 = this.this$0.calculateTabAreaWidth(n, ++n4, n3);
            return n8;
        }

        protected void rotateTabRuns(int n, int n2) {
            if (this.this$0.runCount == 1 || n2 == 1 || n2 == -1) {
                return;
            }
            int[] nArray = new int[this.this$0.tabRuns.length];
            int n3 = n2;
            int n4 = 1;
            do {
                nArray[n4] = this.this$0.tabRuns[n3];
                n3 = this.this$0.getNextTabRun(n3);
            } while (++n4 < this.this$0.runCount);
            if (this.this$0.runCount > 1) {
                nArray[0] = this.this$0.tabRuns[n3];
            }
            this.this$0.tabRuns = nArray;
            this.this$0.selectedRun = 1;
        }

        public void removeLayoutComponent(Component component) {
        }

        public TabbedPaneLayout(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("tabLayoutPolicy")) {
                this.this$0.layoutManager = this.this$0.createLayoutManager();
                this.this$0.tabPane.setLayout(this.this$0.layoutManager);
            } else if (propertyChangeEvent.getPropertyName().equals("tabPlacement") && this.this$0.tabPane.getTabLayoutPolicy() == 1) {
                this.this$0.incrButton = this.this$0.createIncreaseButton();
                this.this$0.decrButton = this.this$0.createDecreaseButton();
            }
            this.this$0.tabPane.layout();
            this.this$0.tabPane.repaint();
        }

        public PropertyChangeHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = this.this$0.tabPane.getTabCount();
            if (this.this$0.tabPane.getTabLayoutPolicy() == 1) {
                if (mouseEvent.getSource() == this.this$0.incrButton) {
                    if (++this.this$0.currentScrollLocation >= n4) {
                        this.this$0.currentScrollLocation = n4 - 1;
                    }
                    int n5 = 0;
                    for (int i = this.this$0.currentScrollLocation - 1; i < n4; ++i) {
                        n5 += this.this$0.rects[i].width;
                    }
                    if (n5 < this.this$0.viewport.getWidth()) {
                        --this.this$0.currentScrollLocation;
                    } else if (!this.this$0.decrButton.isEnabled()) {
                        this.this$0.decrButton.setEnabled(true);
                    }
                    this.this$0.tabPane.revalidate();
                    this.this$0.tabPane.repaint();
                    return;
                }
                if (mouseEvent.getSource() == this.this$0.decrButton) {
                    if (--this.this$0.currentScrollLocation < 0) {
                        this.this$0.currentScrollLocation = 0;
                    }
                    if (this.this$0.currentScrollLocation == 0) {
                        this.this$0.decrButton.setEnabled(false);
                    } else if (!this.this$0.incrButton.isEnabled()) {
                        this.this$0.incrButton.setEnabled(true);
                    }
                    this.this$0.tabPane.revalidate();
                    this.this$0.tabPane.repaint();
                    return;
                }
            }
            if ((n = this.this$0.tabForCoordinate(this.this$0.tabPane, n2, n3)) != -1 && this.this$0.tabPane.isEnabledAt(n)) {
                this.this$0.tabPane.setSelectedIndex(n);
            }
            this.this$0.tabPane.revalidate();
            this.this$0.tabPane.repaint();
        }

        public MouseHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public FocusHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }
}

