/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener();
    protected CellRendererPane rendererPane;
    protected Border cellBorder;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.cellBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.header.addMouseListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    protected void uninstallDefaults() {
        this.header.setBackground(null);
        this.header.setForeground(null);
        this.header.setFont(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle2 = this.header.getHeaderRect(i);
            if (!rectangle2.intersects(rectangle)) continue;
            Rectangle rectangle3 = graphics.getClipBounds();
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, i);
            component.setFont(this.header.getFont());
            component.setBackground(this.header.getBackground());
            component.setForeground(this.header.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(this.cellBorder);
            }
            graphics.translate(rectangle2.x, rectangle2.y);
            graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
            component.setSize(rectangle2.width, rectangle2.height);
            component.setLocation(0, 0);
            component.paint(graphics);
            graphics.translate(-rectangle2.x, -rectangle2.y);
            graphics.setClip(rectangle3);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        int n = tableColumnModel.getColumnCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        if (this.header.getTable() != null && this.header.getTable().getIntercellSpacing() != null) {
            n2 = this.header.getTable().getIntercellSpacing().width;
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, i);
            component.setFont(this.header.getFont());
            component.setBackground(this.header.getBackground());
            component.setForeground(this.header.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(this.cellBorder);
            }
            Dimension dimension2 = component.getPreferredSize();
            dimension.width += n2;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        dimension.width = tableColumnModel.getTotalColumnWidth();
        return dimension;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTableHeaderUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public MouseInputHandler(BasicTableHeaderUI basicTableHeaderUI) {
            this.this$0 = basicTableHeaderUI;
        }
    }
}

