/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;
    Border cellBorder;
    TableAction action;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        int n = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            n += this.table.getColumnModel().getColumn(i).getMaxWidth();
        }
        if (n == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(n, this.table.getRowCount() * this.table.getRowHeight());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        int n = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            n += this.table.getColumnModel().getColumn(i).getMinWidth();
        }
        if (n == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(n, this.table.getRowCount() * this.table.getRowHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = this.table.getColumnModel().getTotalColumnWidth();
        int n2 = this.table.getRowCount() * this.table.getRowHeight();
        return new Dimension(n, n2);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
        this.rendererPane = new CellRendererPane();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("Table.ancestorInputMap");
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        this.action = new TableAction(this);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            String string = (String)inputMap.get(keyStroke);
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers()), string);
            actionMapUIResource.put(string, new ActionListenerProxy(this.action, string));
        }
        inputMapUIResource.setParent(this.table.getInputMap(1).getParent());
        actionMapUIResource.setParent(this.table.getActionMap().getParent());
        this.table.getInputMap(1).setParent(inputMapUIResource);
        this.table.getActionMap().setParent(actionMapUIResource);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.table.addFocusListener(this.focusListener);
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        this.table.addKeyListener(this.keyListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeHandler(this);
        }
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    void paintCell(Graphics graphics, int n, int n2, Rectangle rectangle, TableCellRenderer tableCellRenderer, TableModel tableModel, int n3, int n4) {
        boolean bl = this.table.getRowSelectionAllowed();
        boolean bl2 = this.table.getColumnSelectionAllowed();
        boolean bl3 = false;
        bl3 = bl && bl2 || !bl && !bl2 ? this.table.isCellSelected(n, n2) : this.table.isRowSelected(n) && this.table.getRowSelectionAllowed() || this.table.isColumnSelected(n2) && this.table.getColumnSelectionAllowed();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.table.getColumnModel().getSelectionModel();
        boolean bl4 = this.table.hasFocus() && this.table.isEnabled() && listSelectionModel.getLeadSelectionIndex() == n && listSelectionModel2.getLeadSelectionIndex() == n2;
        Component component = tableCellRenderer.getTableCellRendererComponent(this.table, tableModel.getValueAt(n, n2), bl3, bl4, n, n2);
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle);
        if (component instanceof JTextField) {
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.translate(rectangle.x, rectangle.y);
            graphics.clipRect(0, 0, rectangle.width, rectangle.height);
            ((JTextField)component).getCaret().paint(graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
            graphics.setClip(rectangle2);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Serializable serializable;
        int n2;
        int n3 = this.table.getColumnCount();
        int n4 = this.table.getRowCount();
        if (n4 == 0 || n3 == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = this.table.getRowHeight();
        int n6 = 0;
        int n7 = 0;
        int n8 = n6;
        int n9 = n7;
        Dimension dimension = this.table.getIntercellSpacing();
        int n10 = rectangle.y + rectangle.height;
        int n11 = rectangle.x + rectangle.width;
        for (int i = 0; i < n3 && n8 < n11; n8 += n2, ++i) {
            n9 = n7;
            serializable = tableColumnModel.getColumn(i);
            n2 = serializable.getWidth();
            n = dimension.width / 2;
            int n12 = dimension.height / 2;
            for (int j = 0; j < n4 && n9 < n10; n9 += n5, ++j) {
                Rectangle rectangle2 = new Rectangle(n8 + n, n9 + n12 + 1, n2 - dimension.width + 1, n5 - dimension.height);
                if (!rectangle2.intersects(rectangle)) continue;
                this.paintCell(graphics, j, i, rectangle2, this.table.getCellRenderer(j, i), this.table.getModel(), this.table.getSelectionModel().getLeadSelectionIndex(), this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex());
            }
        }
        n10 = n9;
        n11 = n8;
        Color color = this.table.getGridColor();
        if (color != null && this.table.getShowVerticalLines()) {
            n8 = n6;
            serializable = graphics.getColor();
            graphics.setColor(color);
            n2 = 0;
            for (n = 0; n < n3 && n8 < n11; ++n) {
                graphics.drawLine(n8 += tableColumnModel.getColumn(n).getWidth(), n7, n8, n10);
                n2 = 1;
            }
            graphics.setColor((Color)serializable);
        }
        if (color != null && this.table.getShowHorizontalLines()) {
            n9 = n7;
            serializable = graphics.getColor();
            graphics.setColor(color);
            n2 = 0;
            for (n = 0; n < n4 && n9 < n10; ++n) {
                graphics.drawLine(n6, n9 += n5, n11, n9);
                n2 = 1;
            }
            graphics.setColor((Color)serializable);
        }
    }

    class TableAction
    extends AbstractAction {
        private /* synthetic */ BasicTableUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.this$0.table.getSelectionModel();
            DefaultListSelectionModel defaultListSelectionModel2 = (DefaultListSelectionModel)this.this$0.table.getColumnModel().getSelectionModel();
            int n = defaultListSelectionModel.getLeadSelectionIndex();
            int n2 = this.this$0.table.getModel().getRowCount() - 1;
            int n3 = defaultListSelectionModel2.getLeadSelectionIndex();
            int n4 = this.this$0.table.getModel().getColumnCount() - 1;
            String string = actionEvent.getActionCommand();
            if (string.equals("selectPreviousRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.max(n - 1, 0));
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectLastColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(n4, n4);
            } else if (string.equals("startEditing")) {
                if (this.this$0.table.isCellEditable(n, n3)) {
                    this.this$0.table.editCellAt(n, n3);
                }
            } else if (string.equals("selectFirstRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(0);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectFirstColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(0, 0);
            } else if (string.equals("selectFirstColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(0);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectLastRow")) {
                defaultListSelectionModel.setSelectionInterval(n2, n2);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.min(n + 1, n2));
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectFirstRow")) {
                defaultListSelectionModel.setSelectionInterval(0, 0);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.min(n3 + 1, n4));
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectLastColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(n4);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectPreviousColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.max(n3 - 1, 0));
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectNextRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollUpExtendSelection")) {
                int n5 = n == this.getFirstVisibleRowIndex() ? Math.max(0, n - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n5);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectPreviousRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.max(n - 1, 0));
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollRightChangeSelection")) {
                int n6 = n3 == this.getLastVisibleColumnIndex() ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                defaultListSelectionModel2.setSelectionInterval(n6, n6);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("selectPreviousColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
            } else if (string.equals("scrollLeftChangeSelection")) {
                int n7 = n3 == this.getFirstVisibleColumnIndex() ? Math.max(0, n3 - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                defaultListSelectionModel2.setSelectionInterval(n7, n7);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("clearSelection")) {
                this.this$0.table.clearSelection();
            } else if (string.equals("cancel")) {
                if (this.this$0.table.isEditing()) {
                    this.this$0.table.editingCanceled(new ChangeEvent("cancel"));
                }
            } else if (string.equals("selectNextRowCell") || string.equals("selectPreviousRowCell") || string.equals("selectNextColumnCell") || string.equals("selectPreviousColumnCell")) {
                int n8;
                boolean bl;
                if (this.this$0.table.getSelectedRowCount() == 0 && this.this$0.table.getSelectedColumnCount() == 0) {
                    defaultListSelectionModel.setSelectionInterval(0, 0);
                    defaultListSelectionModel2.setSelectionInterval(0, 0);
                    return;
                }
                if (!this.this$0.table.isCellSelected(n, n3)) {
                    defaultListSelectionModel.addSelectionInterval(defaultListSelectionModel.getMinSelectionIndex(), defaultListSelectionModel.getMinSelectionIndex());
                    defaultListSelectionModel2.addSelectionInterval(defaultListSelectionModel2.getMinSelectionIndex(), defaultListSelectionModel2.getMinSelectionIndex());
                    return;
                }
                boolean bl2 = this.this$0.table.getSelectedRowCount() > 1 && this.this$0.table.getRowSelectionAllowed();
                boolean bl3 = bl = this.this$0.table.getSelectedColumnCount() > 1 && this.this$0.table.getColumnSelectionAllowed();
                if (!bl && !bl2) {
                    if (string.indexOf("Column") != -1) {
                        this.advanceSingleSelection(defaultListSelectionModel2, n4, defaultListSelectionModel, n2, string.equals("selectPreviousColumnCell"));
                    } else {
                        this.advanceSingleSelection(defaultListSelectionModel, n2, defaultListSelectionModel2, n4, string.equals("selectPreviousRowCell"));
                    }
                    return;
                }
                int n9 = this.this$0.table.getRowSelectionAllowed() ? defaultListSelectionModel.getMaxSelectionIndex() : this.this$0.table.getModel().getRowCount() - 1;
                int n10 = this.this$0.table.getRowSelectionAllowed() ? defaultListSelectionModel.getMinSelectionIndex() : 0;
                int n11 = this.this$0.table.getColumnSelectionAllowed() ? defaultListSelectionModel2.getMaxSelectionIndex() : this.this$0.table.getModel().getColumnCount() - 1;
                int n12 = n8 = this.this$0.table.getColumnSelectionAllowed() ? defaultListSelectionModel2.getMinSelectionIndex() : 0;
                if (string.indexOf("Column") != -1) {
                    this.advanceMultipleSelection(defaultListSelectionModel2, n8, n11, defaultListSelectionModel, n10, n9, string.equals("selectPreviousColumnCell"), true);
                } else {
                    this.advanceMultipleSelection(defaultListSelectionModel, n10, n9, defaultListSelectionModel2, n8, n11, string.equals("selectPreviousRowCell"), false);
                }
            } else if (string.equals("selectNextColumn")) {
                defaultListSelectionModel.setSelectionInterval(n, n);
                defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
            } else if (string.equals("scrollLeftExtendSelection")) {
                int n13 = n3 == this.getFirstVisibleColumnIndex() ? Math.max(0, n3 - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                defaultListSelectionModel2.setLeadSelectionIndex(n13);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("scrollDownChangeSelection")) {
                int n14 = n == this.getLastVisibleRowIndex() ? Math.min(n2, n + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                defaultListSelectionModel.setSelectionInterval(n14, n14);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollRightExtendSelection")) {
                int n15 = n3 == this.getLastVisibleColumnIndex() ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                defaultListSelectionModel2.setLeadSelectionIndex(n15);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectAll")) {
                this.this$0.table.selectAll();
            } else if (string.equals("selectLastRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(n2);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollDownExtendSelection")) {
                int n16 = n == this.getLastVisibleRowIndex() ? Math.min(n2, n + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n16);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollUpChangeSelection")) {
                int n17 = n == this.getFirstVisibleRowIndex() ? Math.max(0, n - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                defaultListSelectionModel.setSelectionInterval(n17, n17);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.min(n + 1, n2));
                }
            } else if (string.equals("selectPreviousRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.min(n - 1, 0));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.max(n - 1, 0));
                }
            } else if (string.equals("selectNextColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.min(n3 + 1, n4));
                }
            } else if (string.equals("selectPreviousColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.max(n3 - 1, 0));
                }
            } else if (string.equals("addToSelection")) {
                if (!this.this$0.table.isEditing()) {
                    int n18 = defaultListSelectionModel.getAnchorSelectionIndex();
                    int n19 = defaultListSelectionModel2.getAnchorSelectionIndex();
                    defaultListSelectionModel.addSelectionInterval(n, n);
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                    defaultListSelectionModel.setAnchorSelectionIndex(n18);
                    defaultListSelectionModel2.setAnchorSelectionIndex(n19);
                }
            } else if (string.equals("extendTo")) {
                defaultListSelectionModel.setSelectionInterval(defaultListSelectionModel.getAnchorSelectionIndex(), n);
                defaultListSelectionModel2.setSelectionInterval(defaultListSelectionModel2.getAnchorSelectionIndex(), n3);
            } else if (string.equals("toggleAndAnchor")) {
                if (defaultListSelectionModel.isSelectedIndex(n)) {
                    defaultListSelectionModel.removeSelectionInterval(n, n);
                } else {
                    defaultListSelectionModel.addSelectionInterval(n, n);
                }
                if (defaultListSelectionModel2.isSelectedIndex(n3)) {
                    defaultListSelectionModel2.removeSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                }
                defaultListSelectionModel.setAnchorSelectionIndex(n);
                defaultListSelectionModel2.setAnchorSelectionIndex(n3);
            }
            if (this.this$0.table.isEditing() && string != "startEditing" && string != "addToSelection") {
                this.this$0.table.editingStopped(new ChangeEvent("update"));
            }
            this.this$0.table.scrollRectToVisible(this.this$0.table.getCellRect(defaultListSelectionModel.getLeadSelectionIndex(), defaultListSelectionModel2.getLeadSelectionIndex(), false));
            this.this$0.table.repaint();
        }

        int getFirstVisibleColumnIndex() {
            ComponentOrientation componentOrientation = this.this$0.table.getComponentOrientation();
            Rectangle rectangle = this.this$0.table.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return this.this$0.table.columnAtPoint(rectangle.getLocation());
        }

        int getLastVisibleColumnIndex() {
            ComponentOrientation componentOrientation = this.this$0.table.getComponentOrientation();
            Rectangle rectangle = this.this$0.table.getVisibleRect();
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return this.this$0.table.columnAtPoint(rectangle.getLocation());
        }

        int getFirstVisibleRowIndex() {
            ComponentOrientation componentOrientation = this.this$0.table.getComponentOrientation();
            Rectangle rectangle = this.this$0.table.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return this.this$0.table.rowAtPoint(rectangle.getLocation());
        }

        int getLastVisibleRowIndex() {
            ComponentOrientation componentOrientation = this.this$0.table.getComponentOrientation();
            Rectangle rectangle = this.this$0.table.getVisibleRect();
            rectangle.translate(0, (int)rectangle.getHeight() - 1);
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            if (this.this$0.table.rowAtPoint(rectangle.getLocation()) == -1) {
                if (this.getFirstVisibleRowIndex() == -1) {
                    return -1;
                }
                return this.this$0.table.getModel().getRowCount() - 1;
            }
            return this.this$0.table.rowAtPoint(rectangle.getLocation());
        }

        void advanceMultipleSelection(ListSelectionModel listSelectionModel, int n, int n2, ListSelectionModel listSelectionModel2, int n3, int n4, boolean bl, boolean bl2) {
            int n5;
            int n6 = listSelectionModel.getLeadSelectionIndex();
            int n7 = listSelectionModel2.getLeadSelectionIndex();
            int n8 = bl2 ? this.this$0.table.getModel().getColumnCount() : this.this$0.table.getModel().getRowCount();
            int n9 = n5 = bl2 ? this.this$0.table.getModel().getRowCount() : this.this$0.table.getModel().getColumnCount();
            if (n6 == n2 && !bl || bl && n6 == n) {
                listSelectionModel.addSelectionInterval(bl ? n2 : n, bl ? n2 : n);
                if (n7 == n4 && !bl || bl && n7 == n3) {
                    listSelectionModel2.addSelectionInterval(bl ? n4 : n3, bl ? n4 : n3);
                } else {
                    int n10;
                    int[] nArray;
                    if (bl2 && this.this$0.table.getRowSelectionAllowed() || !bl2 && this.this$0.table.getColumnSelectionAllowed()) {
                        nArray = bl2 ? this.this$0.table.getSelectedRows() : this.this$0.table.getSelectedColumns();
                    } else {
                        nArray = new int[n5];
                        for (n10 = 0; n10 < n5; ++n10) {
                            nArray[n10] = n10;
                        }
                    }
                    int n11 = n10 = bl ? nArray.length - 1 : 0;
                    if (!bl) {
                        while (nArray[n10] <= n7) {
                            ++n10;
                        }
                    } else {
                        while (nArray[n10] >= n7) {
                            --n10;
                        }
                    }
                    listSelectionModel2.addSelectionInterval(nArray[n10], nArray[n10]);
                }
            } else {
                int n12;
                int[] nArray;
                if (bl2 && this.this$0.table.getColumnSelectionAllowed() || !bl2 && this.this$0.table.getRowSelectionAllowed()) {
                    nArray = bl2 ? this.this$0.table.getSelectedColumns() : this.this$0.table.getSelectedRows();
                } else {
                    nArray = new int[n8];
                    for (n12 = 0; n12 < n8; ++n12) {
                        nArray[n12] = n12;
                    }
                }
                int n13 = n12 = bl ? nArray.length - 1 : 0;
                if (!bl) {
                    while (nArray[n12] <= n6) {
                        ++n12;
                    }
                } else {
                    while (nArray[n12] >= n6) {
                        --n12;
                    }
                }
                listSelectionModel.addSelectionInterval(nArray[n12], nArray[n12]);
                listSelectionModel2.addSelectionInterval(n7, n7);
            }
        }

        void advanceSingleSelection(ListSelectionModel listSelectionModel, int n, ListSelectionModel listSelectionModel2, int n2, boolean bl) {
            int n3 = listSelectionModel.getLeadSelectionIndex();
            int n4 = listSelectionModel2.getLeadSelectionIndex();
            if (bl && n3 == 0) {
                if (n4 == 0) {
                    n4 += n2 + 1;
                }
                n4 -= 2;
            }
            if (bl && n3 == 0 || !bl && n3 == n) {
                listSelectionModel2.setSelectionInterval((n4 + 1) % (n2 + 1), (n4 + 1) % (n2 + 1));
            } else {
                listSelectionModel2.setSelectionInterval(n4, n4);
            }
            if (bl) {
                if (n3 == 0) {
                    n3 += n + 1;
                }
                n3 -= 2;
            }
            listSelectionModel.setSelectionInterval((n3 + 1) % (n + 1), (n3 + 1) % (n + 1));
        }

        TableAction(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTableUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
                listSelectionModel.clearSelection();
                ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
                listSelectionModel2.clearSelection();
                TableModel tableModel = this.this$0.table.getModel();
                if (tableModel.getRowCount() > 0) {
                    listSelectionModel.setAnchorSelectionIndex(0);
                    listSelectionModel.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel.setAnchorSelectionIndex(-1);
                    listSelectionModel.setLeadSelectionIndex(-1);
                }
                if (tableModel.getColumnCount() > 0) {
                    listSelectionModel2.setAnchorSelectionIndex(0);
                    listSelectionModel2.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel2.setAnchorSelectionIndex(-1);
                    listSelectionModel2.setLeadSelectionIndex(-1);
                }
            }
        }

        PropertyChangeHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTableUI this$0;
        Point begin;
        Point curr;

        private void updateSelection(boolean bl) {
            int n = this.this$0.table.rowAtPoint(this.begin);
            int n2 = this.this$0.table.rowAtPoint(this.curr);
            ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
            if (n != -1 && n2 != -1) {
                if (bl && listSelectionModel.getSelectionMode() != 0) {
                    listSelectionModel.addSelectionInterval(n, n2);
                } else {
                    listSelectionModel.setSelectionInterval(n, n2);
                }
            }
            int n3 = this.this$0.table.columnAtPoint(this.begin);
            int n4 = this.this$0.table.columnAtPoint(this.curr);
            ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
            if (n3 != -1 && n4 != -1) {
                if (bl && listSelectionModel2.getSelectionMode() != 0) {
                    listSelectionModel2.addSelectionInterval(n3, n4);
                } else {
                    listSelectionModel2.setSelectionInterval(n3, n4);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.updateSelection(mouseEvent.isControlDown());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
                ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                int n2 = listSelectionModel2.getLeadSelectionIndex();
                this.begin = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isControlDown() && this.this$0.table.isCellSelected(this.this$0.table.rowAtPoint(this.begin), this.this$0.table.columnAtPoint(this.begin))) {
                    this.this$0.table.getSelectionModel().removeSelectionInterval(this.this$0.table.rowAtPoint(this.begin), this.this$0.table.rowAtPoint(this.begin));
                    this.this$0.table.getColumnModel().getSelectionModel().removeSelectionInterval(this.this$0.table.columnAtPoint(this.begin), this.this$0.table.columnAtPoint(this.begin));
                } else {
                    this.updateSelection(mouseEvent.isControlDown());
                }
                if ((n != listSelectionModel.getLeadSelectionIndex() || n2 != listSelectionModel2.getLeadSelectionIndex()) && this.this$0.table.isEditing()) {
                    this.this$0.table.editingStopped(new ChangeEvent(mouseEvent));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                this.begin = null;
                this.curr = null;
            }
        }

        public MouseInputHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicTableUI this$0;

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public FocusHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class KeyHandler
    implements KeyListener {
        private /* synthetic */ BasicTableUI this$0;

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public KeyHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }
}

