/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static EditorKit kit = new DefaultEditorKit();
    RootView rootView;
    JTextComponent textComponent;
    PropertyChangeHandler updateHandler;
    DocumentHandler documentHandler;
    Color background;
    Color inactiveBackground;
    private FocusListener focuslistener;

    private /* synthetic */ void finit$() {
        this.rootView = new RootView(this);
        this.updateHandler = new PropertyChangeHandler(this);
        this.documentHandler = new DocumentHandler(this);
        this.focuslistener = new FocusListener(this){
            private /* synthetic */ BasicTextUI this$0;
            {
                this.this$0 = basicTextUI;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.this$0.textComponent.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$0.textComponent.repaint();
            }
        };
    }

    public BasicTextUI() {
        this.finit$();
    }

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
        this.textComponent = (JTextComponent)jComponent;
        Document document = this.textComponent.getDocument();
        if (document == null) {
            document = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(document);
        }
        this.textComponent.addPropertyChangeListener(this.updateHandler);
        this.modelChanged();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Highlighter highlighter;
        Caret caret = this.textComponent.getCaret();
        if (caret == null) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, string + ".background", string + ".foreground", string + ".font");
        LookAndFeel.installBorder(this.textComponent, string + ".border");
        this.textComponent.setMargin(UIManager.getInsets(string + ".margin"));
        caret.setBlinkRate(UIManager.getInt(string + ".caretBlinkRate"));
        this.background = UIManager.getColor(string + ".background");
        this.inactiveBackground = UIManager.getColor(string + ".inactiveBackground");
        this.textComponent.setDisabledTextColor(UIManager.getColor(string + ".inactiveForeground"));
        this.textComponent.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        this.textComponent.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
    }

    protected void installListeners() {
        this.textComponent.addFocusListener(this.focuslistener);
        this.installDocumentListeners();
    }

    private void installDocumentListeners() {
        Document document = this.textComponent.getDocument();
        if (document != null) {
            document.addDocumentListener(this.documentHandler);
        }
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected Keymap createKeymap() {
        String string = this.getPropertyPrefix();
        JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])UIManager.get(string + ".keyBindings");
        if (keyBindingArray == null) {
            keyBindingArray = new JTextComponent.KeyBinding[]{};
            UIManager.put(string + ".keyBindings", keyBindingArray);
        }
        Keymap keymap = JTextComponent.addKeymap(this.getKeymapName(), JTextComponent.getKeymap("default"));
        JTextComponent.loadKeymap(keymap, keyBindingArray, this.textComponent.getActions());
        return keymap;
    }

    protected void installKeyboardActions() {
        Keymap keymap = JTextComponent.getKeymap(this.getKeymapName());
        if (keymap == null) {
            keymap = this.createKeymap();
        }
        this.textComponent.setKeymap(keymap);
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap(0));
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    InputMap getInputMap(int n) {
        String string = this.getPropertyPrefix();
        switch (n) {
            case 2: {
                return (InputMap)UIManager.get(string + ".windowInputMap");
            }
            case 1: {
                return (InputMap)UIManager.get(string + ".ancestorInputMap");
            }
        }
        return (InputMap)UIManager.get(string + ".focusInputMap");
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        ActionMap actionMap = (ActionMap)UIManager.get(string + ".actionMap");
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.put(string + ".actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        Action[] actionArray = this.textComponent.getActions();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        for (int i = 0; i < actionArray.length; ++i) {
            String string = (String)actionArray[i].getValue("Name");
            if (string == null) continue;
            actionMapUIResource.put(string, actionArray[i]);
        }
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.rootView.setView(null);
        this.textComponent.removePropertyChangeListener(this.updateHandler);
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.textComponent.removeFocusListener(this.focuslistener);
        this.textComponent.getDocument().removeDocumentListener(this.documentHandler);
    }

    protected void uninstallKeyboardActions() {
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent jComponent) {
        View view = this.getRootView(this.textComponent);
        float f = view.getPreferredSpan(0);
        float f2 = view.getPreferredSpan(1);
        return new Dimension((int)f, (int)f2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        this.paintSafely(graphics);
    }

    protected void paintSafely(Graphics graphics) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null && this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd()) {
            highlighter.paint(graphics);
        }
        this.rootView.paint(graphics, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(graphics);
        }
    }

    protected void paintBackground(Graphics graphics) {
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, null, null);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return 0;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return this.rootView.modelToView(n, this.getVisibleEditorRect(), bias).getBounds();
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, null);
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.rootView.viewToModel(point.x, point.y, this.getVisibleEditorRect(), biasArray);
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        JTextComponent jTextComponent = this.getComponent();
        int n = jTextComponent.getWidth();
        int n2 = jTextComponent.getHeight();
        if (n <= 0 || n2 <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Insets insets = jTextComponent.getInsets();
        return new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        view.setParent(this.rootView);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory viewFactory = this.rootView.getViewFactory();
        if (viewFactory == null) {
            return;
        }
        Document document = this.textComponent.getDocument();
        if (document == null) {
            return;
        }
        this.installDocumentListeners();
        Element element = document.getDefaultRootElement();
        if (element == null) {
            return;
        }
        View view = viewFactory.create(element);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    class DocumentHandler
    implements DocumentListener {
        private /* synthetic */ BasicTextUI this$0;

        public void changedUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.changedUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.insertUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.this$0.rootView.removeUpdate(documentEvent, this.this$0.getVisibleEditorRect(), this.this$0.rootView.getViewFactory());
        }

        DocumentHandler(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTextUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                this.this$0.modelChanged();
            }
            this.this$0.propertyChange(propertyChangeEvent);
        }

        PropertyChangeHandler(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
        }
    }

    private class RootView
    extends View {
        private /* synthetic */ BasicTextUI this$0;
        private View view;

        public RootView(BasicTextUI basicTextUI) {
            this.this$0 = basicTextUI;
            super(null);
        }

        public ViewFactory getViewFactory() {
            ViewFactory viewFactory = null;
            EditorKit editorKit = this.this$0.getEditorKit(this.this$0.getComponent());
            viewFactory = editorKit.getViewFactory();
            if (viewFactory == null) {
                viewFactory = this.this$0;
            }
            return viewFactory;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.this$0.textComponent.revalidate();
        }

        public void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (view != null) {
                view.setParent(null);
            }
            this.view = view;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            if (this.view != null) {
                return 1;
            }
            return 0;
        }

        public Container getContainer() {
            return this.this$0.textComponent;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                this.view.paint(graphics, shape);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.insertUpdate(documentEvent, shape, viewFactory);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.removeUpdate(documentEvent, shape, viewFactory);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.changedUpdate(documentEvent, shape, viewFactory);
        }

        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

