/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.text.JTextComponent;

public class MetalBorders {
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border desktopIconBorder;
    private static Border toolbarButtonBorder;
    private static Border textFieldBorder;
    private static Border textBorder;
    private static Border rolloverBorder;
    private static BasicBorders.MarginBorder marginBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            ButtonBorder buttonBorder = new ButtonBorder();
            Border border = MetalBorders.getMarginBorder();
            MetalBorders.buttonBorder = new BorderUIResource.CompoundBorderUIResource(buttonBorder, border);
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            ToggleButtonBorder toggleButtonBorder = new ToggleButtonBorder();
            Border border = MetalBorders.getMarginBorder();
            MetalBorders.toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(toggleButtonBorder, border);
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        if (desktopIconBorder == null) {
            desktopIconBorder = new DesktopIconBorder();
        }
        return desktopIconBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            Border border = MetalBorders.getMarginBorder();
            TextFieldBorder textFieldBorder = new TextFieldBorder();
            MetalBorders.textFieldBorder = new BorderUIResource.CompoundBorderUIResource(textFieldBorder, border);
        }
        return textFieldBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            Border border = MetalBorders.getMarginBorder();
            Flush3DBorder flush3DBorder = new Flush3DBorder();
            textBorder = new BorderUIResource.CompoundBorderUIResource(flush3DBorder, border);
        }
        return textBorder;
    }

    static Border getToolbarButtonBorder() {
        if (toolbarButtonBorder == null) {
            ButtonBorder buttonBorder = new ButtonBorder();
            RolloverMarginBorder rolloverMarginBorder = new RolloverMarginBorder();
            toolbarButtonBorder = new BorderUIResource.CompoundBorderUIResource(buttonBorder, rolloverMarginBorder);
        }
        return toolbarButtonBorder;
    }

    static Border getMarginBorder() {
        if (marginBorder == null) {
            marginBorder = new BasicBorders.MarginBorder();
        }
        return marginBorder;
    }

    static Border getRolloverBorder() {
        if (rolloverBorder == null) {
            RolloverButtonBorder rolloverButtonBorder = new RolloverButtonBorder();
            Border border = MetalBorders.getMarginBorder();
            rolloverBorder = new BorderUIResource.CompoundBorderUIResource(rolloverButtonBorder, border);
        }
        return rolloverBorder;
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(1, 1, 1, 1);

        public Insets getBorderInsets(Component component) {
            return this.editorBorderInsets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getWhite();
            Color color = graphics.getColor();
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n, n2, n + n3 - 2, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 2);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            JToolBar jToolBar = (JToolBar)component;
            if (jToolBar.getOrientation() == 0) {
                if (insets == null) {
                    insets = new Insets(2, 16, 2, 2);
                } else {
                    insets.top = 2;
                    insets.left = 16;
                    insets.bottom = 2;
                    insets.right = 2;
                }
                return insets;
            }
            if (insets == null) {
                insets = new Insets(16, 2, 2, 2);
            } else {
                insets.top = 16;
                insets.left = 2;
                insets.bottom = 2;
                insets.right = 2;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToolBar jToolBar = (JToolBar)component;
            if (jToolBar.getOrientation() == 0) {
                MetalUtils.fillMetalPattern(jToolBar, graphics, n + 2, n2 + 2, n + 11, n2 + n4 - 5, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
            } else {
                MetalUtils.fillMetalPattern(jToolBar, graphics, n + 2, n2 + 2, n + n3 - 5, n2 + 11, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
            }
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ButtonModel buttonModel = null;
            if (component instanceof AbstractButton) {
                buttonModel = ((AbstractButton)component).getModel();
            }
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlShadow();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getControl();
            if (component.isEnabled()) {
                graphics.setColor(colorUIResource);
                graphics.drawRect(n, n2, n3 - 2, n4 - 2);
                if (!buttonModel.isArmed()) {
                    graphics.setColor(colorUIResource3);
                    graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                    if (buttonModel.isSelected()) {
                        graphics.setColor(colorUIResource4);
                    }
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                    graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                } else {
                    graphics.setColor(colorUIResource3);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                    graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                }
                graphics.setColor(colorUIResource4);
                graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDisabled());
                graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            }
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            if (insets == null) {
                insets2 = new Insets(PopupMenuBorder.borderInsets.top, PopupMenuBorder.borderInsets.left, PopupMenuBorder.borderInsets.bottom, PopupMenuBorder.borderInsets.right);
            } else {
                insets2 = insets;
                insets2.top = PopupMenuBorder.borderInsets.top;
                insets2.left = PopupMenuBorder.borderInsets.left;
                insets2.bottom = PopupMenuBorder.borderInsets.bottom;
                insets2.right = PopupMenuBorder.borderInsets.right;
            }
            return insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlHighlight();
            graphics.setColor(colorUIResource);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
        }
    }

    static class RolloverMarginBorder
    extends AbstractBorder {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            AbstractButton abstractButton = (AbstractButton)component;
            Insets insets2 = abstractButton.getMargin();
            insets.bottom = RolloverMarginBorder.borderInsets.bottom;
            insets.left = RolloverMarginBorder.borderInsets.left;
            insets.right = RolloverMarginBorder.borderInsets.right;
            insets.top = RolloverMarginBorder.borderInsets.top;
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            if (component instanceof AbstractButton) {
                ButtonModel buttonModel = ((AbstractButton)component).getModel();
                bl = buttonModel.isRollover();
            }
            if (bl) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static Insets insets = new Insets(1, 1, 2, 2);

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlShadow();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getControl();
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2, n + n3 - 2, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4 + 1);
            graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
            graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + 2);
            graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
            graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);
        private static Color borderColor = new Color(153, 153, 153);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(borderColor);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = MenuBarBorder.borderInsets.left;
            insets.top = MenuBarBorder.borderInsets.top;
            insets.bottom = MenuBarBorder.borderInsets.bottom;
            insets.right = MenuBarBorder.borderInsets.right;
            return insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlHighlight();
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                if (jMenu.isSelected()) {
                    graphics.setColor(colorUIResource);
                    graphics.drawLine(n, n2, n, n2 + n4);
                    graphics.drawLine(n, n2, n + n3, n2);
                    graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4);
                }
            } else if (component instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)component;
                if (jMenuItem.isArmed()) {
                    graphics.setColor(colorUIResource);
                    graphics.drawLine(n, n2, n + n3, n2);
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
                } else {
                    graphics.setColor(colorUIResource2);
                    graphics.drawLine(n, n2, n, n2 + n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = MenuItemBorder.borderInsets.left;
            insets.top = MenuItemBorder.borderInsets.top;
            insets.bottom = MenuItemBorder.borderInsets.bottom;
            insets.right = MenuItemBorder.borderInsets.right;
            return insets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(3, 3, 3, 3);
            } else {
                insets.top = 3;
                insets.left = 3;
                insets.bottom = 3;
                insets.right = 3;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            if (jInternalFrame.getContentPane() instanceof JOptionPane) {
                Color color;
                JOptionPane jOptionPane = (JOptionPane)jInternalFrame.getContentPane();
                int n5 = jOptionPane.getMessageType();
                if (n5 == 3 && (color = UIManager.getColor("OptionPane.questionDialog.border.background")) != null) {
                    graphics.setColor(color);
                }
                if (n5 == 2) {
                    color = UIManager.getColor("OptionPane.warningDialog.border.background");
                    if (color != null) {
                        graphics.setColor(color);
                    }
                } else if (n5 == 0 && (color = UIManager.getColor("OptionPane.errorDialog.border.background")) != null) {
                    graphics.setColor(color);
                }
            }
            graphics.fillRect(n, n2, n3, 3);
            graphics.fillRect(n, n2, 3, n4);
            graphics.fillRect(n + n3 - 3, n2, 3, n4);
            graphics.fillRect(n, n2 + n4 - 3, n3, 3);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.fillRect(n, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n, n2 + n4 - 1, 1, 1);
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(5, 5, 5, 5);
            } else {
                insets.top = 5;
                insets.left = 5;
                insets.bottom = 5;
                insets.right = 5;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            if (jInternalFrame.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.fillRect(n, n2, n3, 5);
            graphics.fillRect(n, n2, 5, n4);
            graphics.fillRect(n + n3 - 5, n2, 5, n4);
            graphics.fillRect(n, n2 + n4 - 5, n3, 5);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.fillRect(n, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 14, n2 + 2, n + n3 - 15, n2 + 2);
            graphics.drawLine(n + 14, n2 + n4 - 3, n + n3 - 15, n2 + n4 - 3);
            graphics.drawLine(n + 2, n2 + 14, n + 2, n2 + n4 - 15);
            graphics.drawLine(n + n3 - 3, n2 + 14, n + n3 - 3, n2 + n4 - 15);
            if (jInternalFrame.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
            }
            graphics.drawLine(n + 15, n2 + 3, n + n3 - 14, n2 + 3);
            graphics.drawLine(n + 15, n2 + n4 - 2, n + n3 - 14, n2 + n4 - 2);
            graphics.drawLine(n + 3, n2 + 15, n + 3, n2 + n4 - 14);
            graphics.drawLine(n + n3 - 2, n2 + 15, n + n3 - 2, n2 + n4 - 14);
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder
    implements UIResource {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Serializable serializable;
            boolean bl = component instanceof JTextComponent ? (serializable = (JTextComponent)component).isEnabled() && serializable.isEditable() : false;
            if (bl) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            } else {
                serializable = graphics.getColor();
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics.setColor((Color)serializable);
            }
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(1, 1, 1, 1);
            } else {
                insets.top = 1;
                insets.left = 1;
                insets.bottom = 1;
                insets.right = 1;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.fillRect(n, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            graphics.setColor(color);
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(2, 2, 2, 2);
            } else {
                insets.top = 2;
                insets.left = 2;
                insets.bottom = 2;
                insets.right = 2;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.setColor(color);
        }
    }

    static class DesktopIconBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(3, 3, 2, 3);
            } else {
                insets.top = 3;
                insets.left = 3;
                insets.bottom = 2;
                insets.right = 3;
            }
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanButtonBorder(component, graphics, n, n2, n3, n4);
            } else {
                ButtonModel buttonModel = null;
                if (component instanceof AbstractButton) {
                    buttonModel = ((AbstractButton)component).getModel();
                }
                ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
                ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlShadow();
                ColorUIResource colorUIResource3 = MetalLookAndFeel.getControlHighlight();
                ColorUIResource colorUIResource4 = MetalLookAndFeel.getControl();
                if (component.isEnabled()) {
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 2, n4 - 2);
                    if (!buttonModel.isPressed()) {
                        graphics.setColor(colorUIResource3);
                        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                        graphics.setColor(colorUIResource4);
                        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                    } else {
                        graphics.setColor(colorUIResource3);
                        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                        graphics.setColor(colorUIResource4);
                        graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                        graphics.setColor(colorUIResource2);
                        graphics.drawRect(n + 1, n2 + n4 - 2, 0, 0);
                        graphics.drawRect(n + n3 - 2, n2 + 1, 0, 0);
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                    graphics.drawRect(n, n2, n3 - 2, n4 - 2);
                }
            }
        }

        private void paintOceanButtonBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ButtonModel buttonModel = null;
            if (component instanceof AbstractButton) {
                buttonModel = ((AbstractButton)component).getModel();
            }
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlShadow();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getControlHighlight();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getControl();
            if (component.isEnabled()) {
                if (buttonModel.isPressed()) {
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
                } else if (buttonModel.isRollover()) {
                    graphics.setColor(colorUIResource2);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    graphics.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
                } else {
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = ButtonBorder.borderInsets.bottom;
            insets.left = ButtonBorder.borderInsets.left;
            insets.right = ButtonBorder.borderInsets.right;
            insets.top = ButtonBorder.borderInsets.top;
            return insets;
        }
    }
}

