/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly;

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, jComboBox.isEditable(), cellRendererPane, jList);
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        if (jComboBox == null) {
            throw new NullPointerException("Null 'cb' argument");
        }
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl;
        this.listBox = jList;
        this.rendererPane = cellRendererPane;
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.iconOnly) {
            Rectangle rectangle = this.getBounds();
            int n = (rectangle.width - this.comboIcon.getIconWidth()) / 2;
            int n2 = (rectangle.height - this.comboIcon.getIconHeight()) / 2;
            this.comboIcon.paintIcon(this.comboBox, graphics, n, n2);
        } else {
            Object object = this.comboBox.getModel().getSelectedItem();
            if (object == null) {
                object = "";
            }
            Rectangle rectangle = this.comboBox.getBounds();
            Rectangle rectangle2 = SwingUtilities.calculateInnerArea(this, null);
            Insets insets = this.comboBox.getInsets();
            Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width - this.comboIcon.getIconWidth() - 4, rectangle2.height);
            Component component = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, object, this.comboBox.getSelectedIndex(), false, false);
            component.setBackground(this.comboBox.getBackground());
            component.setEnabled(this.comboBox.isEnabled());
            this.rendererPane.paintComponent(graphics, component, this, rectangle3);
            if (this.comboBox.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getFocusColor());
                graphics.drawRect(rectangle2.x, rectangle2.y - 1, rectangle2.width - 1, rectangle2.height);
            }
            int n = rectangle.width - insets.right - this.comboIcon.getIconWidth() - 7;
            int n3 = insets.top + (rectangle.height - this.comboIcon.getIconHeight()) / 2;
            this.comboIcon.paintIcon(this.comboBox, graphics, n, n3);
        }
    }
}

