/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    DirectoryComboBoxModel directoryModel;

    public static ComponentUI createUI(JComponent jComponent) {
        JFileChooser jFileChooser = (JFileChooser)jComponent;
        return new MetalFileChooserUI(jFileChooser);
    }

    public MetalFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel(this);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel(this);
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer(this);
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;

        public FilterComboBoxRenderer(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FileFilter fileFilter = (FileFilter)object;
            return super.getListCellRendererComponent(jList, fileFilter.getDescription(), n, bl, bl2);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private /* synthetic */ MetalFileChooserUI this$0;
        protected FileFilter[] filters = new FileFilter[1];
        private int selectedIndex;

        protected FilterComboBoxModel(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
            this.filters[0] = metalFileChooserUI.getAcceptAllFileFilter(metalFileChooserUI.getFileChooser());
            this.selectedIndex = 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                this.selectedIndex = -1;
                FileFilter fileFilter = (FileFilter)propertyChangeEvent.getNewValue();
                for (int i = 0; i < this.filters.length; ++i) {
                    if (!this.filters[i].equals(fileFilter)) continue;
                    this.selectedIndex = i;
                }
                this.fireContentsChanged(this, -1, -1);
            } else if (propertyChangeEvent.getPropertyName().equals("ChoosableFileFilterChangedProperty")) {
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                this.filters = fileFilterArray;
                this.fireContentsChanged(this, 0, this.filters.length);
            }
        }

        public void setSelectedItem(Object object) {
            this.this$0.getFileChooser().setFileFilter((FileFilter)object);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.filters[this.selectedIndex];
            }
            return null;
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int n) {
            return this.filters[n];
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;

        protected FileRenderer(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FileView fileView = this.this$0.getFileView(this.this$0.getFileChooser());
            File file = (File)object;
            this.setText(fileView.getName(file));
            this.setIcon(fileView.getIcon(file));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultListCellRenderer.noFocusBorder);
            }
            return this;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        private /* synthetic */ MetalFileChooserUI this$0;

        protected DirectoryComboBoxAction(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            jFileChooser.setCurrentDirectory((File)this.this$0.directoryModel.getSelectedItem());
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private /* synthetic */ MetalFileChooserUI this$0;
        private List items = new ArrayList();
        private int selectedIndex = -1;

        public DirectoryComboBoxModel(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        public int getDepth(int n) {
            return Math.max(n, 0);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            this.items.clear();
            FileSystemView fileSystemView = this.this$0.getFileChooser().getFileSystemView();
            File file = (File)object;
            while (file != null) {
                this.items.add(0, file);
                file = fileSystemView.getParentDirectory(file);
            }
            this.selectedIndex = this.items.indexOf(object);
            this.fireContentsChanged(this, 0, this.items.size() - 1);
        }
    }
}

