/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    static final long serialVersionUID = 7878911414715528324L;
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    Color foreground;
    Color background;

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
    }

    public void updateUI() {
        super.updateUI();
        this.background = null;
        this.foreground = null;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            if (object instanceof JTextField) {
                return new JTextField(((JTextField)object).getText());
            }
            super.setText(object.toString());
        }
        this.setOpaque(true);
        if (jTable == null) {
            return this;
        }
        if (bl) {
            super.setBackground(jTable.getSelectionBackground());
            super.setForeground(jTable.getSelectionForeground());
        } else {
            if (this.background != null) {
                super.setBackground(this.background);
            } else {
                super.setBackground(jTable.getBackground());
            }
            if (this.foreground != null) {
                super.setForeground(this.foreground);
            } else {
                super.setForeground(jTable.getForeground());
            }
        }
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
            }
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.setEnabled(jTable.isEnabled());
        this.setFont(jTable.getFont());
        Color color = this.getBackground();
        this.setOpaque(color != null && color.equals(jTable.getBackground()));
        return this;
    }

    public boolean isOpaque() {
        return true;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        super.setText(object != null ? object.toString() : "");
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

